/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.tx.control.resource.common.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.osgi.framework.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TrackingResourceProviderFactory<T extends AutoCloseable> {
    private static final Logger LOG = LoggerFactory.getLogger(TrackingResourceProviderFactory.class);
    private final List<T> toClose = new ArrayList<T>();
    private boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T doGetResult(Callable<T> getter) {
        AutoCloseable t;
        Callable<T> callable = getter;
        synchronized (callable) {
            if (this.closed) {
                throw new IllegalStateException("This ResourceProvider has been reclaimed because the factory service that provided it was released");
            }
        }
        try {
            t = (AutoCloseable)getter.call();
        }
        catch (Exception e) {
            LOG.warn("A failure occurred obtaining the resource provider", (Throwable)e);
            throw new ServiceException("A failure occurred obtaining the resource provider", (Throwable)e);
        }
        boolean destroy = false;
        List<T> list = this.toClose;
        synchronized (list) {
            if (this.closed) {
                destroy = true;
            } else {
                this.toClose.add(t);
            }
        }
        if (destroy) {
            try {
                t.close();
            }
            catch (Exception e) {
                LOG.warn("A failure occurred closing the resource provider", (Throwable)e);
            }
            throw new IllegalStateException("This ResourceProvider has been reclaimed because the factory service that provided it was released");
        }
        return (T)t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        List<T> list = this.toClose;
        synchronized (list) {
            this.closed = true;
        }
        this.toClose.stream().forEach(ajcp -> {
            try {
                ajcp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.toClose.clear();
    }
}

