/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.tx.control.jdbc.xa.impl;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.aries.tx.control.jdbc.common.impl.DriverDataSource;
import org.apache.aries.tx.control.jdbc.common.impl.InternalJDBCConnectionProviderFactory;
import org.apache.aries.tx.control.jdbc.xa.connection.impl.XADataSourceMapper;
import org.apache.aries.tx.control.jdbc.xa.impl.JDBCConnectionProviderImpl;
import org.apache.aries.tx.control.jdbc.xa.impl.ManagedServiceFactoryImpl;
import org.osgi.service.jdbc.DataSourceFactory;
import org.osgi.service.transaction.control.TransactionException;
import org.osgi.service.transaction.control.jdbc.JDBCConnectionProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCConnectionProviderFactoryImpl
implements JDBCConnectionProviderFactory,
InternalJDBCConnectionProviderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedServiceFactoryImpl.class);

    @Override
    public JDBCConnectionProviderImpl getProviderFor(DataSourceFactory dsf, Properties jdbcProperties, Map<String, Object> resourceProviderProperties) {
        DataSource unpooled;
        boolean xaEnabled = JDBCConnectionProviderFactoryImpl.toBoolean(resourceProviderProperties, "osgi.xa.enabled", true);
        boolean localEnabled = JDBCConnectionProviderFactoryImpl.toBoolean(resourceProviderProperties, "osgi.local.enabled", true);
        boolean useDriver = JDBCConnectionProviderFactoryImpl.toBoolean(resourceProviderProperties, "osgi.use.driver", false);
        this.checkEnlistment(xaEnabled, localEnabled, !useDriver);
        try {
            unpooled = useDriver ? new DriverDataSource(dsf.createDriver(null), jdbcProperties.getProperty("url"), jdbcProperties) : (xaEnabled ? new XADataSourceMapper(dsf.createXADataSource(jdbcProperties)) : dsf.createDataSource(jdbcProperties));
        }
        catch (SQLException sqle) {
            throw new TransactionException("Unable to create the JDBC resource provider", (Throwable)sqle);
        }
        DataSource toUse = this.poolIfNecessary(resourceProviderProperties, unpooled);
        return new JDBCConnectionProviderImpl(toUse, xaEnabled, localEnabled, this.getRecoveryId(resourceProviderProperties, xaEnabled));
    }

    private String getRecoveryId(Map<String, Object> resourceProviderProps, boolean xaEnabled) {
        String recoveryIdentifier = Optional.ofNullable(resourceProviderProps).map(m -> m.get("osgi.recovery.identifier")).map(String::valueOf).orElse(null);
        if (recoveryIdentifier != null && !xaEnabled) {
            LOG.warn("A recovery identifier {} has been declared, but the JDBCConnectionProvider is configured to disable XA", (Object)recoveryIdentifier);
        }
        return recoveryIdentifier;
    }

    @Override
    public JDBCConnectionProviderImpl getProviderFor(DataSource ds, Map<String, Object> resourceProviderProperties) {
        boolean xaEnabled = JDBCConnectionProviderFactoryImpl.toBoolean(resourceProviderProperties, "osgi.xa.enabled", true);
        boolean localEnabled = JDBCConnectionProviderFactoryImpl.toBoolean(resourceProviderProperties, "osgi.local.enabled", true);
        try {
            this.checkEnlistment(xaEnabled, localEnabled, ds.isWrapperFor(XADataSource.class));
            DataSource toUse = this.poolIfNecessary(resourceProviderProperties, xaEnabled ? new XADataSourceMapper(ds.unwrap(XADataSource.class)) : ds);
            return new JDBCConnectionProviderImpl(toUse, xaEnabled, localEnabled, this.getRecoveryId(resourceProviderProperties, xaEnabled));
        }
        catch (SQLException sqle) {
            throw new TransactionException("Unable to create the JDBC resource provider", (Throwable)sqle);
        }
    }

    @Override
    public JDBCConnectionProviderImpl getProviderFor(Driver driver, Properties jdbcProperties, Map<String, Object> resourceProviderProperties) {
        boolean xaEnabled = JDBCConnectionProviderFactoryImpl.toBoolean(resourceProviderProperties, "osgi.xa.enabled", false);
        boolean localEnabled = JDBCConnectionProviderFactoryImpl.toBoolean(resourceProviderProperties, "osgi.local.enabled", true);
        this.checkEnlistment(xaEnabled, localEnabled, false);
        DataSource toUse = this.poolIfNecessary(resourceProviderProperties, new DriverDataSource(driver, jdbcProperties.getProperty("url"), jdbcProperties));
        return new JDBCConnectionProviderImpl(toUse, xaEnabled, localEnabled, this.getRecoveryId(resourceProviderProperties, xaEnabled));
    }

    @Override
    public JDBCConnectionProviderImpl getProviderFor(XADataSource ds, Map<String, Object> resourceProviderProperties) {
        boolean xaEnabled = JDBCConnectionProviderFactoryImpl.toBoolean(resourceProviderProperties, "osgi.xa.enabled", true);
        boolean localEnabled = JDBCConnectionProviderFactoryImpl.toBoolean(resourceProviderProperties, "osgi.local.enabled", true);
        this.checkEnlistment(xaEnabled, localEnabled, true);
        XADataSourceMapper unpooled = new XADataSourceMapper(ds);
        return new JDBCConnectionProviderImpl(this.poolIfNecessary(resourceProviderProperties, unpooled), xaEnabled, localEnabled, this.getRecoveryId(resourceProviderProperties, xaEnabled));
    }

    private void checkEnlistment(boolean xaEnabled, boolean localEnabled, boolean isXA) {
        if (!xaEnabled && !localEnabled) {
            throw new TransactionException("The configuration supports neither local nor XA transactions");
        }
        if (xaEnabled && !isXA) {
            throw new TransactionException("The configuration is XA enabled but the resource is not suitable for XA enlistment");
        }
    }

    private DataSource poolIfNecessary(Map<String, Object> resourceProviderProperties, DataSource unpooled) {
        DataSource toUse;
        if (JDBCConnectionProviderFactoryImpl.toBoolean(resourceProviderProperties, "osgi.connection.pooling.enabled", true)) {
            HikariConfig hcfg = new HikariConfig();
            hcfg.setDataSource(unpooled);
            hcfg.setMaximumPoolSize(this.toInt(resourceProviderProperties, "osgi.connection.max", 10));
            hcfg.setMinimumIdle(this.toInt(resourceProviderProperties, "osgi.connection.min", 10));
            hcfg.setConnectionTimeout(this.toLong(resourceProviderProperties, "osgi.connection.timeout", TimeUnit.SECONDS.toMillis(30L)));
            hcfg.setIdleTimeout(this.toLong(resourceProviderProperties, "osgi.idle.timeout", TimeUnit.MINUTES.toMillis(3L)));
            hcfg.setMaxLifetime(this.toLong(resourceProviderProperties, "osgi.connection.lifetime", TimeUnit.HOURS.toMillis(3L)));
            toUse = new HikariDataSource(hcfg);
        } else {
            toUse = unpooled;
        }
        return toUse;
    }

    static boolean toBoolean(Map<String, Object> props, String key, boolean defaultValue) {
        Object o = Optional.ofNullable(props).map(m -> m.get(key)).orElse(defaultValue);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return Boolean.parseBoolean((String)o);
        }
        throw new IllegalArgumentException("The property " + key + " cannot be converted to a boolean");
    }

    private int toInt(Map<String, Object> props, String key, int defaultValue) {
        Object o = Optional.ofNullable(props).map(m -> m.get(key)).orElse(defaultValue);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof String) {
            return Integer.parseInt((String)o);
        }
        throw new IllegalArgumentException("The property " + key + " cannot be converted to an int");
    }

    private long toLong(Map<String, Object> props, String key, long defaultValue) {
        Object o = Optional.ofNullable(props).map(m -> m.get(key)).orElse(defaultValue);
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof String) {
            return Long.parseLong((String)o);
        }
        throw new IllegalArgumentException("The property " + key + " cannot be converted to a long");
    }
}

