/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.spifly.statictool;

import org.objectweb.asm.ClassWriter;

public final class StaticToolClassWriter
extends ClassWriter {
    private static final String OBJECT_INTERNAL_NAME = "java/lang/Object";
    private final ClassLoader loader;

    public StaticToolClassWriter(int flags, ClassLoader loader) {
        super(flags);
        this.loader = loader;
    }

    protected String getCommonSuperClass(String type1, String type2) {
        Class<?> d;
        Class<?> c;
        try {
            c = Class.forName(type1.replace('/', '.'), false, this.loader);
            d = Class.forName(type2.replace('/', '.'), false, this.loader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (c.isAssignableFrom(d)) {
            return type1;
        }
        if (d.isAssignableFrom(c)) {
            return type2;
        }
        if (c.isInterface() || d.isInterface()) {
            return OBJECT_INTERNAL_NAME;
        }
        while (!(c = c.getSuperclass()).isAssignableFrom(d)) {
        }
        return c.getName().replace('.', '/');
    }
}

