/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.spifly.statictool;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.aries.spifly.ConsumerHeaderProcessor;
import org.apache.aries.spifly.Streams;
import org.apache.aries.spifly.Util;
import org.apache.aries.spifly.statictool.DirTree;
import org.apache.aries.spifly.statictool.StaticToolClassWriter;
import org.apache.aries.spifly.weaver.TCCLSetterVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.osgi.framework.Version;

public class Main {
    private static final String MODIFIED_BUNDLE_SUFFIX = "_spifly.jar";
    private static final String IMPORT_PACKAGE = "Import-Package";

    public static void usage() {
        System.err.println("This tool processes OSGi Bundles that use java.util.ServiceLoader.load() to");
        System.err.println("obtain implementations via META-INF/services. The byte code in the bundles is");
        System.err.println("modified so that the ThreadContextClassLoader is set appropriately for the ");
        System.err.println("duration of the java.util.ServiceLoader.load() call.");
        System.err.println("To opt-in to this process, bundles need to have the following MANIFEST.MF");
        System.err.println("header set:");
        System.err.println("    SPI-Consumer: *");
        System.err.println("Modified bundles are written out under the following name:");
        System.err.println("    <original-bundle-name>_spifly.jar");
        System.err.println();
        System.err.println("Usage: java " + Main.class.getName() + " bundle1.jar bundle2.jar ...");
        System.exit(-1);
    }

    public static void main(String ... args) throws Exception {
        if (args.length < 1) {
            Main.usage();
        }
        for (String arg : args) {
            Main.weaveJar(arg);
        }
    }

    private static void weaveJar(String jarPath) throws Exception {
        System.out.println("[SPI Fly Static Tool] Processing: " + jarPath);
        File jarFile = new File(jarPath);
        File tempDir = new File(System.getProperty("java.io.tmpdir") + File.separator + jarFile.getName() + "_" + System.currentTimeMillis());
        Manifest manifest = Main.unJar(jarFile, tempDir);
        String consumerHeaderVal = manifest.getMainAttributes().getValue("SPI-Consumer");
        String consumerHeaderKey = null;
        if (consumerHeaderVal != null) {
            consumerHeaderKey = "SPI-Consumer";
        } else {
            consumerHeaderVal = manifest.getMainAttributes().getValue("Require-Capability");
            if (consumerHeaderVal != null) {
                consumerHeaderKey = "Require-Capability";
            }
        }
        if (consumerHeaderVal != null) {
            String bcp = manifest.getMainAttributes().getValue("Bundle-ClassPath");
            Main.weaveDir(tempDir, consumerHeaderKey, consumerHeaderVal, bcp);
            if ("SPI-Consumer".equals(consumerHeaderKey)) {
                manifest.getMainAttributes().remove(new Attributes.Name("SPI-Consumer"));
                manifest.getMainAttributes().putValue("X-SpiFly-Processed-SPI-Consumer", consumerHeaderVal);
            } else {
                String newConsumerHeaderVal = consumerHeaderVal.replaceAll("osgi[.]extender;\\s*filter[:][=][\"]?[(]osgi[.]extender[=]osgi[.]serviceloader[.]processor[)][\"]?", "").trim();
                if (newConsumerHeaderVal.startsWith(",")) {
                    newConsumerHeaderVal = newConsumerHeaderVal.substring(1);
                }
                if (newConsumerHeaderVal.endsWith(",")) {
                    newConsumerHeaderVal = newConsumerHeaderVal.substring(0, newConsumerHeaderVal.length() - 1);
                }
                manifest.getMainAttributes().putValue("Require-Capability", newConsumerHeaderVal);
                manifest.getMainAttributes().putValue("X-SpiFly-Processed-Require-Capability", consumerHeaderVal);
            }
            Main.extendImportPackage(manifest);
            File newJar = Main.getNewJarFile(jarFile);
            Main.jar(newJar, tempDir, manifest);
        } else {
            System.out.println("[SPI Fly Static Tool] This file is not marked as an SPI Consumer.");
        }
        Main.delTree(tempDir);
    }

    private static void extendImportPackage(Manifest manifest) throws IOException {
        String utilPkgVersion = Main.getPackageVersion(Util.class);
        Version osgiVersion = Version.parseVersion((String)utilPkgVersion);
        Version minVersion = new Version(osgiVersion.getMajor(), osgiVersion.getMinor(), osgiVersion.getMicro());
        Version maxVersion = new Version(osgiVersion.getMajor(), osgiVersion.getMinor() + 1, 0);
        String ip = manifest.getMainAttributes().getValue(IMPORT_PACKAGE);
        if (ip == null) {
            ip = "";
        }
        StringBuilder sb = new StringBuilder(ip);
        if (ip.length() > 0) {
            sb.append(",");
        }
        sb.append(Util.class.getPackage().getName());
        sb.append(";version=\"[");
        sb.append(minVersion);
        sb.append(",");
        sb.append(maxVersion);
        sb.append(")\"");
        manifest.getMainAttributes().putValue(IMPORT_PACKAGE, sb.toString());
    }

    private static String getPackageVersion(Class<?> clazz) throws IOException {
        URL url = clazz.getResource("packageinfo");
        if (url == null) {
            throw new RuntimeException("'packageinfo' file with version information not found for package: " + clazz.getPackage().getName());
        }
        byte[] bytes = Streams.suck((InputStream)url.openStream());
        Properties p = new Properties();
        p.load(new ByteArrayInputStream(bytes));
        return p.getProperty("version");
    }

    private static File getNewJarFile(File jarFile) {
        String s = jarFile.getAbsolutePath();
        int idx = s.lastIndexOf(46);
        s = s.substring(0, idx);
        s = s + MODIFIED_BUNDLE_SUFFIX;
        return new File(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void weaveDir(File dir, String consumerHeaderKey, String consumerHeaderValue, String bundleClassPath) throws Exception {
        Set wd = ConsumerHeaderProcessor.processHeader((String)consumerHeaderKey, (String)consumerHeaderValue);
        URLClassLoader cl = new URLClassLoader(new URL[]{dir.toURI().toURL()}, Main.class.getClassLoader());
        String dirName = dir.getAbsolutePath();
        DirTree dt = new DirTree(dir);
        for (File f : dt.getFiles()) {
            byte[] b;
            if (!f.getName().endsWith(".class")) continue;
            String className = f.getAbsolutePath().substring(dirName.length());
            if (className.startsWith(File.separator)) {
                className = className.substring(1);
            }
            className = className.substring(0, className.length() - ".class".length());
            className = className.replace(File.separator, ".");
            FileInputStream is = new FileInputStream(f);
            try {
                ClassReader cr = new ClassReader((InputStream)is);
                StaticToolClassWriter cw = new StaticToolClassWriter(3, cl);
                TCCLSetterVisitor cv = new TCCLSetterVisitor((ClassVisitor)cw, className, wd);
                cr.accept((ClassVisitor)cv, 4);
                b = cv.isWoven() ? cw.toByteArray() : Streams.suck((InputStream)new FileInputStream(f));
            }
            finally {
                ((InputStream)is).close();
            }
            FileOutputStream os = new FileOutputStream(f);
            try {
                ((OutputStream)os).write(b);
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        if (bundleClassPath != null) {
            for (String entry : bundleClassPath.split(",")) {
                File jarFile = new File(dir, entry.trim());
                if (!jarFile.isFile()) continue;
                Main.weaveBCPJar(jarFile, consumerHeaderKey, consumerHeaderValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void weaveBCPJar(File jarFile, String consumerHeaderKey, String consumerHeaderVal) throws Exception {
        File tempDir = new File(System.getProperty("java.io.tmpdir") + File.separator + jarFile.getName() + "_" + System.currentTimeMillis());
        try {
            Manifest manifest = Main.unJar(jarFile, tempDir);
            Main.weaveDir(tempDir, consumerHeaderKey, consumerHeaderVal, null);
            if (!jarFile.delete()) {
                throw new IOException("Could not replace file: " + jarFile);
            }
            Main.jar(jarFile, tempDir, manifest);
        }
        finally {
            Main.delTree(tempDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Manifest unJar(File jarFile, File tempDir) throws IOException {
        Main.ensureDirectory(tempDir);
        JarInputStream jis = new JarInputStream(new FileInputStream(jarFile));
        JarEntry je = null;
        while ((je = jis.getNextJarEntry()) != null) {
            if (je.isDirectory()) {
                File outDir = new File(tempDir, je.getName());
                Main.ensureDirectory(outDir);
                continue;
            }
            File outFile = new File(tempDir, je.getName());
            File outDir = outFile.getParentFile();
            Main.ensureDirectory(outDir);
            FileOutputStream out = new FileOutputStream(outFile);
            try {
                Streams.pump((InputStream)jis, (OutputStream)out);
            }
            finally {
                out.flush();
                ((OutputStream)out).close();
                jis.closeEntry();
            }
            outFile.setLastModified(je.getTime());
        }
        Manifest manifest = jis.getManifest();
        if (manifest != null) {
            File mf = new File(tempDir, "META-INF/MANIFEST.MF");
            File mfDir = mf.getParentFile();
            Main.ensureDirectory(mfDir);
            FileOutputStream out = new FileOutputStream(mf);
            try {
                manifest.write(out);
            }
            finally {
                out.flush();
                ((OutputStream)out).close();
            }
        }
        jis.close();
        return manifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void jar(File jarFile, File rootFile, Manifest manifest) throws IOException {
        JarOutputStream jos = new JarOutputStream((OutputStream)new FileOutputStream(jarFile), manifest);
        try {
            Main.addToJarRecursively(jos, rootFile.getAbsoluteFile(), rootFile.getAbsolutePath());
        }
        finally {
            jos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addToJarRecursively(JarOutputStream jar, File source, String rootDirectory) throws IOException {
        String sourceName = source.getAbsolutePath().replace("\\", "/");
        if ((sourceName = sourceName.substring(rootDirectory.length())).startsWith("/")) {
            sourceName = sourceName.substring(1);
        }
        if ("META-INF/MANIFEST.MF".equals(sourceName)) {
            return;
        }
        if (source.isDirectory()) {
            for (File nested : source.listFiles()) {
                Main.addToJarRecursively(jar, nested, rootDirectory);
            }
            return;
        }
        JarEntry entry = new JarEntry(sourceName);
        jar.putNextEntry(entry);
        FileInputStream is = new FileInputStream(source);
        try {
            Streams.pump((InputStream)is, (OutputStream)jar);
        }
        finally {
            jar.closeEntry();
            ((InputStream)is).close();
        }
    }

    static void delTree(File tempDir) throws IOException {
        for (File f : new DirTree(tempDir).getFiles()) {
            if (f.delete()) continue;
            throw new IOException("Problem deleting file: " + tempDir.getAbsolutePath());
        }
    }

    private static void ensureDirectory(File outDir) throws IOException {
        if (!outDir.isDirectory() && !outDir.mkdirs()) {
            throw new IOException("Unable to create directory " + outDir.getAbsolutePath());
        }
    }
}

