/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.spifly;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.aries.spifly.BaseActivator;
import org.apache.aries.spifly.MultiDelegationClassloader;
import org.apache.aries.spifly.Pair;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.osgi.framework.ServicePermission;

public class Util {
    static ThreadLocal<ClassLoader> storedClassLoaders = new ThreadLocal();

    public static void storeContextClassloader() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                storedClassLoaders.set(Thread.currentThread().getContextClassLoader());
                return null;
            }
        });
    }

    public static void restoreContextClassloader() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Thread.currentThread().setContextClassLoader(storedClassLoaders.get());
                storedClassLoaders.set(null);
                return null;
            }
        });
    }

    public static void fixContextClassloader(String cls, String method, Class<?> clsArg, ClassLoader bundleLoader) {
        if (!(bundleLoader instanceof BundleReference)) {
            BaseActivator.activator.log(2, "Classloader of consuming bundle doesn't implement BundleReference: " + bundleLoader);
            return;
        }
        BundleReference br = (BundleReference)bundleLoader;
        final ClassLoader cl = Util.findContextClassloader(br.getBundle(), cls, method, clsArg);
        if (cl != null) {
            BaseActivator.activator.log(3, "Temporarily setting Thread Context Classloader to: " + cl);
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Thread.currentThread().setContextClassLoader(cl);
                    return null;
                }
            });
        } else {
            BaseActivator.activator.log(2, "No classloader found for " + cls + ":" + method + "(" + clsArg + ")");
        }
    }

    private static ClassLoader findContextClassloader(Bundle consumerBundle, String className, String methodName, Class<?> clsArg) {
        HashMap<Pair<Integer, String>, String> args;
        String requestedClass;
        BaseActivator activator = BaseActivator.activator;
        if (ServiceLoader.class.getName().equals(className) && "load".equals(methodName)) {
            requestedClass = clsArg.getName();
            args = new HashMap<Pair<Integer, String>, String>();
            args.put(new Pair<Integer, String>(0, Class.class.getName()), requestedClass);
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                try {
                    sm.checkPermission((Permission)new ServicePermission(requestedClass, "get"));
                }
                catch (AccessControlException ace) {
                    activator.log(3, "No permission to obtain service of type: " + requestedClass);
                    return null;
                }
            }
        } else {
            requestedClass = className;
            args = null;
        }
        ArrayList<Bundle> bundles = new ArrayList<Bundle>(activator.findProviderBundles(requestedClass));
        activator.log(4, "Found bundles providing " + requestedClass + ": " + bundles);
        Collection<Bundle> allowedBundles = activator.findConsumerRestrictions(consumerBundle, className, methodName, args);
        if (allowedBundles != null) {
            Iterator it = bundles.iterator();
            while (it.hasNext()) {
                if (allowedBundles.contains(it.next())) continue;
                it.remove();
            }
        }
        switch (bundles.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Bundle bundle = (Bundle)bundles.iterator().next();
                return Util.getBundleClassLoader(bundle);
            }
        }
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        for (Bundle b : bundles) {
            loaders.add(Util.getBundleClassLoader(b));
        }
        return new MultiDelegationClassloader(loaders.toArray(new ClassLoader[loaders.size()]));
    }

    private static ClassLoader getBundleClassLoader(final Bundle b) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Util.getBundleClassLoaderPrivileged(b);
            }
        });
    }

    private static ClassLoader getBundleClassLoaderPrivileged(Bundle b) {
        try {
            Method adaptMethod = Bundle.class.getMethod("adapt", Class.class);
            if (adaptMethod != null) {
                return Util.getBundleClassLoaderViaAdapt(b, adaptMethod);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        ArrayList<String> rootPaths = new ArrayList<String>();
        rootPaths.add("/");
        while (rootPaths.size() > 0) {
            String rootPath = (String)rootPaths.remove(0);
            Enumeration paths = b.getEntryPaths(rootPath);
            while (paths != null && paths.hasMoreElements()) {
                String path = (String)paths.nextElement();
                if (path.endsWith(".class")) {
                    ClassLoader cl = Util.getClassLoaderFromClassResource(b, path);
                    if (cl == null) continue;
                    return cl;
                }
                if (!path.endsWith("/")) continue;
                rootPaths.add(path);
            }
        }
        Object bcp = b.getHeaders().get("Bundle-ClassPath");
        if (bcp instanceof String) {
            for (String entry : ((String)bcp).split(",")) {
                ClassLoader cl;
                URL url;
                if ((entry = entry.trim()).equals(".") || (url = b.getResource(entry)) == null || (cl = Util.getClassLoaderViaBundleClassPath(b, url)) == null) continue;
                return cl;
            }
        }
        throw new RuntimeException("Could not obtain classloader for bundle " + b);
    }

    private static ClassLoader getBundleClassLoaderViaAdapt(Bundle b, Method adaptMethod) {
        try {
            Bundle systemBundle = b.getBundleContext().getBundle(0L);
            Class bundleRevisionClass = systemBundle.loadClass("org.osgi.framework.wiring.BundleRevision");
            Object bundleRevision = adaptMethod.invoke((Object)b, bundleRevisionClass);
            Method getWiringMethod = bundleRevisionClass.getDeclaredMethod("getWiring", new Class[0]);
            Object bundleWiring = getWiringMethod.invoke(bundleRevision, new Object[0]);
            Class bundleWiringClass = systemBundle.loadClass("org.osgi.framework.wiring.BundleWiring");
            Method getClassLoaderMethod = bundleWiringClass.getDeclaredMethod("getClassLoader", new Class[0]);
            return (ClassLoader)getClassLoaderMethod.invoke(bundleWiring, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't obtain Bundle Class Loader for bundle: " + b, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ClassLoader getClassLoaderViaBundleClassPath(Bundle b, URL url) {
        try {
            JarInputStream jis = null;
            try {
                ClassLoader cl;
                String path;
                jis = new JarInputStream(url.openStream());
                JarEntry je = null;
                do {
                    if ((je = jis.getNextJarEntry()) == null) return null;
                } while (!(path = je.getName()).endsWith(".class") || (cl = Util.getClassLoaderFromClassResource(b, path)) == null);
                ClassLoader classLoader = cl;
                return classLoader;
            }
            finally {
                if (jis != null) {
                    jis.close();
                }
            }
        }
        catch (IOException e) {
            BaseActivator.activator.log(1, "Problem loading class from embedded jar file: " + url + " in bundle " + b.getSymbolicName(), e);
        }
        return null;
    }

    private static ClassLoader getClassLoaderFromClassResource(Bundle b, String path) {
        String className = path.substring(0, path.length() - ".class".length());
        if (className.startsWith("/")) {
            className = className.substring(1);
        }
        className = className.replace('/', '.');
        try {
            Class cls = b.loadClass(className);
            return cls.getClassLoader();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

