/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.blog.web;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import org.apache.aries.samples.blog.api.BlogAuthor;
import org.apache.aries.samples.blog.api.BloggingService;
import org.apache.aries.samples.blog.web.util.FormServlet;
import org.apache.aries.samples.blog.web.util.FormatChecker;
import org.apache.aries.samples.blog.web.util.HTMLOutput;
import org.apache.aries.samples.blog.web.util.JNDIHelper;

public class EditAuthorForm
extends FormServlet {
    private static final long serialVersionUID = 4996935653835900015L;
    public static final String ID = "author";

    public EditAuthorForm() {
        super(ID);
    }

    protected void writeCustomHeaderContent(HttpServletRequest req, PrintWriter out) {
        HTMLOutput.writeDojoUses((PrintWriter)out, (String[])new String[]{"dijit.form.TextBox", "dijit.form.DateTextBox", "dijit.form.Textarea"});
    }

    protected String getPageTitle(HttpServletRequest req) throws IOException {
        BlogAuthor author;
        String pageTitle = "Create Author";
        BloggingService service = JNDIHelper.getBloggingService();
        String email = this.getEmail(req);
        if (email != null && !"".equals(email) && (author = service.getBlogAuthor(email)) != null) {
            pageTitle = "Update " + author.getName() + "'s profile";
        }
        return pageTitle;
    }

    private String getEmail(HttpServletRequest req) {
        String email = this.retrieveOrEmpty(req, "email");
        if ("".equals(email)) {
            email = req.getParameter("email");
        }
        if (FormatChecker.isValidEmail((String)email)) {
            return email;
        }
        return null;
    }

    protected void writeForm(HttpServletRequest req, PrintWriter out) throws IOException {
        String name = this.retrieveOrEmpty(req, "name");
        String nickName = this.retrieveOrEmpty(req, "nickName");
        String bio = this.retrieveOrEmpty(req, "bio");
        String dob = this.retrieveOrEmpty(req, "dob");
        String email = this.getEmail(req);
        BloggingService service = JNDIHelper.getBloggingService();
        if (email != null && !"".equals(email)) {
            BlogAuthor author = service.getBlogAuthor(email);
            if ("".equals(name)) {
                name = author.getFullName();
            }
            if ("".equals(nickName)) {
                nickName = author.getName();
            }
            if ("".equals(bio)) {
                bio = author.getBio();
            }
            if ("".equals(dob)) {
                dob = author.getDateOfBirth();
            }
        } else {
            email = "";
        }
        out.println("<form method=\"get\" action=\"EditAuthor\">");
        out.print("<div class=\"textEntry\"><label>Name <input dojoType=\"dijit.form.TextBox\" type=\"text\" name=\"name\" value=\"");
        out.print(name);
        out.println("\"/></label></div>");
        out.print("<div class=\"textEntry\"><label>Nickname <input dojoType=\"dijit.form.TextBox\" type=\"text\" name=\"nickName\" value=\"");
        out.print(nickName);
        out.println("\"/></label></div>");
        out.print("<div class=\"textEntry\"><label>Email <input dojoType=\"dijit.form.TextBox\" type=\"text\" name=\"email\" value=\"");
        out.print(email);
        out.println("\"/></label></div>");
        out.print("<div class=\"textEntry\"><label>Date of Birth <input dojoType=\"dijit.form.DateTextBox\" type=\"text\" name=\"dob\" required=\"true\" value=\"");
        out.print(dob);
        out.println("\"/></label></div>");
        out.print("<div class=\"textEntry\"><label>Bio <textarea dojoType=\"dijit.form.Textarea\" style=\"width:300px\" name=\"bio\">");
        out.print(bio);
        out.println("</textarea></label></div>");
        out.println("<input class=\"submit\" type=\"submit\" value=\"Submit\" name=\"Submit\"/>");
        out.println("</form>");
    }
}

