/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.blog.web.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.aries.samples.blog.web.util.HTMLOutput;

public abstract class FormServlet
extends HttpServlet {
    private static final long serialVersionUID = -1019904995493434571L;
    public static final String ERROR_MESSAGES_ID = "errorMessages";
    private String id;

    public static void addError(HttpServletRequest req, String error) {
        HttpSession session = req.getSession();
        if (session != null) {
            ArrayList<String> errors = (ArrayList<String>)session.getAttribute(ERROR_MESSAGES_ID);
            if (errors == null) {
                errors = new ArrayList<String>();
                session.setAttribute(ERROR_MESSAGES_ID, errors);
            }
            errors.add(error);
        }
    }

    public static void storeParam(HttpServletRequest req, String id, String param, String value) {
        HttpSession session = req.getSession();
        if (session != null) {
            session.setAttribute(id + ":" + param, (Object)value);
        }
    }

    protected FormServlet(String id) {
        this.id = id;
    }

    protected abstract void writeCustomHeaderContent(HttpServletRequest var1, PrintWriter var2);

    protected abstract void writeForm(HttpServletRequest var1, PrintWriter var2) throws IOException;

    protected abstract String getPageTitle(HttpServletRequest var1) throws IOException;

    protected String retrieveOrEmpty(HttpServletRequest req, String param) {
        HttpSession session = req.getSession();
        String value = "";
        if (session != null && (value = (String)session.getAttribute(this.id + ":" + param)) == null) {
            value = "";
        }
        return value;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PrintWriter out = resp.getWriter();
        HTMLOutput.writeHTMLHeaderPartOne(out, this.getPageTitle(req));
        this.writeCustomHeaderContent(req, out);
        List errors = null;
        if (req.getSession() != null) {
            errors = (List)req.getSession().getAttribute(ERROR_MESSAGES_ID);
        }
        if (errors == null) {
            try {
                HTMLOutput.writeHTMLHeaderPartTwo(out);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                HTMLOutput.writeHTMLHeaderPartTwo(out, errors);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.writeForm(req, out);
        HTMLOutput.writeHTMLFooter(out);
        this.cleanupSession(req);
    }

    private void cleanupSession(HttpServletRequest req) {
        HttpSession session = req.getSession();
        if (session != null) {
            Enumeration names = session.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!name.startsWith(this.id + ":")) continue;
                session.removeAttribute(name);
            }
            session.removeAttribute(ERROR_MESSAGES_ID);
        }
    }
}

