/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.blog.persistence.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.aries.samples.blog.api.persistence.BlogPersistenceService;
import org.apache.aries.samples.blog.persistence.jdbc.Statements;
import org.apache.aries.samples.blog.persistence.jdbc.entity.AuthorImpl;
import org.apache.aries.samples.blog.persistence.jdbc.entity.EntryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlogPersistenceServiceImpl
implements BlogPersistenceService {
    private DataSource dataSource;
    private Statements statements = new Statements();

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void init() {
        Statement s = null;
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            s = connection.createStatement();
            String[] createStatments = this.statements.getCreateSchemaStatements();
            for (int i = 0; i < createStatments.length; ++i) {
                s.execute(createStatments[i]);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Throwable e) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    public void destroy() {
        Statement s = null;
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            s = connection.createStatement();
            String[] dropStatments = this.statements.getDropSchemaStatements();
            for (int i = 0; i < dropStatments.length; ++i) {
                s.execute(dropStatments[i]);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Throwable e) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    public void createAuthor(String email, Date dob, String name, String displayName, String bio) {
        try {
            Connection connection = this.dataSource.getConnection();
            String sql = "INSERT INTO AUTHOR VALUES (?,?,?,?,?)";
            PreparedStatement ppsm = connection.prepareStatement(sql);
            ppsm.setString(1, email);
            ppsm.setString(2, bio);
            ppsm.setString(3, displayName);
            if (dob != null) {
                ppsm.setDate(4, new java.sql.Date(dob.getTime()));
            } else {
                ppsm.setDate(4, null);
            }
            ppsm.setString(5, name);
            int insertRows = ppsm.executeUpdate();
            ppsm.close();
            connection.close();
            if (insertRows != 1) {
                throw new IllegalArgumentException("The Author " + email + " cannot be inserted.");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void createBlogPost(String authorEmail, String title, String blogText, List<String> tags) {
        AuthorImpl a = this.getAuthor(authorEmail);
        if (title == null) {
            title = "";
        }
        Date publishDate = new Date(System.currentTimeMillis());
        if (tags == null) {
            tags = new ArrayList<String>();
        }
        try {
            Connection connection = this.dataSource.getConnection();
            String sql = "SELECT max(id) FROM BLOGENTRY";
            PreparedStatement ppsm = connection.prepareStatement(sql);
            ResultSet rs = ppsm.executeQuery();
            rs.next();
            long max_id = rs.getLong(1);
            ppsm.close();
            long post_id = max_id + 1L;
            sql = "INSERT INTO BLOGENTRY VALUES (?,?,?,?,?,?)";
            ppsm = connection.prepareStatement(sql);
            ppsm.setLong(1, post_id);
            ppsm.setString(2, blogText);
            if (publishDate != null) {
                ppsm.setDate(3, new java.sql.Date(publishDate.getTime()));
            } else {
                ppsm.setDate(3, null);
            }
            ppsm.setString(4, title);
            ppsm.setDate(5, null);
            ppsm.setString(6, a.getEmail());
            int rows = ppsm.executeUpdate();
            if (rows != 1) {
                throw new IllegalArgumentException("The blog entry record cannot be inserted: " + blogText);
            }
            ppsm.close();
            sql = "INSERT INTO Author_BlogEntry VALUES (?,?)";
            ppsm = connection.prepareStatement(sql);
            ppsm.setString(1, a.getEmail());
            ppsm.setLong(2, post_id);
            rows = ppsm.executeUpdate();
            ppsm.close();
            connection.close();
            if (rows != 1) {
                throw new IllegalArgumentException("The Author_BlogEntry record cannot be inserted: " + a.getEmail() + " , " + post_id);
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
    }

    public EntryImpl findBlogEntryByTitle(String title) {
        EntryImpl be = null;
        String sql = "SELECT * FROM BlogEntry e WHERE e.title = '" + title + "'";
        List<EntryImpl> blogEntries = this.findBlogs(sql);
        if (blogEntries != null && blogEntries.size() > 0) {
            be = blogEntries.get(0);
        }
        return be;
    }

    public List<AuthorImpl> getAllAuthors() {
        String sql = "SELECT * FROM Author";
        List<AuthorImpl> list = this.findAuthors(sql);
        return list;
    }

    public List<EntryImpl> getAllBlogEntries() {
        String sql = "SELECT * FROM BlogEntry b ORDER BY b.publishDate DESC";
        List<EntryImpl> list = this.findBlogs(sql);
        return list;
    }

    public int getNoOfBlogEntries() {
        int count = 0;
        String sql = "SELECT count(*) FROM BLOGENTRY";
        try {
            Connection connection = this.dataSource.getConnection();
            PreparedStatement ppsm = connection.prepareStatement(sql);
            ResultSet rs = ppsm.executeQuery();
            rs.next();
            count = rs.getInt(1);
            ppsm.close();
            connection.close();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        return count;
    }

    public List<EntryImpl> getBlogEntries(int firstPostIndex, int noOfPosts) {
        String sql = "SELECT * FROM BlogEntry b ORDER BY b.publishDate DESC";
        ArrayList<EntryImpl> emptyList = new ArrayList<EntryImpl>();
        List<EntryImpl> blogs = this.findBlogs(sql);
        if (blogs == null) {
            return emptyList;
        }
        int maximumIndex = blogs.size();
        if (firstPostIndex < 0 || noOfPosts <= 0 || firstPostIndex > maximumIndex) {
            return emptyList;
        }
        int lastIndex = noOfPosts + firstPostIndex;
        return blogs.subList(firstPostIndex, lastIndex > maximumIndex ? maximumIndex : lastIndex);
    }

    public AuthorImpl getAuthor(String emailAddress) {
        String sql = "SELECT * FROM AUTHOR a where a.email='" + emailAddress + "'";
        List<AuthorImpl> authors = this.findAuthors(sql);
        if (authors.size() == 0) {
            return null;
        }
        if (authors.size() > 1) {
            throw new IllegalArgumentException("Email address should be unique per author");
        }
        return authors.get(0);
    }

    public List<EntryImpl> getBlogEntriesModifiedBetween(Date start, Date end) {
        String sql = "SELECT * FROM BlogEntry b WHERE (Date(b.updatedDate) BETWEEN '" + start + "' AND '" + end + "') OR (Date(b.publishDate) BETWEEN '" + start + "' AND  '" + end + "') ORDER BY b.publishDate ASC";
        return this.findBlogs(sql);
    }

    public List<EntryImpl> getBlogsForAuthor(String emailAddress) {
        String sql = "SELECT * FROM BlogEntry b WHERE b.AUTHOR_EMAIL='" + emailAddress + "'";
        return this.findBlogs(sql);
    }

    public void updateAuthor(String email, Date dob, String name, String displayName, String bio) {
        String sql = "UPDATE AUTHOR a SET bio = ?, displayName = ?, dob = ?, name =? WHERE email ='" + email + "'";
        int updatedRows = 0;
        try {
            Connection connection = this.dataSource.getConnection();
            PreparedStatement ppsm = connection.prepareStatement(sql);
            ppsm.setString(1, bio);
            ppsm.setString(2, displayName);
            if (dob != null) {
                ppsm.setDate(3, new java.sql.Date(dob.getTime()));
            } else {
                ppsm.setDate(3, null);
            }
            ppsm.setString(4, name);
            updatedRows = ppsm.executeUpdate();
            ppsm.close();
            connection.close();
            if (updatedRows != 1) {
                throw new IllegalArgumentException("The Author " + email + " cannot be updated.");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updateBlogEntry(long id, String email, String title, String blogText, List<String> tags, Date updatedDate) {
        if (id == -1L) {
            throw new IllegalArgumentException("Not a BlogEntry returned by this interface");
        }
        EntryImpl b = this.getBlogEntryById(id);
        String sql_se = "SELECT * FROM BLOGENTRY bp WHERE bp.id = " + id;
        String email_old = null;
        try {
            Connection connection = this.dataSource.getConnection();
            PreparedStatement ppsm = connection.prepareStatement(sql_se);
            ResultSet rs = ppsm.executeQuery();
            rs.next();
            email_old = rs.getString("AUTHOR_EMAIL");
            ppsm.close();
            connection.close();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        String sql = "UPDATE BLOGENTRY bp SET bp.blogText = ?, bp.publishDate = ?, bp.title = ?, bp.updatedDate = ?, bp.AUTHOR_EMAIL = ? where bp.id = " + id;
        int updatedRows = 0;
        try {
            Connection connection = this.dataSource.getConnection();
            PreparedStatement ppsm = connection.prepareStatement(sql);
            ppsm.setString(1, blogText);
            if (b.getPublishDate() != null) {
                ppsm.setDate(2, new java.sql.Date(b.getPublishDate().getTime()));
            } else {
                ppsm.setDate(2, null);
            }
            ppsm.setString(3, b.getTitle());
            if (b.getUpdatedDate() != null) {
                ppsm.setDate(4, new java.sql.Date(b.getUpdatedDate().getTime()));
            } else {
                ppsm.setDate(4, null);
            }
            ppsm.setString(5, email);
            updatedRows = ppsm.executeUpdate();
            ppsm.close();
            connection.close();
            if (updatedRows != 1) {
                throw new IllegalArgumentException("The Blog " + b.getId() + " cannot be updated.");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (email_old != null && !email_old.equals(email)) {
            String sql_ab = "UDPATE Author_BlogEntry ab SET ab.AUTHOR_EMAIL = '" + email + "'";
            updatedRows = 0;
            try {
                Connection connection = this.dataSource.getConnection();
                PreparedStatement ppsm = connection.prepareStatement(sql_ab);
                updatedRows = ppsm.executeUpdate();
                ppsm.close();
                connection.close();
                if (updatedRows != 1) {
                    throw new IllegalArgumentException("The Author_BlogEntry with the postsID " + b.getId() + " cannot be updated.");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void removeAuthor(String emailAddress) {
        try {
            String sql = "DELETE FROM BLOGENTRY bp WHERE bp.AUTHOR_EMAIL = '" + emailAddress + "'";
            Connection connection = this.dataSource.getConnection();
            PreparedStatement ppsm = connection.prepareStatement(sql);
            ppsm.executeUpdate();
            ppsm.close();
            sql = "DELETE FROM Author_BlogEntry ab WHERE ab.AUTHOR_EMAIL = '" + emailAddress + "'";
            ppsm = connection.prepareStatement(sql);
            ppsm.executeUpdate();
            ppsm.close();
            sql = "DELETE FROM Author a WHERE a.EMAIL = '" + emailAddress + "'";
            ppsm = connection.prepareStatement(sql);
            ppsm.executeUpdate();
            ppsm.close();
            connection.close();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
    }

    public void removeBlogEntry(long id) {
        if (id == -1L) {
            throw new IllegalArgumentException("Not a BlogEntry returned by this interface");
        }
        try {
            String sql = "DELETE FROM BLOGENTRY bp WHERE bp.id = " + id;
            Connection connection = this.dataSource.getConnection();
            PreparedStatement ppsm = connection.prepareStatement(sql);
            ppsm.executeUpdate();
            ppsm.close();
            sql = "DELETE FROM Author_BlogEntry ab WHERE ab.POSTS_ID = " + id;
            ppsm = connection.prepareStatement(sql);
            ppsm.executeUpdate();
            ppsm.close();
            connection.close();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
    }

    public EntryImpl getBlogEntryById(long postId) {
        String sql = "SELECT * FROM BlogEntry b WHERE b.id = " + postId;
        List<EntryImpl> blogs = this.findBlogs(sql);
        if (blogs.size() == 0) {
            return null;
        }
        if (blogs.size() > 1) {
            throw new IllegalArgumentException("Blog id is not unique");
        }
        return blogs.get(0);
    }

    private List<AuthorImpl> findAuthors(String sql) {
        ArrayList<AuthorImpl> authorList = new ArrayList<AuthorImpl>();
        try {
            Connection connection = this.dataSource.getConnection();
            PreparedStatement ppsm = connection.prepareStatement(sql);
            ResultSet ars = ppsm.executeQuery();
            while (ars.next()) {
                AuthorImpl ar = new AuthorImpl();
                ar.setBio(ars.getString("bio"));
                ar.setDisplayName(ars.getString("displayName"));
                ar.setDob(ars.getDate("dob"));
                String email = ars.getString("email");
                ar.setEmail(email);
                ar.setName(ars.getString("name"));
                String sql_be = "SELECT * FROM BLOGENTRY be WHERE be.AUTHOR_EMAIL = '" + email + "'";
                PreparedStatement ppsm2 = connection.prepareStatement(sql_be);
                ResultSet rs = ppsm2.executeQuery();
                ArrayList<EntryImpl> blogs = new ArrayList<EntryImpl>();
                while (rs.next()) {
                    EntryImpl blog = new EntryImpl();
                    blog.setAuthor(ar);
                    blog.setId(rs.getLong("id"));
                    blog.setBlogText(rs.getString("blogText"));
                    blog.setPublishDate(rs.getDate("publishDate"));
                    blog.setTitle(rs.getString("title"));
                    blog.setUpdatedDate(rs.getDate("updatedDate"));
                    blogs.add(blog);
                }
                ar.setEntries(blogs);
                authorList.add(ar);
                ppsm2.close();
            }
            ppsm.close();
            connection.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return authorList;
    }

    private List<EntryImpl> findBlogs(String sql) {
        ArrayList<EntryImpl> blogEntryList = new ArrayList<EntryImpl>();
        try {
            Connection connection = this.dataSource.getConnection();
            PreparedStatement ppsm = connection.prepareStatement(sql);
            ResultSet blogrs = ppsm.executeQuery();
            while (blogrs.next()) {
                EntryImpl be = new EntryImpl();
                be.setId(blogrs.getLong("id"));
                be.setBlogText(blogrs.getString("blogText"));
                be.setPublishDate(blogrs.getDate("publishDate"));
                be.setTitle(blogrs.getString("title"));
                be.setUpdatedDate(blogrs.getDate("updatedDate"));
                String author_email = blogrs.getString("AUTHOR_EMAIL");
                String author_sql = "SELECT * FROM Author a WHERE a.email ='" + author_email + "'";
                List<AuthorImpl> authors = this.findAuthors(author_sql);
                if (authors.size() != 1) {
                    throw new IllegalArgumentException("We got more than one author with the same email address. This is wrong");
                }
                be.setAuthor(authors.get(0));
                blogEntryList.add(be);
            }
            ppsm.close();
            connection.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return blogEntryList;
    }
}

