/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.blog.comment.ejb;

import java.util.Date;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.aries.samples.blog.api.comment.persistence.Comment;
import org.apache.aries.samples.blog.api.persistence.Author;
import org.apache.aries.samples.blog.api.persistence.BlogPersistenceService;
import org.apache.aries.samples.blog.api.persistence.Entry;

@Entity(name="Comment")
public class CommentImpl
implements Comment {
    @Id
    @GeneratedValue
    private int id;
    private String comment;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date creationDate;
    private String authorId;
    private long entryId;

    public CommentImpl(String comment, String authorId, long entryId) {
        this.comment = comment;
        this.authorId = authorId;
        this.entryId = entryId;
        this.creationDate = new Date();
    }

    public String getComment() {
        return this.comment;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public int getId() {
        return this.id;
    }

    public Author getAuthor() {
        try {
            BlogPersistenceService bps = (BlogPersistenceService)new InitialContext().lookup("osgi:service/" + BlogPersistenceService.class.getName());
            return bps.getAuthor(this.authorId);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public Entry getEntry() {
        try {
            BlogPersistenceService bps = (BlogPersistenceService)new InitialContext().lookup("osgi:service/" + BlogPersistenceService.class.getName());
            return bps.getBlogEntryById(this.entryId);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getAuthorId() {
        return this.authorId;
    }

    public void setAuthorId(String authorId) {
        this.authorId = authorId;
    }

    public long getEntryId() {
        return this.entryId;
    }

    public void setEntryId(long entryId) {
        this.entryId = entryId;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }
}

