/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.samples.blog.comment.ejb;

import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.aries.samples.blog.api.comment.persistence.BlogCommentService;
import org.apache.aries.samples.blog.api.comment.persistence.Comment;
import org.apache.aries.samples.blog.comment.ejb.CommentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless(name="Commenting")
public class BlogCommentEJB
implements BlogCommentService {
    @PersistenceContext(unitName="blogComments")
    private EntityManager commentEM;

    public void createComment(String comment, String author, long entryId) {
        this.commentEM.persist((Object)new CommentImpl(comment, author, entryId));
    }

    public void delete(int id) {
        CommentImpl c = (CommentImpl)this.commentEM.find(CommentImpl.class, (Object)id);
        if (c != null) {
            this.commentEM.remove((Object)c);
        }
    }

    public List<? extends Comment> getCommentsForAuthor(String authorId) {
        TypedQuery q = this.commentEM.createQuery("SELECT c FROM Comment c WHERE c.authorId = :authorId", CommentImpl.class);
        q.setParameter("authorId", (Object)authorId);
        return q.getResultList();
    }

    public List<? extends Comment> getCommentsForEntry(long entryId) {
        TypedQuery q = this.commentEM.createQuery("SELECT c FROM Comment c WHERE c.entryId = :entryId", CommentImpl.class);
        q.setParameter("entryId", (Object)entryId);
        return q.getResultList();
    }
}

