/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.proxy.impl.weaving;

import java.util.List;
import org.apache.aries.proxy.UnableToProxyException;
import org.apache.aries.proxy.impl.NLS;
import org.apache.aries.proxy.impl.weaving.WovenProxyGenerator;
import org.osgi.framework.Bundle;
import org.osgi.framework.hooks.weaving.WeavingException;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProxyWeavingHook
implements WeavingHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyWeavingHook.class);
    private static final String IMPORT_A = "org.apache.aries.proxy.weaving";
    private static final String IMPORT_B = "org.apache.aries.proxy";

    public final void weave(WovenClass wovenClass) {
        Bundle b = wovenClass.getBundleWiring().getBundle();
        if (b.getBundleId() == 0L || b.getSymbolicName().startsWith(IMPORT_B) || b.getSymbolicName().startsWith("org.apache.aries.util")) {
            return;
        }
        if (wovenClass.getClassName().startsWith("org.objectweb.asm") || wovenClass.getClassName().startsWith("org.slf4j") || wovenClass.getClassName().startsWith("org.apache.log4j") || wovenClass.getClassName().startsWith("javax.")) {
            return;
        }
        byte[] bytes = null;
        try {
            bytes = WovenProxyGenerator.getWovenProxy(wovenClass.getBytes(), wovenClass.getClassName(), wovenClass.getBundleWiring().getClassLoader());
        }
        catch (Exception e) {
            if (e instanceof RuntimeException && e.getCause() instanceof UnableToProxyException) {
                LOGGER.trace(NLS.MESSAGES.getMessage("cannot.weave", new Object[]{wovenClass.getClassName()}), (Throwable)e);
            }
            String failureMessage = NLS.MESSAGES.getMessage("fatal.weaving.failure", new Object[]{wovenClass.getClassName()});
            LOGGER.error(failureMessage, (Throwable)e);
            throw new WeavingException(failureMessage, (Throwable)e);
        }
        if (bytes != null && bytes.length != 0) {
            wovenClass.setBytes(bytes);
            List imports = wovenClass.getDynamicImports();
            imports.add(IMPORT_A);
            imports.add(IMPORT_B);
        }
    }
}

