/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.proxy.impl.weaving;

import java.util.Map;
import java.util.Set;
import org.apache.aries.proxy.FinalModifierException;
import org.apache.aries.proxy.UnableToProxyException;
import org.apache.aries.proxy.impl.NLS;
import org.apache.aries.proxy.impl.common.AbstractWovenProxyAdapter;
import org.apache.aries.proxy.impl.common.TypeMethod;
import org.apache.aries.proxy.impl.weaving.WovenProxyMethodAdapter;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;
import org.objectweb.asm.commons.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MethodCopyingClassAdapter
extends EmptyVisitor
implements Opcodes {
    private final ClassVisitor cv;
    private final Class<?> superToCopy;
    private final boolean samePackage;
    private final Type overridingClassType;
    private final Set<Method> knownMethods;
    private final Map<String, TypeMethod> transformedMethods;

    public MethodCopyingClassAdapter(ClassVisitor cv, Class<?> superToCopy, Type overridingClassType, Set<Method> knownMethods, Map<String, TypeMethod> transformedMethods) {
        this.cv = cv;
        this.superToCopy = superToCopy;
        this.overridingClassType = overridingClassType;
        this.knownMethods = knownMethods;
        this.transformedMethods = transformedMethods;
        String overridingClassName = overridingClassType.getClassName();
        int lastIndex1 = superToCopy.getName().lastIndexOf(46);
        int lastIndex2 = overridingClassName.lastIndexOf(46);
        this.samePackage = lastIndex1 == lastIndex2 && superToCopy.getName().substring(0, lastIndex1 == -1 ? 1 : lastIndex1).equals(overridingClassName.substring(0, lastIndex2 == -1 ? 1 : lastIndex2));
    }

    public final MethodVisitor visitMethod(int access, String name, String desc, String sig, String[] exceptions) {
        CopyingMethodAdapter mv = null;
        if (!name.equals("<init>") && !name.equals("<clinit>") && (access & 0x154A) == 0) {
            Method currentTransformMethod = new Method(name, desc);
            if (!this.knownMethods.add(currentTransformMethod)) {
                return null;
            }
            if ((access & 0x10) != 0) {
                throw new RuntimeException(new FinalModifierException(this.superToCopy, name));
            }
            if ((access & 7) == 0 && !this.samePackage) {
                throw new RuntimeException(NLS.MESSAGES.getMessage("method.from.superclass.is.hidden", new Object[]{name, this.superToCopy.getName(), this.overridingClassType.getClassName()}), (Throwable)new UnableToProxyException(this.superToCopy));
            }
            Type superType = Type.getType(this.superToCopy);
            String methodStaticFieldName = "methodField" + AbstractWovenProxyAdapter.getSanitizedUUIDString();
            this.transformedMethods.put(methodStaticFieldName, new TypeMethod(superType, currentTransformMethod));
            mv = new CopyingMethodAdapter((MethodVisitor)new WovenProxyMethodAdapter(this.cv.visitMethod(access, name, desc, sig, exceptions), access, name, desc, exceptions, methodStaticFieldName, currentTransformMethod, this.overridingClassType), superType, currentTransformMethod);
        }
        return mv;
    }

    private static final class CopyingMethodAdapter
    extends EmptyVisitor {
        private final MethodVisitor mv;
        private final Type superType;
        private final Method currentTransformMethod;

        public CopyingMethodAdapter(MethodVisitor mv, Type superType, Method currentTransformMethod) {
            this.mv = mv;
            this.superType = superType;
            this.currentTransformMethod = currentTransformMethod;
        }

        public final AnnotationVisitor visitAnnotation(String arg0, boolean arg1) {
            return this.mv.visitAnnotation(arg0, arg1);
        }

        public final AnnotationVisitor visitAnnotationDefault() {
            return this.mv.visitAnnotationDefault();
        }

        public final AnnotationVisitor visitParameterAnnotation(int arg0, String arg1, boolean arg2) {
            return this.mv.visitParameterAnnotation(arg0, arg1, arg2);
        }

        public final void visitAttribute(Attribute attr) {
            this.mv.visitAttribute(attr);
        }

        public final void visitEnd() {
            this.mv.visitCode();
            this.writeBody();
            this.mv.visitMaxs(this.currentTransformMethod.getArgumentTypes().length + 1, 0);
            this.mv.visitEnd();
        }

        private final void writeBody() {
            this.mv.visitVarInsn(25, 0);
            int nargs = this.currentTransformMethod.getArgumentTypes().length;
            block13: for (int i = 1; i <= nargs; ++i) {
                switch (this.currentTransformMethod.getArgumentTypes()[i - 1].getSort()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        this.mv.visitVarInsn(21, i);
                        continue block13;
                    }
                    case 6: {
                        this.mv.visitVarInsn(23, i);
                        continue block13;
                    }
                    case 8: {
                        this.mv.visitVarInsn(24, i);
                        continue block13;
                    }
                    case 7: {
                        this.mv.visitVarInsn(22, i);
                        continue block13;
                    }
                    default: {
                        this.mv.visitVarInsn(25, i);
                    }
                }
            }
            this.mv.visitMethodInsn(183, this.superType.getInternalName(), this.currentTransformMethod.getName(), this.currentTransformMethod.getDescriptor());
            switch (this.currentTransformMethod.getReturnType().getSort()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.mv.visitInsn(172);
                    break;
                }
                case 0: {
                    this.mv.visitInsn(177);
                    break;
                }
                case 6: {
                    this.mv.visitInsn(174);
                    break;
                }
                case 8: {
                    this.mv.visitInsn(175);
                    break;
                }
                case 7: {
                    this.mv.visitInsn(173);
                    break;
                }
                default: {
                    this.mv.visitInsn(176);
                }
            }
        }
    }
}

