/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.proxy.impl.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import org.apache.aries.proxy.UnableToProxyException;
import org.apache.aries.proxy.impl.NLS;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.JSRInlinerAdapter;

public final class OSGiFriendlyClassWriter
extends ClassWriter {
    private static final String OBJECT_INTERNAL_NAME = "java/lang/Object";
    private final ClassLoader loader;
    private String currentClassInternalName;
    private String currentSuperClassInternalName;
    private final boolean inlineJSR;

    public OSGiFriendlyClassWriter(ClassReader arg0, int arg1, ClassLoader loader) {
        super(arg0, arg1);
        this.inlineJSR = arg1 == 2;
        this.loader = loader;
    }

    public OSGiFriendlyClassWriter(int arg0, ClassLoader loader) {
        super(arg0);
        this.inlineJSR = arg0 == 2;
        this.loader = loader;
    }

    protected final String getCommonSuperClass(String arg0, String arg1) {
        if (arg0.equals(arg1)) {
            return arg0;
        }
        if (arg0.equals(OBJECT_INTERNAL_NAME) || arg1.equals(OBJECT_INTERNAL_NAME)) {
            return OBJECT_INTERNAL_NAME;
        }
        if (arg0.equals(this.currentClassInternalName)) {
            this.getCommonSuperClass(this.currentSuperClassInternalName, arg1);
        } else if (arg1.equals(this.currentClassInternalName)) {
            this.getCommonSuperClass(arg0, this.currentSuperClassInternalName);
        }
        HashSet<String> names = new HashSet<String>();
        names.add(arg0);
        names.add(arg1);
        try {
            boolean bRunning = true;
            boolean aRunning = true;
            String arg00 = arg0;
            String arg11 = arg1;
            String unable = null;
            while (aRunning || bRunning) {
                ClassReader cr;
                InputStream is;
                if (aRunning) {
                    is = this.loader.getResourceAsStream(arg00 + ".class");
                    if (is != null) {
                        cr = new ClassReader(is);
                        arg00 = cr.getSuperName();
                        if (arg00 == null) {
                            aRunning = false;
                        } else if (!names.add(arg00)) {
                            return arg00;
                        }
                    } else {
                        unable = arg0;
                        aRunning = false;
                    }
                }
                if (!bRunning) continue;
                is = this.loader.getResourceAsStream(arg11 + ".class");
                if (is != null) {
                    cr = new ClassReader(is);
                    arg11 = cr.getSuperName();
                    if (arg11 == null) {
                        bRunning = false;
                        continue;
                    }
                    if (names.add(arg11)) continue;
                    return arg11;
                }
                unable = arg1;
                bRunning = false;
            }
            if (unable == null) {
                throw new RuntimeException(NLS.MESSAGES.getMessage("no.common.superclass", new Object[]{arg0, arg1}));
            }
            throw new RuntimeException((Throwable)new UnableToProxyException(unable, NLS.MESSAGES.getMessage("no.common.superclass", new Object[]{arg0, arg1})));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final void visit(int arg0, int arg1, String arg2, String arg3, String arg4, String[] arg5) {
        this.currentClassInternalName = arg2;
        this.currentSuperClassInternalName = arg4;
        super.visit(arg0, arg1, arg2, arg3, arg4, arg5);
    }

    public MethodVisitor visitMethod(int arg0, String arg1, String arg2, String arg3, String[] arg4) {
        MethodVisitor mv = super.visitMethod(arg0, arg1, arg2, arg3, arg4);
        if (this.inlineJSR) {
            mv = new JSRInlinerAdapter(mv, arg0, arg1, arg2, arg3, arg4);
        }
        return mv;
    }
}

