/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.proxy.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.apache.aries.proxy.InvocationListener;
import org.apache.aries.proxy.ProxyManager;
import org.apache.aries.proxy.UnableToProxyException;
import org.apache.aries.proxy.impl.NLS;
import org.apache.aries.proxy.impl.ProxyHandler;
import org.apache.aries.proxy.impl.SingleInstanceDispatcher;
import org.apache.aries.proxy.weaving.WovenProxy;
import org.apache.aries.util.AriesFrameworkUtil;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProxyManager
implements ProxyManager {
    public final Object createDelegatingProxy(Bundle clientBundle, Collection<Class<?>> classes, Callable<Object> dispatcher, Object template) throws UnableToProxyException {
        return this.createDelegatingInterceptingProxy(clientBundle, classes, dispatcher, template, null);
    }

    public Object createInterceptingProxy(Bundle clientBundle, Collection<Class<?>> classes, Object delegate, InvocationListener listener) throws UnableToProxyException {
        if (delegate instanceof WovenProxy) {
            WovenProxy proxy = ((WovenProxy)delegate).org_apache_aries_proxy_weaving_WovenProxy_createNewProxyInstance(new SingleInstanceDispatcher(delegate), listener);
            return proxy;
        }
        return this.createDelegatingInterceptingProxy(clientBundle, classes, new SingleInstanceDispatcher(delegate), delegate, listener);
    }

    public final Object createDelegatingInterceptingProxy(Bundle clientBundle, Collection<Class<?>> classes, Callable<Object> dispatcher, Object template, InvocationListener listener) throws UnableToProxyException {
        if (dispatcher == null) {
            throw new NullPointerException(NLS.MESSAGES.getMessage("no.dispatcher", new Object[0]));
        }
        if (template instanceof WovenProxy) {
            WovenProxy proxy = ((WovenProxy)template).org_apache_aries_proxy_weaving_WovenProxy_createNewProxyInstance(dispatcher, listener);
            return proxy;
        }
        Object proxyObject = this.duplicateProxy(classes, dispatcher, template, listener);
        if (proxyObject == null) {
            proxyObject = this.createNewProxy(clientBundle, classes, dispatcher, listener);
        }
        return proxyObject;
    }

    public final Callable<Object> unwrap(Object proxy) {
        SingleInstanceDispatcher target = null;
        if (proxy instanceof WovenProxy) {
            WovenProxy wp = (WovenProxy)proxy;
            if (wp.org_apache_aries_proxy_weaving_WovenProxy_isProxyInstance() && (target = wp.org_apache_aries_proxy_weaving_WovenProxy_unwrap()) == null) {
                target = new SingleInstanceDispatcher(proxy);
            }
        } else {
            InvocationHandler ih = this.getInvocationHandler(proxy);
            if (ih instanceof ProxyHandler) {
                target = ((ProxyHandler)ih).getTarget();
            }
        }
        return target;
    }

    public final boolean isProxy(Object proxy) {
        return proxy != null && (proxy instanceof WovenProxy && ((WovenProxy)proxy).org_apache_aries_proxy_weaving_WovenProxy_isProxyInstance() || this.getInvocationHandler(proxy) instanceof ProxyHandler);
    }

    protected abstract Object createNewProxy(Bundle var1, Collection<Class<?>> var2, Callable<Object> var3, InvocationListener var4) throws UnableToProxyException;

    protected abstract InvocationHandler getInvocationHandler(Object var1);

    protected abstract boolean isProxyClass(Class<?> var1);

    protected synchronized ClassLoader getClassLoader(Bundle clientBundle, Collection<Class<?>> classes) {
        if (clientBundle.getState() == 1) {
            throw new IllegalStateException(NLS.MESSAGES.getMessage("bundle.uninstalled", new Object[]{clientBundle.getSymbolicName(), clientBundle.getVersion(), clientBundle.getBundleId()}));
        }
        ClassLoader cl = null;
        if (classes.size() == 1) {
            cl = classes.iterator().next().getClassLoader();
        }
        if (cl == null) {
            cl = AriesFrameworkUtil.getClassLoaderForced((Bundle)clientBundle);
        }
        return cl;
    }

    private Object duplicateProxy(Collection<Class<?>> classes, Callable<Object> dispatcher, Object template, InvocationListener listener) {
        Object proxyObject = null;
        Class<?> classToProxy = null;
        if (template != null) {
            if (this.isProxyClass(template.getClass())) {
                classToProxy = template.getClass();
            }
        } else if (classes.size() == 1 && !this.isProxyClass(classToProxy = classes.iterator().next())) {
            classToProxy = null;
        }
        if (classToProxy != null) {
            try {
                if (WovenProxy.class.isAssignableFrom(classToProxy)) {
                    Constructor<?> c = classToProxy.getDeclaredConstructor(Callable.class, InvocationListener.class);
                    c.setAccessible(true);
                    proxyObject = c.newInstance(dispatcher, listener);
                } else {
                    proxyObject = classToProxy.getConstructor(InvocationHandler.class).newInstance(new ProxyHandler(this, dispatcher, listener));
                }
            }
            catch (InvocationTargetException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (SecurityException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return proxyObject;
    }
}

