/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.itest.bundle.blueprint.impl;

import java.util.Map;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.transaction.Transactional;
import org.apache.aries.jpa.container.itest.entities.Car;
import org.apache.aries.jpa.container.itest.entities.CarService;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.Coordinator;

public class CarLifeCycle
implements Runnable {
    CarService carService;
    Coordinator coordinator;

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void run() {
        Car car = new Car();
        UUID uuid = UUID.randomUUID();
        String id = "blue " + uuid.toString();
        car.setEngineSize(1);
        car.setNumberPlate(id);
        this.carService.addCar(car);
        EntityManager em = this.getEmFromCoord();
        if (!em.contains((Object)car)) {
            throw new IllegalStateException("Transaction should cause EntityManager to be kept open");
        }
        this.readAndUpdate(id);
        Car car3 = this.carService.getCar(id);
        if (car3.getEngineSize() != 100) {
            throw new IllegalStateException("Engine size should have been changed to 100");
        }
        this.carService.deleteCar(id);
        Car car2 = this.carService.getCar(id);
        if (car2 != null) {
            throw new RuntimeException("Car with id " + id + " should be deleted");
        }
    }

    public void readAndUpdate(String id) {
        Car car = this.carService.getCar(id);
        if (car == null) {
            throw new IllegalStateException("Expected a car with id " + id);
        }
        car.setEngineSize(100);
    }

    private EntityManager getEmFromCoord() {
        Coordination coord = this.coordinator.peek();
        if (coord == null) {
            throw new IllegalStateException("No coordination found");
        }
        while (coord != null) {
            Map emMap = (Map)coord.getVariables().get(EntityManager.class);
            if (emMap != null) {
                return (EntityManager)emMap.values().iterator().next();
            }
            coord = coord.getEnclosingCoordination();
        }
        throw new IllegalStateException("No EntityManager found in coordinations");
    }

    public void setCarService(CarService carService) {
        this.carService = carService;
    }

    public void setCoordinator(Coordinator coordinator) {
        this.coordinator = coordinator;
    }
}

