/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi.url;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OsgiName
extends CompositeName {
    private static final long serialVersionUID = 6617580228852444656L;
    public static final String OSGI_SCHEME = "osgi";
    public static final String ARIES_SCHEME = "aries";
    public static final String SERVICE_PATH = "service";
    public static final String SERVICES_PATH = "services";
    public static final String SERVICE_LIST_PATH = "servicelist";
    public static final String FRAMEWORK_PATH = "framework";

    public OsgiName(String name) throws InvalidNameException {
        super(OsgiName.split(name));
    }

    public OsgiName(Name name) throws InvalidNameException {
        this(name.toString());
    }

    private static Enumeration<String> split(String name) {
        ArrayList<String> elements = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        int len = name.length();
        int count = 0;
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (c == '/' && count == 0) {
                elements.add(builder.toString());
                builder = new StringBuilder();
                continue;
            }
            if (c == '(') {
                ++count;
            } else if (c == ')') {
                ++count;
            }
            builder.append(c);
        }
        elements.add(builder.toString());
        return Collections.enumeration(elements);
    }

    public boolean hasFilter() {
        return this.size() == 3;
    }

    public boolean isServiceNameBased() {
        return this.size() > 3;
    }

    public String getScheme() {
        String part0 = this.get(0);
        int index = part0.indexOf(58);
        String result = index > 0 ? part0.substring(0, index) : null;
        return result;
    }

    public String getSchemePath() {
        String part0 = this.get(0);
        int index = part0.indexOf(58);
        String result = index > 0 ? part0.substring(index + 1) : null;
        return result;
    }

    public String getInterface() {
        return this.get(1);
    }

    public String getFilter() {
        return this.hasFilter() ? this.get(2) : null;
    }

    public String getServiceName() {
        Enumeration<String> parts = this.getAll();
        parts.nextElement();
        StringBuilder builder = new StringBuilder();
        if (parts.hasMoreElements()) {
            while (parts.hasMoreElements()) {
                builder.append(parts.nextElement());
                builder.append('/');
            }
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public boolean hasInterface() {
        return this.size() > 1;
    }
}

