/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi.url;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import org.apache.aries.jndi.url.OsgiNameParser;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServiceRegistryContext
implements Context {
    protected BundleContext callerContext;
    protected Map<String, Object> env;
    protected NameParser parser = new OsgiNameParser();
    private static final String ARIES_SERVICES = "aries:services/";

    public AbstractServiceRegistryContext(BundleContext callerContext, Hashtable<?, ?> environment) {
        this.callerContext = callerContext;
        this.env = new HashMap<String, Object>();
        this.env.putAll(environment);
    }

    public AbstractServiceRegistryContext(BundleContext callerContext, Map<?, ?> environment) {
        this.callerContext = callerContext;
        this.env = new HashMap<String, Object>();
        this.env.putAll(environment);
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.env.put(propName, propVal);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void close() throws NamingException {
        this.env = null;
        this.parser = null;
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        String ns;
        String result = prefix + "/" + name;
        if (result.startsWith(ns = ARIES_SERVICES)) {
            ns = "";
        }
        return this.parser.parse(ns + result);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        String ns;
        String result = prefix + "/" + name;
        if (result.startsWith(ns = ARIES_SERVICES)) {
            ns = "";
        }
        this.parser.parse(ns + result);
        return result;
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        Hashtable<String, Object> environment = new Hashtable<String, Object>();
        environment.putAll(this.env);
        return environment;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.parser;
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.parser;
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.env.remove(propName);
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void unbind(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void unbind(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }
}

