/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi.startup;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactoryBuilder;
import org.apache.aries.jndi.ContextManagerServiceFactory;
import org.apache.aries.jndi.JREInitialContextFactoryBuilder;
import org.apache.aries.jndi.OSGiInitialContextFactoryBuilder;
import org.apache.aries.jndi.OSGiObjectFactoryBuilder;
import org.apache.aries.jndi.ProviderAdminServiceFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.jndi.JNDIContextManager;
import org.osgi.service.jndi.JNDIProviderAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator {
    private List<ServiceRegistration> registrations = new ArrayList<ServiceRegistration>();
    private OSGiInitialContextFactoryBuilder icfBuilder;
    private OSGiObjectFactoryBuilder ofBuilder;

    public void start(BundleContext context) {
        Object builder;
        try {
            builder = new OSGiInitialContextFactoryBuilder(context);
            NamingManager.setInitialContextFactoryBuilder((InitialContextFactoryBuilder)builder);
            this.icfBuilder = builder;
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            System.err.println("Cannot set the InitialContextFactoryBuilder. Another builder is already installed");
        }
        try {
            builder = new OSGiObjectFactoryBuilder(context);
            NamingManager.setObjectFactoryBuilder((ObjectFactoryBuilder)builder);
            this.ofBuilder = builder;
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            System.err.println("Cannot set the ObjectFactoryBuilder. Another builder is already installed");
        }
        this.registrations.add(context.registerService(JNDIProviderAdmin.class.getName(), (Object)new ProviderAdminServiceFactory(context), null));
        this.registrations.add(context.registerService(InitialContextFactoryBuilder.class.getName(), (Object)new JREInitialContextFactoryBuilder(), null));
        this.registrations.add(context.registerService(JNDIContextManager.class.getName(), (Object)new ContextManagerServiceFactory(context), null));
    }

    public void stop(BundleContext context) {
        if (this.icfBuilder != null) {
            Activator.unsetField(InitialContextFactoryBuilder.class);
        }
        if (this.ofBuilder != null) {
            Activator.unsetField(ObjectFactoryBuilder.class);
        }
        for (ServiceRegistration registration : this.registrations) {
            registration.unregister();
        }
        this.registrations.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unsetField(Class<?> expectedType) {
        try {
            for (Field field : NamingManager.class.getDeclaredFields()) {
                if (!expectedType.equals(field.getType())) continue;
                boolean accessible = field.isAccessible();
                field.setAccessible(true);
                try {
                    field.set(null, null);
                }
                finally {
                    field.setAccessible(accessible);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

