/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi.services;

import java.util.HashSet;
import java.util.concurrent.Callable;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Dispatcher;
import net.sf.cglib.proxy.Enhancer;
import org.apache.aries.jndi.services.ProxyFactory;
import org.apache.aries.util.BundleToClassLoaderAdapter;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CgLibProxyFactory
implements ProxyFactory {
    @Override
    public Object createProxy(Bundle bundle, Class[] classes, final Callable<Object> dispatcher) {
        Enhancer e = new Enhancer();
        e.setClassLoader((ClassLoader)((Object)new CgLibClassLoader(bundle)));
        e.setSuperclass(this.getTargetClass(classes));
        e.setInterfaces((Class[])CgLibProxyFactory.getInterfaces(classes));
        e.setInterceptDuringConstruction(false);
        e.setCallback((Callback)new Dispatcher(){

            public Object loadObject() throws Exception {
                return dispatcher.call();
            }
        });
        e.setUseFactory(false);
        return e.create();
    }

    private static Class<?>[] getInterfaces(Class<?>[] classes) {
        HashSet interfaces = new HashSet();
        for (Class<?> clazz : classes) {
            if (!clazz.isInterface()) continue;
            interfaces.add(clazz);
        }
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    protected Class<?> getTargetClass(Class<?>[] interfaceNames) {
        Class root = Object.class;
        for (Class<?> clazz : interfaceNames) {
            if (clazz.isInterface()) continue;
            if (root.isAssignableFrom(clazz)) {
                root = clazz;
                continue;
            }
            if (clazz.isAssignableFrom(root)) continue;
            throw new IllegalArgumentException("Classes " + root.getClass().getName() + " and " + clazz.getName() + " are not in the same hierarchy");
        }
        return root;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CgLibClassLoader
    extends BundleToClassLoaderAdapter {
        private ClassLoader cgLibClassLoader = Enhancer.class.getClassLoader();

        public CgLibClassLoader(Bundle bundle) {
            super(bundle);
        }

        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (name.startsWith("net.sf.cglib")) {
                return this.cgLibClassLoader.loadClass(name);
            }
            return super.loadClass(name);
        }
    }
}

