/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi;

import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ObjectFactoryBuilder;
import org.apache.aries.jndi.Utils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectFactoryHelper
implements ObjectFactory {
    protected BundleContext defaultContext;
    protected BundleContext callerContext;

    public ObjectFactoryHelper(BundleContext defaultContext, BundleContext callerContext) {
        this.defaultContext = defaultContext;
        this.callerContext = callerContext;
    }

    @Override
    public Object getObjectInstance(final Object obj, final Name name, final Context nameCtx, final Hashtable<?, ?> environment) throws Exception {
        return Utils.doPrivileged(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                return ObjectFactoryHelper.this.doGetObjectInstance(obj, name, nameCtx, environment);
            }
        });
    }

    private Object doGetObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj instanceof Referenceable) {
            obj = ((Referenceable)obj).getReference();
        }
        Object result = obj;
        if (obj instanceof Reference) {
            Reference ref = (Reference)obj;
            String className = ref.getFactoryClassName();
            result = className != null ? this.getObjectInstanceUsingClassName(obj, className, obj, name, nameCtx, environment) : this.getObjectInstanceUsingRefAddress(ref.getAll(), obj, name, nameCtx, environment);
        }
        if (result == null || result == obj) {
            result = this.getObjectInstanceUsingObjectFactoryBuilders(obj, name, nameCtx, environment);
        }
        if ((result == null || result == obj) && (obj instanceof Reference && ((Reference)obj).getFactoryClassName() == null || !(obj instanceof Reference))) {
            result = this.getObjectInstanceUsingObjectFactories(obj, name, nameCtx, environment);
        }
        return result == null ? obj : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObjectInstanceUsingObjectFactories(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Object result;
        block7: {
            result = null;
            try {
                ServiceReference[] refs = this.callerContext.getServiceReferences(ObjectFactory.class.getName(), null);
                if (refs == null) break block7;
                Arrays.sort(refs, Utils.SERVICE_REFERENCE_COMPARATOR);
                for (ServiceReference ref : refs) {
                    ObjectFactory factory = (ObjectFactory)this.callerContext.getService(ref);
                    try {
                        result = factory.getObjectInstance(obj, name, nameCtx, environment);
                    }
                    finally {
                        this.callerContext.ungetService(ref);
                    }
                    if (result == null || result == obj) {
                        continue;
                    }
                    break;
                }
            }
            catch (InvalidSyntaxException e) {
                throw new RuntimeException("Invalid filter", e);
            }
        }
        return result == null ? obj : result;
    }

    protected static String getUrlScheme(String name) {
        String scheme = name;
        int index = name.indexOf(58);
        if (index != -1) {
            scheme = name.substring(0, index);
        }
        return scheme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getObjectInstanceUsingRefAddress(Enumeration<RefAddr> addresses, Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Object result = null;
        while (addresses.hasMoreElements()) {
            RefAddr address = addresses.nextElement();
            if (!(address instanceof StringRefAddr) || !"URL".equals(address.getType())) continue;
            String urlScheme = ObjectFactoryHelper.getUrlScheme((String)address.getContent());
            ObjectFactory factory = null;
            ServiceReference ref = null;
            try {
                ServiceReference[] services = this.callerContext.getServiceReferences(ObjectFactory.class.getName(), "(&(osgi.jndi.url.scheme=" + urlScheme + "))");
                if (services != null && services.length > 0) {
                    ref = services[0];
                }
            }
            catch (InvalidSyntaxException e) {
                throw new RuntimeException("Invalid filter", e);
            }
            if (ref == null) continue;
            factory = (ObjectFactory)this.callerContext.getService(ref);
            String value = (String)address.getContent();
            try {
                result = factory.getObjectInstance(value, name, nameCtx, environment);
            }
            finally {
                this.callerContext.ungetService(ref);
            }
            if (result == null || result == obj) continue;
            break;
        }
        return result == null ? obj : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getObjectInstanceUsingClassName(Object reference, String className, Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        ServiceReference serviceReference = null;
        try {
            ServiceReference[] refs = this.defaultContext.getServiceReferences(className, null);
            if (refs != null && refs.length > 0) {
                serviceReference = refs[0];
            }
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException("Invalid filter", e);
        }
        Object result = null;
        if (serviceReference != null) {
            ObjectFactory factory = (ObjectFactory)this.defaultContext.getService(serviceReference);
            try {
                result = factory.getObjectInstance(reference, name, nameCtx, environment);
            }
            finally {
                this.defaultContext.ungetService(serviceReference);
            }
        }
        return result == null ? obj : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getObjectInstanceUsingObjectFactoryBuilders(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        ObjectFactory factory;
        block10: {
            factory = null;
            try {
                ServiceReference[] refs = this.callerContext.getServiceReferences(ObjectFactoryBuilder.class.getName(), null);
                if (refs == null) break block10;
                Arrays.sort(refs, Utils.SERVICE_REFERENCE_COMPARATOR);
                for (ServiceReference ref : refs) {
                    ObjectFactoryBuilder builder = (ObjectFactoryBuilder)this.callerContext.getService(ref);
                    try {
                        factory = builder.createObjectFactory(obj, environment);
                    }
                    catch (NamingException e) {
                    }
                    finally {
                        this.callerContext.ungetService(ref);
                    }
                    if (factory == null) {
                        continue;
                    }
                    break;
                }
            }
            catch (InvalidSyntaxException e) {
                throw new RuntimeException("Invalid filter", e);
            }
        }
        Object result = null;
        if (factory != null) {
            result = factory.getObjectInstance(obj, name, nameCtx, environment);
        }
        return result == null ? obj : result;
    }
}

