/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import org.apache.aries.jndi.ContextHelper;
import org.apache.aries.jndi.Utils;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegateContext
implements DirContext {
    private Hashtable<Object, Object> env = new Hashtable();
    private BundleContext bundleContext;
    private ContextHelper.ContextProvider contextProvider;
    private boolean rebind;

    public DelegateContext(BundleContext bundleContext, Hashtable<?, ?> theEnv) {
        this.bundleContext = bundleContext;
        this.env.putAll(theEnv);
        this.rebind = false;
    }

    public DelegateContext(BundleContext bundleContext, ContextHelper.ContextProvider contextProvider) throws NamingException {
        this.bundleContext = bundleContext;
        this.contextProvider = contextProvider;
        this.env.putAll(contextProvider.context.getEnvironment());
        this.rebind = true;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        Context ctx = this.getDefaultContext();
        if (ctx != null) {
            ctx.addToEnvironment(propName, propVal);
        }
        return this.env.put(propName, propVal);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.findContext(name).bind(name, obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.findContext(name).bind(name, obj);
    }

    @Override
    public void close() throws NamingException {
        if (this.contextProvider != null) {
            this.contextProvider.context.close();
        }
        this.env.clear();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return this.findContext(name).composeName(name, prefix);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.findContext(name).composeName(name, prefix);
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.findContext(name).createSubcontext(name);
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.findContext(name).createSubcontext(name);
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.findContext(name).destroySubcontext(name);
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.findContext(name).destroySubcontext(name);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        Hashtable<Object, Object> theEnv = new Hashtable<Object, Object>();
        theEnv.putAll(this.env);
        return theEnv;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.getDefaultContext().getNameInNamespace();
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.findContext(name).getNameParser(name);
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.findContext(name).getNameParser(name);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.findContext(name).list(name);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.findContext(name).list(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.findContext(name).listBindings(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.findContext(name).listBindings(name);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.findContext(name).lookup(name);
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.findContext(name).lookup(name);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.findContext(name).lookupLink(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.findContext(name).lookupLink(name);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.findContext(name).rebind(name, obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.findContext(name).rebind(name, obj);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        Context ctx = this.getDefaultContext();
        if (ctx != null) {
            ctx.removeFromEnvironment(propName);
        }
        return this.env.remove(propName);
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.findContext(oldName).rename(oldName, newName);
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.findContext(oldName).rename(oldName, newName);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.findContext(name).unbind(name);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.findContext(name).unbind(name);
    }

    protected Context findContext(Name name) throws NamingException {
        return this.findContext(name.toString());
    }

    protected Context findContext(String name) throws NamingException {
        String packages;
        Context toReturn = null;
        toReturn = name.contains(":") ? this.getURLContext(name) : this.getDefaultContext();
        if (toReturn != null && (packages = Utils.getSystemProperty("java.naming.factory.url.pkgs", null)) != null) {
            toReturn.addToEnvironment("java.naming.factory.url.pkgs", packages);
        }
        return toReturn;
    }

    private Context getDefaultContext() throws NamingException {
        if (this.rebind) {
            if (this.contextProvider == null || !this.contextProvider.isValid()) {
                this.contextProvider = ContextHelper.getContextProvider(this.bundleContext, this.env);
            }
            if (this.contextProvider == null) {
                throw new NoInitialContextException();
            }
            return this.contextProvider.context;
        }
        throw new NoInitialContextException();
    }

    private Context getURLContext(String name) throws NamingException {
        Context ctx = null;
        int index = name.indexOf(58);
        if (index != -1) {
            String scheme = name.substring(0, index);
            ctx = ContextHelper.createURLContext(this.bundleContext, scheme, this.env);
        }
        if (ctx == null) {
            ctx = this.getDefaultContext();
        }
        return ctx;
    }

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        return ((DirContext)this.findContext(name)).getAttributes(name);
    }

    @Override
    public Attributes getAttributes(String name) throws NamingException {
        return ((DirContext)this.findContext(name)).getAttributes(name);
    }

    @Override
    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        return ((DirContext)this.findContext(name)).getAttributes(name, attrIds);
    }

    @Override
    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        return ((DirContext)this.findContext(name)).getAttributes(name, attrIds);
    }

    @Override
    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        ((DirContext)this.findContext(name)).modifyAttributes(name, mod_op, attrs);
    }

    @Override
    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        ((DirContext)this.findContext(name)).modifyAttributes(name, mod_op, attrs);
    }

    @Override
    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        ((DirContext)this.findContext(name)).modifyAttributes(name, mods);
    }

    @Override
    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        ((DirContext)this.findContext(name)).modifyAttributes(name, mods);
    }

    @Override
    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        ((DirContext)this.findContext(name)).bind(name, obj, attrs);
    }

    @Override
    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        ((DirContext)this.findContext(name)).bind(name, obj, attrs);
    }

    @Override
    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        ((DirContext)this.findContext(name)).rebind(name, obj, attrs);
    }

    @Override
    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        ((DirContext)this.findContext(name)).rebind(name, obj, attrs);
    }

    @Override
    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        return ((DirContext)this.findContext(name)).createSubcontext(name, attrs);
    }

    @Override
    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        return ((DirContext)this.findContext(name)).createSubcontext(name, attrs);
    }

    @Override
    public DirContext getSchema(Name name) throws NamingException {
        return ((DirContext)this.findContext(name)).getSchema(name);
    }

    @Override
    public DirContext getSchema(String name) throws NamingException {
        return ((DirContext)this.findContext(name)).getSchema(name);
    }

    @Override
    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        return ((DirContext)this.findContext(name)).getSchemaClassDefinition(name);
    }

    @Override
    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        return ((DirContext)this.findContext(name)).getSchemaClassDefinition(name);
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return ((DirContext)this.findContext(name)).search(name, matchingAttributes, attributesToReturn);
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return ((DirContext)this.findContext(name)).search(name, matchingAttributes, attributesToReturn);
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes) throws NamingException {
        return ((DirContext)this.findContext(name)).search(name, matchingAttributes);
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes) throws NamingException {
        return ((DirContext)this.findContext(name)).search(name, matchingAttributes);
    }

    public NamingEnumeration search(Name name, String filter, SearchControls cons) throws NamingException {
        return ((DirContext)this.findContext(name)).search(name, filter, cons);
    }

    public NamingEnumeration search(String name, String filter, SearchControls cons) throws NamingException {
        return ((DirContext)this.findContext(name)).search(name, filter, cons);
    }

    public NamingEnumeration search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return ((DirContext)this.findContext(name)).search(name, filterExpr, filterArgs, cons);
    }

    public NamingEnumeration search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return ((DirContext)this.findContext(name)).search(name, filterExpr, filterArgs, cons);
    }
}

