/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi;

import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.ObjectFactory;
import org.apache.aries.jndi.DelegateContext;
import org.apache.aries.jndi.Utils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContextHelper {
    private ContextHelper() {
        throw new RuntimeException();
    }

    public static Context createURLContext(final BundleContext context, final String urlScheme, final Hashtable<?, ?> env) throws NamingException {
        return Utils.doPrivilegedNaming(new PrivilegedExceptionAction<Context>(){

            @Override
            public Context run() throws Exception {
                return ContextHelper.doCreateURLContext(context, urlScheme, env);
            }
        });
    }

    private static Context doCreateURLContext(BundleContext context, String urlScheme, Hashtable<?, ?> env) throws NamingException {
        ServiceReference ref = null;
        try {
            ServiceReference[] services = context.getServiceReferences(ObjectFactory.class.getName(), "(osgi.jndi.url.scheme=" + urlScheme.trim() + ")");
            if (services != null) {
                ref = services[0];
            }
        }
        catch (InvalidSyntaxException e1) {
            NamingException e = new NamingException("Argh this should never happen :)");
            e.initCause(e1);
            throw e;
        }
        Context ctx = null;
        if (ref != null) {
            ObjectFactory factory = (ObjectFactory)context.getService(ref);
            try {
                Context context2 = (Context)factory.getObjectInstance(null, null, null, env);
                return context2;
            }
            catch (Exception e) {
                NamingException e2 = new NamingException();
                e2.initCause(e);
                throw e2;
            }
            finally {
                if (ref != null) {
                    context.ungetService(ref);
                }
            }
        }
        return ctx;
    }

    public static Context getInitialContext(BundleContext context, Hashtable<?, ?> environment) throws NamingException {
        ContextProvider provider = ContextHelper.getContextProvider(context, environment);
        String contextFactoryClass = (String)environment.get("java.naming.factory.initial");
        if (contextFactoryClass == null) {
            if (provider == null) {
                return new DelegateContext(context, environment);
            }
            return new DelegateContext(context, provider);
        }
        if (provider == null) {
            throw new NoInitialContextException("We could not find an InitialContextFactory to use");
        }
        return new DelegateContext(context, provider);
    }

    public static ContextProvider getContextProvider(final BundleContext context, final Hashtable<?, ?> environment) throws NamingException {
        return Utils.doPrivilegedNaming(new PrivilegedExceptionAction<ContextProvider>(){

            @Override
            public ContextProvider run() throws Exception {
                return ContextHelper.doGetContextProvider(context, environment);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ContextProvider doGetContextProvider(BundleContext context, Hashtable<?, ?> environment) throws NamingException {
        ContextProvider provider = null;
        String contextFactoryClass = (String)environment.get("java.naming.factory.initial");
        if (contextFactoryClass == null) {
            provider = ContextHelper.getInitialContextUsingBuilder(context, environment);
            if (provider == null) {
                String filter = "(&(objectClass=javax.naming.spi.InitialContextFactory))";
                ServiceReference[] references = null;
                try {
                    references = context.getAllServiceReferences(InitialContextFactory.class.getName(), filter);
                }
                catch (InvalidSyntaxException e) {
                    NamingException ex = new NamingException("Bad filter: " + filter);
                    ex.initCause(e);
                    throw ex;
                }
                if (references != null) {
                    Context initialContext = null;
                    Arrays.sort(references, Utils.SERVICE_REFERENCE_COMPARATOR);
                    for (ServiceReference reference : references) {
                        InitialContextFactory factory = (InitialContextFactory)context.getService(reference);
                        try {
                            initialContext = factory.getInitialContext(environment);
                        }
                        finally {
                            context.ungetService(reference);
                        }
                        if (initialContext == null) continue;
                        provider = new ContextProvider(reference, initialContext);
                        break;
                    }
                }
            }
        } else {
            String filter = "(&(objectClass=javax.naming.spi.InitialContextFactory)(objectClass=" + contextFactoryClass + "))";
            ServiceReference[] references = null;
            try {
                references = context.getServiceReferences(InitialContextFactory.class.getName(), filter);
            }
            catch (InvalidSyntaxException e) {
                NamingException ex = new NamingException("Bad filter: " + filter);
                ex.initCause(e);
                throw ex;
            }
            if (references != null && references.length > 0) {
                Context initialContext = null;
                Arrays.sort(references, Utils.SERVICE_REFERENCE_COMPARATOR);
                ServiceReference reference = references[0];
                InitialContextFactory factory = (InitialContextFactory)context.getService(reference);
                try {
                    initialContext = factory.getInitialContext(environment);
                }
                finally {
                    context.ungetService(reference);
                }
                if (initialContext != null) {
                    provider = new ContextProvider(reference, initialContext);
                }
            }
            if (provider == null) {
                provider = ContextHelper.getInitialContextUsingBuilder(context, environment);
            }
        }
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ContextProvider getInitialContextUsingBuilder(BundleContext context, Hashtable<?, ?> environment) throws NamingException {
        ContextProvider provider;
        block8: {
            provider = null;
            try {
                ServiceReference[] refs = context.getAllServiceReferences(InitialContextFactoryBuilder.class.getName(), null);
                if (refs == null) break block8;
                InitialContextFactory factory = null;
                Arrays.sort(refs, Utils.SERVICE_REFERENCE_COMPARATOR);
                for (ServiceReference ref : refs) {
                    InitialContextFactoryBuilder builder = (InitialContextFactoryBuilder)context.getService(ref);
                    try {
                        factory = builder.createInitialContextFactory(environment);
                    }
                    catch (NamingException e) {
                    }
                    finally {
                        context.ungetService(ref);
                    }
                    if (factory == null) continue;
                    provider = new ContextProvider(ref, factory.getInitialContext(environment));
                    break;
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
        return provider;
    }

    public static class ContextProvider {
        ServiceReference reference;
        Context context;

        public ContextProvider(ServiceReference reference, Context context) {
            this.reference = reference;
            this.context = context;
        }

        public boolean isValid() {
            return this.reference.getBundle() != null;
        }
    }
}

