/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.plugin.esa;

import aQute.lib.osgi.Analyzer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.osgi.DefaultMaven2OsgiConverter;
import org.apache.maven.shared.osgi.Maven2OsgiConverter;

public class ContentInfo {
    private static Maven2OsgiConverter maven2OsgiConverter = new DefaultMaven2OsgiConverter();
    private String symbolicName;
    private String type;
    private String version;
    private VersionRange mavenVersionRange;

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public String getContentLine() {
        String line = this.symbolicName;
        if (this.type != null) {
            line = line + ";type=\"" + this.type + "\"";
        }
        if (this.mavenVersionRange != null && this.mavenVersionRange.hasRestrictions()) {
            line = line + ";version=\"" + this.mavenVersionRange + '\"';
        } else if (this.version != null) {
            line = line + ";version=\"[" + this.version + "," + this.version + "]\"";
        }
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ContentInfo create(Artifact artifact, Log log) {
        ZipFile zip = null;
        try {
            zip = new ZipFile(artifact.getFile());
            ZipEntry entry = zip.getEntry("META-INF/MANIFEST.MF");
            if (entry != null) {
                Manifest mf = ContentInfo.getManifest(zip, entry);
                ContentInfo contentInfo = ContentInfo.handleManifest(artifact, mf);
                return contentInfo;
            }
            entry = zip.getEntry("OSGI-INF/SUBSYSTEM.MF");
            if (entry != null) {
                Manifest mf = ContentInfo.getManifest(zip, entry);
                ContentInfo contentInfo = ContentInfo.handleSubsystem(artifact, mf);
                return contentInfo;
            }
            ContentInfo contentInfo = ContentInfo.handleUnknown(artifact);
            return contentInfo;
        }
        catch (Exception e) {
            log.warn((CharSequence)"Error creating content information", (Throwable)e);
            ContentInfo contentInfo = null;
            return contentInfo;
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private static ContentInfo handleUnknown(Artifact artifact) {
        ContentInfo info = new ContentInfo();
        info.symbolicName = maven2OsgiConverter.getBundleSymbolicName(artifact);
        info.version = Analyzer.cleanupVersion((String)artifact.getVersion());
        info.mavenVersionRange = artifact.getVersionRange();
        return info;
    }

    private static ContentInfo handleSubsystem(Artifact artifact, Manifest mf) {
        String subsystemType;
        String subsystemVersion;
        ContentInfo info = new ContentInfo();
        Attributes mainAttributes = mf.getMainAttributes();
        String subsystemSymbolicName = mainAttributes.getValue("Subsystem-SymbolicName");
        if (subsystemSymbolicName != null) {
            Map header = Analyzer.parseHeader((String)subsystemSymbolicName, null);
            info.symbolicName = (String)header.keySet().iterator().next();
        }
        if ((subsystemVersion = mainAttributes.getValue("Subsystem-Version")) != null) {
            info.version = subsystemVersion;
        }
        if ((subsystemType = mainAttributes.getValue("Subsystem-Type")) == null) {
            info.type = "osgi.subsystem.application";
        } else {
            Map header = Analyzer.parseHeader((String)subsystemType, null);
            info.type = (String)header.keySet().iterator().next();
        }
        info.mavenVersionRange = artifact.getVersionRange();
        return info;
    }

    private static ContentInfo handleManifest(Artifact artifact, Manifest mf) {
        Attributes mainAttributes = mf.getMainAttributes();
        String bundleSymbolicName = mainAttributes.getValue("Bundle-SymbolicName");
        if (bundleSymbolicName == null) {
            return ContentInfo.handleUnknown(artifact);
        }
        ContentInfo info = new ContentInfo();
        Map header = Analyzer.parseHeader((String)bundleSymbolicName, null);
        info.symbolicName = (String)header.keySet().iterator().next();
        String bundleVersion = mainAttributes.getValue("Bundle-Version");
        if (bundleVersion != null) {
            info.version = bundleVersion;
        }
        if (mainAttributes.getValue("Fragment-Host") != null) {
            info.type = "osgi.fragment";
        }
        info.mavenVersionRange = artifact.getVersionRange();
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Manifest getManifest(ZipFile zip, ZipEntry entry) throws IOException {
        InputStream in = null;
        try {
            Manifest mf;
            in = zip.getInputStream(entry);
            Manifest manifest = mf = new Manifest(in);
            return manifest;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
            }
        }
    }
}

