/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.testbundlea;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.aries.blueprint.Interceptor;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.ParserContext;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSHandlerTwo
implements NamespaceHandler {
    public static String NSURI = "http://ns.handler.two";
    private static String ELT_NAME = "nshandlertwo";
    private static String ATTRIB_ONE = "attribone";
    private static String ATTRIB_TWO = "attribtwo";
    private static List<String> interceptorLog = new ArrayList<String>();
    private static Interceptor tracker = new Interceptor(){

        private boolean isIgnorableMethod(Method m) {
            return m.getDeclaringClass() == Object.class;
        }

        public Object preCall(ComponentMetadata cm, Method m, Object ... parameters) throws Throwable {
            String args = "[";
            if (parameters != null) {
                if (parameters.length > 0) {
                    args = args + (parameters[0] == null ? "null" : parameters[0].toString());
                }
                for (int index = 1; index < parameters.length; ++index) {
                    args = args + "," + (parameters[index] == null ? "null" : parameters[index].toString());
                }
            }
            args = args + "]";
            String token = cm.getId() + ":" + m.getName() + ":" + args + ":" + System.currentTimeMillis();
            if (!this.isIgnorableMethod(m)) {
                interceptorLog.add("PRECALL:" + token);
            }
            return token;
        }

        public void postCallWithReturn(ComponentMetadata cm, Method m, Object returnType, Object preCallToken) throws Throwable {
            if (!this.isIgnorableMethod(m)) {
                interceptorLog.add("POSTCALL[" + returnType.toString() + "]:" + preCallToken);
            }
        }

        public void postCallWithException(ComponentMetadata cm, Method m, Throwable ex, Object preCallToken) throws Throwable {
            if (!this.isIgnorableMethod(m)) {
                interceptorLog.add("POSTCALLEXCEPTION[" + ex.toString() + "]:" + preCallToken);
            }
        }

        public int getRank() {
            return 0;
        }
    };

    public ComponentMetadata decorate(Node node, ComponentMetadata component, ParserContext context) {
        if (node.getLocalName().equals(ATTRIB_ONE) && (context.getComponentDefinitionRegistry().getInterceptors(component) == null || !context.getComponentDefinitionRegistry().getInterceptors(component).contains(tracker))) {
            context.getComponentDefinitionRegistry().registerInterceptorWithComponent(component, tracker);
        }
        return component;
    }

    public Metadata parse(Element element, ParserContext context) {
        return null;
    }

    public URL getSchemaLocation(String namespace) {
        return this.getClass().getResource("nshandlertwo.xsd");
    }

    public Set<Class> getManagedClasses() {
        return null;
    }

    public List<String> getLog() {
        return Collections.unmodifiableList(interceptorLog);
    }
}

