/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.aries.application.ApplicationMetadata;
import org.apache.aries.application.Content;
import org.apache.aries.application.DeploymentContent;
import org.apache.aries.application.DeploymentMetadata;
import org.apache.aries.application.VersionRange;
import org.apache.aries.application.impl.ApplicationMetadataImpl;
import org.apache.aries.application.impl.DeploymentContentImpl;
import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.BundleInfo;
import org.apache.aries.application.management.ResolverException;
import org.apache.aries.application.utils.manifest.ManifestProcessor;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentMetadataImpl
implements DeploymentMetadata {
    private ApplicationMetadata _applicationMetadata;
    private List<DeploymentContent> _deploymentContent = new ArrayList<DeploymentContent>();
    private List<DeploymentContent> _provisionSharedContent = new ArrayList<DeploymentContent>();

    public DeploymentMetadataImpl(AriesApplication app, Set<BundleInfo> bundlesRequired) throws ResolverException {
        this._applicationMetadata = app.getApplicationMetadata();
        this._deploymentContent = new ArrayList<DeploymentContent>();
        this._provisionSharedContent = new ArrayList<DeploymentContent>();
        HashMap<String, VersionRange> appContent = new HashMap<String, VersionRange>();
        for (Content c : app.getApplicationMetadata().getApplicationContents()) {
            appContent.put(c.getContentName(), c.getVersion());
        }
        for (BundleInfo info : bundlesRequired) {
            VersionRange range = (VersionRange)appContent.get(info.getSymbolicName());
            DeploymentContentImpl dp = new DeploymentContentImpl(info.getSymbolicName(), info.getVersion());
            if (range == null) {
                this._provisionSharedContent.add(dp);
                continue;
            }
            if (range.matches(info.getVersion())) {
                this._deploymentContent.add(dp);
                continue;
            }
            throw new ResolverException("Bundle " + info.getSymbolicName() + " at version " + info.getVersion() + " is not in the range " + range);
        }
    }

    public DeploymentMetadataImpl(Manifest mf) {
        this._applicationMetadata = new ApplicationMetadataImpl(mf);
        Attributes attributes = mf.getMainAttributes();
        this.parseContent(attributes.getValue("Deployed-Content"), this._deploymentContent);
        this.parseContent(attributes.getValue("Provision-Bundle"), this._provisionSharedContent);
    }

    @Override
    public List<DeploymentContent> getApplicationDeploymentContents() {
        return Collections.unmodifiableList(this._deploymentContent);
    }

    @Override
    public List<DeploymentContent> getApplicationProvisionBundles() {
        return Collections.unmodifiableList(this._provisionSharedContent);
    }

    @Override
    public ApplicationMetadata getApplicationMetadata() {
        return this._applicationMetadata;
    }

    @Override
    public String getApplicationSymbolicName() {
        return this._applicationMetadata.getApplicationSymbolicName();
    }

    @Override
    public Version getApplicationVersion() {
        return this._applicationMetadata.getApplicationVersion();
    }

    @Override
    public void store(File f) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(f);
        this.store(fos);
        fos.close();
    }

    @Override
    public void store(OutputStream out) throws IOException {
        Manifest mf = new Manifest();
        Attributes attributes = mf.getMainAttributes();
        attributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        attributes.putValue("Application-Version", this.getApplicationVersion().toString());
        attributes.putValue("Application-SymbolicName", this.getApplicationSymbolicName());
        if (!this._deploymentContent.isEmpty()) {
            attributes.putValue("Deployed-Content", this.getDeploymentContentsAsString(this._deploymentContent));
        }
        if (!this._provisionSharedContent.isEmpty()) {
            attributes.putValue("Provision-Bundle", this.getDeploymentContentsAsString(this._provisionSharedContent));
        }
        mf.write(out);
    }

    private String getDeploymentContentsAsString(List<DeploymentContent> content) {
        StringBuilder builder = new StringBuilder();
        for (DeploymentContent dc : content) {
            builder.append(dc.getContentName());
            builder.append(";deployed-version=");
            builder.append(dc.getExactVersion());
            builder.append(",");
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    private void parseContent(String content, List<DeploymentContent> contents) {
        List<String> pcList = ManifestProcessor.split(content, ",");
        for (String s : pcList) {
            contents.add(new DeploymentContentImpl(s));
        }
    }
}

