/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.runtime.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.aries.application.DeploymentContent;
import org.apache.aries.application.DeploymentMetadata;
import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.AriesApplicationContext;
import org.apache.aries.application.management.AriesApplicationResolver;
import org.apache.aries.application.management.BundleInfo;
import org.apache.aries.application.management.ManagementException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationContextImpl
implements AriesApplicationContext {
    private AriesApplication _application;
    private Map<BundleInfo, Bundle> _bundles;
    private AriesApplicationContext.ApplicationState _state;
    private BundleContext _bundleContext;

    public ApplicationContextImpl(BundleContext b, AriesApplication app) throws BundleException, ManagementException {
        this._bundleContext = b;
        this._application = app;
        this._bundles = new HashMap<BundleInfo, Bundle>();
        DeploymentMetadata meta = this._application.getDeploymentMetadata();
        AriesApplicationResolver resolver = null;
        ServiceReference ref = b.getServiceReference(AriesApplicationResolver.class.getName());
        if (ref != null) {
            resolver = (AriesApplicationResolver)b.getService(ref);
        }
        if (resolver == null) {
            throw new ManagementException((Exception)((Object)new ServiceException(AriesApplicationResolver.class.getName(), 1)));
        }
        try {
            ArrayList<DeploymentContent> bundlesToInstall = new ArrayList<DeploymentContent>(meta.getApplicationDeploymentContents());
            bundlesToInstall.addAll(meta.getApplicationProvisionBundles());
            for (DeploymentContent content : bundlesToInstall) {
                String bundleSymbolicName = content.getContentName();
                Version bundleVersion = content.getExactVersion();
                BundleInfo bundleInfo = null;
                for (BundleInfo info : this._application.getBundleInfo()) {
                    if (!info.getSymbolicName().equals(bundleSymbolicName) || !info.getVersion().equals((Object)bundleVersion)) continue;
                    bundleInfo = info;
                    break;
                }
                if (bundleInfo == null) {
                    bundleInfo = resolver.getBundleInfo(bundleSymbolicName, bundleVersion);
                }
                if (bundleInfo == null) {
                    throw new ManagementException("Cound not find bundles: " + bundleSymbolicName + "_" + bundleVersion);
                }
                Bundle bundle = this._bundleContext.installBundle(bundleInfo.getLocation());
                this._bundles.put(bundleInfo, bundle);
            }
        }
        catch (BundleException be) {
            for (Bundle bundle : this._bundles.values()) {
                bundle.uninstall();
            }
            this._bundles.clear();
            throw be;
        }
        finally {
            if (resolver != null) {
                b.ungetService(ref);
            }
        }
        this._state = AriesApplicationContext.ApplicationState.INSTALLED;
    }

    @Override
    public AriesApplication getApplication() {
        return this._application;
    }

    @Override
    public Set<Bundle> getApplicationContent() {
        HashSet<Bundle> result = new HashSet<Bundle>();
        for (Map.Entry<BundleInfo, Bundle> entry : this._bundles.entrySet()) {
            result.add(entry.getValue());
        }
        return result;
    }

    @Override
    public AriesApplicationContext.ApplicationState getApplicationState() {
        return this._state;
    }

    @Override
    public void start() throws BundleException {
        this._state = AriesApplicationContext.ApplicationState.STARTING;
        ArrayList<Bundle> bundlesWeStarted = new ArrayList<Bundle>();
        try {
            for (Bundle b : this._bundles.values()) {
                if (b.getState() == 32) continue;
                b.start(2);
                bundlesWeStarted.add(b);
            }
        }
        catch (BundleException be) {
            for (Bundle b : bundlesWeStarted) {
                try {
                    b.stop();
                }
                catch (BundleException be2) {}
            }
            this._state = AriesApplicationContext.ApplicationState.INSTALLED;
            throw be;
        }
        this._state = AriesApplicationContext.ApplicationState.ACTIVE;
    }

    @Override
    public void stop() throws BundleException {
        for (Map.Entry<BundleInfo, Bundle> entry : this._bundles.entrySet()) {
            Bundle b = entry.getValue();
            b.stop();
        }
        this._state = AriesApplicationContext.ApplicationState.RESOLVED;
    }

    public void setState(AriesApplicationContext.ApplicationState state) {
        this._state = state;
    }
}

