/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.jar.Manifest;
import org.apache.aries.application.ApplicationMetadata;
import org.apache.aries.application.ApplicationMetadataFactory;
import org.apache.aries.application.Content;
import org.apache.aries.application.VersionRange;
import org.apache.aries.application.impl.ApplicationMetadataImpl;
import org.apache.aries.application.impl.ContentImpl;
import org.apache.aries.application.impl.VersionRangeImpl;
import org.apache.aries.application.utils.manifest.ManifestProcessor;
import org.osgi.framework.Version;

public class ApplicationMetadataFactoryImpl
implements ApplicationMetadataFactory {
    public ConcurrentMap<String, ApplicationMetadata> applications = new ConcurrentHashMap<String, ApplicationMetadata>();

    public ApplicationMetadata getApplicationMetadata(String applicationSymbolicName, Version version) {
        ApplicationMetadata metadata = (ApplicationMetadata)this.applications.get(applicationSymbolicName + "_" + version);
        return metadata;
    }

    public ApplicationMetadata parseApplicationMetadata(InputStream in) throws IOException {
        Manifest man = ManifestProcessor.parseManifest(in);
        ApplicationMetadataImpl metadata = new ApplicationMetadataImpl(man);
        return metadata;
    }

    public boolean registerApplication(ApplicationMetadata app) {
        ApplicationMetadata existingApp = this.applications.putIfAbsent(app.getApplicationScope(), app);
        return existingApp == null;
    }

    public ApplicationMetadata createApplicationMetadata(Manifest man) {
        return new ApplicationMetadataImpl(man);
    }

    public boolean unregisterApplication(ApplicationMetadata app) {
        return this.applications.remove(app.getApplicationScope()) != null;
    }

    public Content parseContent(String content) {
        return new ContentImpl(content);
    }

    public VersionRange parseVersionRange(String versionRange) {
        return new VersionRangeImpl(versionRange);
    }
}

