/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.services;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.Response;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.common.utils.VersionComparator;
import org.apache.archiva.common.utils.VersionUtil;
import org.apache.archiva.dependency.tree.maven2.DependencyTreeBuilder;
import org.apache.archiva.maven2.metadata.MavenMetadataReader;
import org.apache.archiva.maven2.model.Artifact;
import org.apache.archiva.maven2.model.TreeEntry;
import org.apache.archiva.metadata.generic.GenericMetadataFacet;
import org.apache.archiva.metadata.model.ArtifactMetadata;
import org.apache.archiva.metadata.model.MetadataFacet;
import org.apache.archiva.metadata.model.ProjectVersionMetadata;
import org.apache.archiva.metadata.model.ProjectVersionReference;
import org.apache.archiva.metadata.repository.MetadataRepository;
import org.apache.archiva.metadata.repository.MetadataResolutionException;
import org.apache.archiva.metadata.repository.MetadataResolver;
import org.apache.archiva.metadata.repository.RepositorySession;
import org.apache.archiva.metadata.repository.storage.maven2.ArtifactMetadataVersionComparator;
import org.apache.archiva.metadata.repository.storage.maven2.MavenProjectFacet;
import org.apache.archiva.model.ArchivaArtifact;
import org.apache.archiva.model.ArchivaRepositoryMetadata;
import org.apache.archiva.proxy.model.RepositoryProxyConnectors;
import org.apache.archiva.redback.components.cache.Cache;
import org.apache.archiva.repository.ManagedRepositoryContent;
import org.apache.archiva.repository.RepositoryContentFactory;
import org.apache.archiva.repository.RepositoryException;
import org.apache.archiva.repository.RepositoryNotFoundException;
import org.apache.archiva.rest.api.model.ArtifactContent;
import org.apache.archiva.rest.api.model.ArtifactContentEntry;
import org.apache.archiva.rest.api.model.BrowseResult;
import org.apache.archiva.rest.api.model.BrowseResultEntry;
import org.apache.archiva.rest.api.model.Entry;
import org.apache.archiva.rest.api.model.MetadataAddRequest;
import org.apache.archiva.rest.api.model.VersionsList;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;
import org.apache.archiva.rest.api.services.BrowseService;
import org.apache.archiva.rest.services.AbstractRestService;
import org.apache.archiva.rest.services.utils.ArtifactContentEntryComparator;
import org.apache.archiva.security.ArchivaSecurityException;
import org.apache.archiva.xml.XMLException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="browseService#rest")
public class DefaultBrowseService
extends AbstractRestService
implements BrowseService {
    @Inject
    private DependencyTreeBuilder dependencyTreeBuilder;
    @Inject
    private RepositoryContentFactory repositoryContentFactory;
    @Inject
    @Named(value="repositoryProxyConnectors#default")
    private RepositoryProxyConnectors connectors;
    @Inject
    @Named(value="browse#versionMetadata")
    private Cache<String, ProjectVersionMetadata> versionMetadataCache;

    public BrowseResult getRootGroups(String repositoryId) throws ArchivaRestServiceException {
        List<String> selectedRepos = this.getSelectedRepos(repositoryId);
        LinkedHashSet<String> namespaces = new LinkedHashSet<String>();
        LinkedHashSet namespacesToCollapse = new LinkedHashSet();
        try (RepositorySession repositorySession = this.repositorySessionFactory.createSession();){
            MetadataResolver metadataResolver = repositorySession.getResolver();
            for (String repoId : selectedRepos) {
                namespacesToCollapse.addAll(metadataResolver.resolveRootNamespaces(repositorySession, repoId));
            }
            for (String n : namespacesToCollapse) {
                namespaces.add(this.collapseNamespaces(repositorySession, metadataResolver, selectedRepos, n));
            }
        }
        ArrayList<BrowseResultEntry> browseGroupResultEntries = new ArrayList<BrowseResultEntry>(namespaces.size());
        for (String namespace : namespaces) {
            browseGroupResultEntries.add(new BrowseResultEntry(namespace, false));
        }
        Collections.sort(browseGroupResultEntries);
        return new BrowseResult(browseGroupResultEntries);
    }

    public BrowseResult browseGroupId(String groupId, String repositoryId) throws ArchivaRestServiceException {
        LinkedHashSet<String> namespaces;
        List<String> selectedRepos = this.getSelectedRepos(repositoryId);
        LinkedHashSet projects = new LinkedHashSet();
        try (RepositorySession repositorySession = this.repositorySessionFactory.createSession();){
            MetadataResolver metadataResolver = repositorySession.getResolver();
            LinkedHashSet namespacesToCollapse = new LinkedHashSet();
            for (String repoId : selectedRepos) {
                namespacesToCollapse.addAll(metadataResolver.resolveNamespaces(repositorySession, repoId, groupId));
                projects.addAll(metadataResolver.resolveProjects(repositorySession, repoId, groupId));
            }
            namespaces = new LinkedHashSet<String>();
            for (String n : namespacesToCollapse) {
                namespaces.add(this.collapseNamespaces(repositorySession, metadataResolver, selectedRepos, groupId + "." + n));
            }
        }
        ArrayList<BrowseResultEntry> browseGroupResultEntries = new ArrayList<BrowseResultEntry>(namespaces.size() + projects.size());
        for (String namespace : namespaces) {
            browseGroupResultEntries.add(new BrowseResultEntry(namespace, false).groupId(namespace));
        }
        for (String project : projects) {
            browseGroupResultEntries.add(new BrowseResultEntry(groupId + '.' + project, true).groupId(groupId).artifactId(project));
        }
        Collections.sort(browseGroupResultEntries);
        return new BrowseResult(browseGroupResultEntries);
    }

    public VersionsList getVersionsList(String groupId, String artifactId, String repositoryId) throws ArchivaRestServiceException {
        List<String> selectedRepos = this.getSelectedRepos(repositoryId);
        try {
            Collection<String> versions = this.getVersions(selectedRepos, groupId, artifactId);
            return new VersionsList(new ArrayList<String>(versions));
        }
        catch (MetadataResolutionException e) {
            throw new ArchivaRestServiceException(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String> getVersions(List<String> selectedRepos, String groupId, String artifactId) throws MetadataResolutionException {
        try (RepositorySession repositorySession = this.repositorySessionFactory.createSession();){
            MetadataResolver metadataResolver = repositorySession.getResolver();
            LinkedHashSet versions = new LinkedHashSet();
            for (String repoId : selectedRepos) {
                Collection projectVersions = metadataResolver.resolveProjectVersions(repositorySession, repoId, groupId, artifactId);
                versions.addAll(projectVersions);
            }
            ArrayList<String> sortedVersions = new ArrayList<String>(versions);
            Collections.sort(sortedVersions, VersionComparator.getInstance());
            ArrayList<String> arrayList = sortedVersions;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectVersionMetadata getProjectMetadata(String groupId, String artifactId, String version, String repositoryId) throws ArchivaRestServiceException {
        List<String> selectedRepos = this.getSelectedRepos(repositoryId);
        try (RepositorySession repositorySession = null;){
            repositorySession = this.repositorySessionFactory.createSession();
            MetadataResolver metadataResolver = repositorySession.getResolver();
            ProjectVersionMetadata versionMetadata = null;
            for (String repoId : selectedRepos) {
                if (versionMetadata != null && !versionMetadata.isIncomplete()) continue;
                try {
                    ProjectVersionMetadata versionMetadataTmp = metadataResolver.resolveProjectVersion(repositorySession, repoId, groupId, artifactId, version);
                    if (versionMetadata != null || versionMetadataTmp == null) continue;
                    versionMetadata = versionMetadataTmp;
                }
                catch (MetadataResolutionException e) {
                    this.log.warn("Skipping invalid metadata while compiling shared model for {}:{} in repo {}: {}", new Object[]{groupId, artifactId, repoId, e.getMessage()});
                }
            }
            ProjectVersionMetadata projectVersionMetadata = versionMetadata;
            return projectVersionMetadata;
        }
    }

    public ProjectVersionMetadata getProjectVersionMetadata(String groupId, String artifactId, String repositoryId) throws ArchivaRestServiceException {
        List<String> selectedRepos = this.getSelectedRepos(repositoryId);
        try (RepositorySession repositorySession = null;){
            Collection<String> projectVersions = this.getVersions(selectedRepos, groupId, artifactId);
            repositorySession = this.repositorySessionFactory.createSession();
            MetadataResolver metadataResolver = repositorySession.getResolver();
            ProjectVersionMetadata sharedModel = new ProjectVersionMetadata();
            MavenProjectFacet mavenFacet = new MavenProjectFacet();
            mavenFacet.setGroupId(groupId);
            mavenFacet.setArtifactId(artifactId);
            sharedModel.addFacet((MetadataFacet)mavenFacet);
            boolean isFirstVersion = true;
            for (String version : projectVersions) {
                ProjectVersionMetadata versionMetadata = null;
                for (String repoId : selectedRepos) {
                    if (versionMetadata != null && !versionMetadata.isIncomplete()) continue;
                    try {
                        ProjectVersionMetadata projectVersionMetadataResolved = null;
                        boolean useCache = !StringUtils.endsWith((String)version, (String)"SNAPSHOT");
                        String cacheKey = null;
                        boolean cacheToUpdate = false;
                        if (useCache) {
                            cacheKey = repoId + groupId + artifactId + version;
                            projectVersionMetadataResolved = (ProjectVersionMetadata)this.versionMetadataCache.get((Object)cacheKey);
                        }
                        if (useCache && projectVersionMetadataResolved != null) {
                            versionMetadata = projectVersionMetadataResolved;
                        } else {
                            versionMetadata = projectVersionMetadataResolved = metadataResolver.resolveProjectVersion(repositorySession, repoId, groupId, artifactId, version);
                            cacheToUpdate = true;
                        }
                        if (!useCache || !cacheToUpdate) continue;
                        this.versionMetadataCache.put((Object)cacheKey, (Object)projectVersionMetadataResolved);
                    }
                    catch (MetadataResolutionException e) {
                        this.log.error("Skipping invalid metadata while compiling shared model for " + groupId + ":" + artifactId + " in repo " + repoId + ": " + e.getMessage());
                    }
                }
                if (versionMetadata == null) continue;
                if (isFirstVersion) {
                    sharedModel = versionMetadata;
                    sharedModel.setId(null);
                } else {
                    MavenProjectFacet versionMetadataMavenFacet = (MavenProjectFacet)versionMetadata.getFacet("org.apache.archiva.metadata.repository.storage.maven2.project");
                    if (versionMetadataMavenFacet != null && mavenFacet.getPackaging() != null && !StringUtils.equalsIgnoreCase((String)mavenFacet.getPackaging(), (String)versionMetadataMavenFacet.getPackaging())) {
                        mavenFacet.setPackaging(null);
                    }
                    if (StringUtils.isEmpty((String)sharedModel.getName()) && !StringUtils.isEmpty((String)versionMetadata.getName())) {
                        sharedModel.setName(versionMetadata.getName());
                    }
                    if (sharedModel.getDescription() != null && !StringUtils.equalsIgnoreCase((String)sharedModel.getDescription(), (String)versionMetadata.getDescription())) {
                        sharedModel.setDescription(StringUtils.isNotEmpty((String)versionMetadata.getDescription()) ? versionMetadata.getDescription() : "");
                    }
                    if (sharedModel.getIssueManagement() != null && versionMetadata.getIssueManagement() != null && !StringUtils.equalsIgnoreCase((String)sharedModel.getIssueManagement().getUrl(), (String)versionMetadata.getIssueManagement().getUrl())) {
                        sharedModel.setIssueManagement(versionMetadata.getIssueManagement());
                    }
                    if (sharedModel.getCiManagement() != null && versionMetadata.getCiManagement() != null && !StringUtils.equalsIgnoreCase((String)sharedModel.getCiManagement().getUrl(), (String)versionMetadata.getCiManagement().getUrl())) {
                        sharedModel.setCiManagement(versionMetadata.getCiManagement());
                    }
                    if (sharedModel.getOrganization() != null && versionMetadata.getOrganization() != null && !StringUtils.equalsIgnoreCase((String)sharedModel.getOrganization().getName(), (String)versionMetadata.getOrganization().getName())) {
                        sharedModel.setOrganization(versionMetadata.getOrganization());
                    }
                    if (sharedModel.getUrl() != null && !StringUtils.equalsIgnoreCase((String)sharedModel.getUrl(), (String)versionMetadata.getUrl())) {
                        sharedModel.setUrl(versionMetadata.getUrl());
                    }
                }
                isFirstVersion = false;
            }
            ProjectVersionMetadata projectVersionMetadata = sharedModel;
            return projectVersionMetadata;
        }
    }

    public List<TreeEntry> getTreeEntries(String groupId, String artifactId, String version, String repositoryId) throws ArchivaRestServiceException {
        List<String> selectedRepos = this.getSelectedRepos(repositoryId);
        try {
            return this.dependencyTreeBuilder.buildDependencyTree(selectedRepos, groupId, artifactId, version);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<ManagedRepository> getUserRepositories() throws ArchivaRestServiceException {
        try {
            return this.userRepositories.getAccessibleRepositories(this.getPrincipal());
        }
        catch (ArchivaSecurityException e) {
            throw new ArchivaRestServiceException("repositories.read.observable.error", Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Throwable)e);
        }
    }

    public List<Artifact> getDependees(String groupId, String artifactId, String version, String repositoryId) throws ArchivaRestServiceException {
        ArrayList references = new ArrayList();
        try (RepositorySession repositorySession = this.repositorySessionFactory.createSession();){
            MetadataResolver metadataResolver = repositorySession.getResolver();
            for (String repoId : this.getObservableRepos()) {
                references.addAll(metadataResolver.resolveProjectReferences(repositorySession, repoId, groupId, artifactId, version));
            }
        }
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(references.size());
        for (ProjectVersionReference projectVersionReference : references) {
            artifacts.add(new Artifact(projectVersionReference.getNamespace(), projectVersionReference.getProjectId(), projectVersionReference.getProjectVersion()));
        }
        return artifacts;
    }

    public List<Entry> getMetadatas(String groupId, String artifactId, String version, String repositoryId) throws ArchivaRestServiceException {
        ProjectVersionMetadata projectVersionMetadata = this.getProjectMetadata(groupId, artifactId, version, repositoryId);
        if (projectVersionMetadata == null) {
            return Collections.emptyList();
        }
        MetadataFacet metadataFacet = projectVersionMetadata.getFacet("org.apache.archiva.metadata.generic");
        if (metadataFacet == null) {
            return Collections.emptyList();
        }
        Map map = metadataFacet.toProperties();
        ArrayList<Entry> entries = new ArrayList<Entry>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            entries.add(new Entry((String)entry.getKey(), (String)entry.getValue()));
        }
        return entries;
    }

    public Boolean addMetadata(String groupId, String artifactId, String version, String key, String value, String repositoryId) throws ArchivaRestServiceException {
        ProjectVersionMetadata projectVersionMetadata = this.getProjectMetadata(groupId, artifactId, version, repositoryId);
        if (projectVersionMetadata == null) {
            return Boolean.FALSE;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        MetadataFacet metadataFacet = projectVersionMetadata.getFacet("org.apache.archiva.metadata.generic");
        if (metadataFacet != null && metadataFacet.toProperties() != null) {
            properties.putAll(metadataFacet.toProperties());
        } else {
            metadataFacet = new GenericMetadataFacet();
        }
        properties.put(key, value);
        metadataFacet.fromProperties(properties);
        projectVersionMetadata.addFacet(metadataFacet);
        try (RepositorySession repositorySession = this.repositorySessionFactory.createSession();){
            MetadataRepository metadataRepository = repositorySession.getRepository();
            metadataRepository.updateProjectVersion(repositoryId, groupId, artifactId, projectVersionMetadata);
            repositorySession.save();
        }
        return Boolean.TRUE;
    }

    public Boolean deleteMetadata(String groupId, String artifactId, String version, String key, String repositoryId) throws ArchivaRestServiceException {
        ProjectVersionMetadata projectVersionMetadata = this.getProjectMetadata(groupId, artifactId, version, repositoryId);
        if (projectVersionMetadata == null) {
            return Boolean.FALSE;
        }
        GenericMetadataFacet metadataFacet = (GenericMetadataFacet)projectVersionMetadata.getFacet("org.apache.archiva.metadata.generic");
        if (metadataFacet == null || metadataFacet.toProperties() == null) {
            return Boolean.TRUE;
        }
        Map properties = metadataFacet.toProperties();
        properties.remove(key);
        metadataFacet.setAdditionalProperties(properties);
        try (RepositorySession repositorySession = this.repositorySessionFactory.createSession();){
            MetadataRepository metadataRepository = repositorySession.getRepository();
            metadataRepository.updateProjectVersion(repositoryId, groupId, artifactId, projectVersionMetadata);
            repositorySession.save();
        }
        return Boolean.TRUE;
    }

    public List<ArtifactContentEntry> getArtifactContentEntries(String groupId, String artifactId, String version, String classifier, String type, String path, String repositoryId) throws ArchivaRestServiceException {
        List<String> selectedRepos = this.getSelectedRepos(repositoryId);
        try {
            for (String repoId : selectedRepos) {
                ArchivaArtifact archivaArtifact;
                ManagedRepositoryContent managedRepositoryContent = this.repositoryContentFactory.getManagedRepositoryContent(repoId);
                File file = managedRepositoryContent.toFile(archivaArtifact = new ArchivaArtifact(groupId, artifactId, version, classifier, StringUtils.isEmpty((String)type) ? "jar" : type, repoId));
                if (!file.exists()) continue;
                return this.readFileEntries(file, path, repoId);
            }
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Throwable)e);
        }
        catch (RepositoryNotFoundException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Throwable)e);
        }
        catch (RepositoryException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Throwable)e);
        }
        return Collections.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Artifact> getArtifactDownloadInfos(String groupId, String artifactId, String version, String repositoryId) throws ArchivaRestServiceException {
        List<String> selectedRepos = this.getSelectedRepos(repositoryId);
        ArrayList<Artifact> artifactDownloadInfos = new ArrayList<Artifact>();
        try (RepositorySession session = this.repositorySessionFactory.createSession();){
            String repoId;
            ArrayList<ArtifactMetadata> artifacts;
            MetadataResolver metadataResolver = session.getResolver();
            Iterator<String> i$ = selectedRepos.iterator();
            do {
                if (!i$.hasNext()) return artifactDownloadInfos;
                repoId = i$.next();
                artifacts = new ArrayList<ArtifactMetadata>(metadataResolver.resolveArtifacts(session, repoId, groupId, artifactId, version));
                Collections.sort(artifacts, ArtifactMetadataVersionComparator.INSTANCE);
            } while (artifacts == null || artifacts.isEmpty());
            List<Artifact> list = this.buildArtifacts(artifacts, repoId);
            return list;
        }
        catch (MetadataResolutionException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public ArtifactContent getArtifactContentText(String groupId, String artifactId, String version, String classifier, String type, String path, String repositoryId) throws ArchivaRestServiceException {
        List<String> selectedRepos = this.getSelectedRepos(repositoryId);
        try {
            for (String repoId : selectedRepos) {
                ArchivaArtifact archivaArtifact;
                ManagedRepositoryContent managedRepositoryContent = this.repositoryContentFactory.getManagedRepositoryContent(repoId);
                File file = managedRepositoryContent.toFile(archivaArtifact = new ArchivaArtifact(groupId, artifactId, version, classifier, StringUtils.isEmpty((String)type) ? "jar" : type, repoId));
                if (!file.exists()) {
                    this.log.debug("file: {} not exists for repository: {} try next repository", (Object)file, (Object)repoId);
                    continue;
                }
                if (StringUtils.isNotBlank((String)path)) {
                    JarFile jarFile = new JarFile(file);
                    ZipEntry zipEntry = jarFile.getEntry(path);
                    try {
                        try (InputStream inputStream = jarFile.getInputStream(zipEntry);){
                            ArtifactContent artifactContent = new ArtifactContent(IOUtils.toString((InputStream)inputStream), repoId);
                            return artifactContent;
                        }
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        this.closeQuietly(jarFile);
                    }
                }
                return new ArtifactContent(FileUtils.readFileToString((File)file), repoId);
            }
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Throwable)e);
        }
        catch (RepositoryNotFoundException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Throwable)e);
        }
        catch (RepositoryException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Throwable)e);
        }
        this.log.debug("artifact: {}:{}:{}:{}:{} not found", new Object[]{groupId, artifactId, version, classifier, type});
        return new ArtifactContent();
    }

    public Boolean artifactAvailable(String groupId, String artifactId, String version, String classifier, String repositoryId) throws ArchivaRestServiceException {
        List<String> selectedRepos = this.getSelectedRepos(repositoryId);
        boolean snapshot = VersionUtil.isSnapshot((String)version);
        try {
            for (String repoId : selectedRepos) {
                String path;
                File metadataFile;
                ArchivaArtifact archivaArtifact;
                ManagedRepository managedRepository = this.managedRepositoryAdmin.getManagedRepository(repoId);
                if (snapshot && !managedRepository.isSnapshots() || !snapshot && managedRepository.isSnapshots()) continue;
                ManagedRepositoryContent managedRepositoryContent = this.repositoryContentFactory.getManagedRepositoryContent(repoId);
                File file = managedRepositoryContent.toFile(archivaArtifact = new ArchivaArtifact(groupId, artifactId, version, StringUtils.isEmpty((String)classifier) ? "" : classifier, "jar", repoId));
                if (file != null && file.exists()) {
                    return true;
                }
                if (StringUtils.endsWith((String)version, (String)"SNAPSHOT") && (metadataFile = new File(file.getParent(), "maven-metadata.xml")).exists()) {
                    try {
                        ArchivaRepositoryMetadata archivaRepositoryMetadata = MavenMetadataReader.read((File)metadataFile);
                        int buildNumber = archivaRepositoryMetadata.getSnapshotVersion().getBuildNumber();
                        String timeStamp = archivaRepositoryMetadata.getSnapshotVersion().getTimestamp();
                        String timeStampFileName = artifactId + '-' + StringUtils.remove((String)version, (String)"-SNAPSHOT") + '-' + timeStamp + '-' + Integer.toString(buildNumber) + (StringUtils.isEmpty((String)classifier) ? "" : "-" + classifier) + ".jar";
                        File timeStampFile = new File(file.getParent(), timeStampFileName);
                        this.log.debug("try to find timestamped snapshot version file: {}", (Object)timeStampFile.getPath());
                        if (timeStampFile.exists()) {
                            return true;
                        }
                    }
                    catch (XMLException e) {
                        this.log.warn("skip fail to find timestamped snapshot file: {}", (Object)e.getMessage());
                    }
                }
                if ((file = this.connectors.fetchFromProxies(managedRepositoryContent, path = managedRepositoryContent.toPath(archivaArtifact))) == null || !file.exists()) continue;
                String pomPath = StringUtils.substringBeforeLast((String)path, (String)".jar") + ".pom";
                this.connectors.fetchFromProxies(managedRepositoryContent, pomPath);
                return true;
            }
        }
        catch (RepositoryAdminException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Throwable)e);
        }
        catch (RepositoryException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Throwable)e);
        }
        return false;
    }

    public Boolean artifactAvailable(String groupId, String artifactId, String version, String repositoryId) throws ArchivaRestServiceException {
        return this.artifactAvailable(groupId, artifactId, version, null, repositoryId);
    }

    public List<Artifact> getArtifacts(String repositoryId) throws ArchivaRestServiceException {
        try (RepositorySession repositorySession = this.repositorySessionFactory.createSession();){
            List artifactMetadatas = repositorySession.getRepository().getArtifacts(repositoryId);
            List<Artifact> list = this.buildArtifacts(artifactMetadatas, repositoryId);
            return list;
        }
    }

    public List<Artifact> getArtifactsByProjectVersionMetadata(String key, String value, String repositoryId) throws ArchivaRestServiceException {
        try (RepositorySession repositorySession = this.repositorySessionFactory.createSession();){
            List artifactMetadatas = repositorySession.getRepository().getArtifactsByProjectVersionMetadata(key, value, repositoryId);
            List<Artifact> list = this.buildArtifacts(artifactMetadatas, repositoryId);
            return list;
        }
    }

    public List<Artifact> getArtifactsByMetadata(String key, String value, String repositoryId) throws ArchivaRestServiceException {
        try (RepositorySession repositorySession = this.repositorySessionFactory.createSession();){
            List artifactMetadatas = repositorySession.getRepository().getArtifactsByMetadata(key, value, repositoryId);
            List<Artifact> list = this.buildArtifacts(artifactMetadatas, repositoryId);
            return list;
        }
    }

    public List<Artifact> getArtifactsByProperty(String key, String value, String repositoryId) throws ArchivaRestServiceException {
        try (RepositorySession repositorySession = this.repositorySessionFactory.createSession();){
            List artifactMetadatas = repositorySession.getRepository().getArtifactsByProperty(key, value, repositoryId);
            List<Artifact> list = this.buildArtifacts(artifactMetadatas, repositoryId);
            return list;
        }
    }

    public Boolean importMetadata(MetadataAddRequest metadataAddRequest, String repositoryId) throws ArchivaRestServiceException {
        boolean result = true;
        for (Map.Entry metadata : metadataAddRequest.getMetadatas().entrySet()) {
            result = this.addMetadata(metadataAddRequest.getGroupId(), metadataAddRequest.getArtifactId(), metadataAddRequest.getVersion(), (String)metadata.getKey(), (String)metadata.getValue(), repositoryId);
            if (result) continue;
            break;
        }
        return result;
    }

    public List<Artifact> searchArtifacts(String text, String repositoryId, Boolean exact) throws ArchivaRestServiceException {
        try (RepositorySession repositorySession = this.repositorySessionFactory.createSession();){
            List artifactMetadatas = repositorySession.getRepository().searchArtifacts(text, repositoryId, exact == null ? false : exact);
            List<Artifact> list = this.buildArtifacts(artifactMetadatas, repositoryId);
            return list;
        }
    }

    public List<Artifact> searchArtifacts(String key, String text, String repositoryId, Boolean exact) throws ArchivaRestServiceException {
        try (RepositorySession repositorySession = this.repositorySessionFactory.createSession();){
            List artifactMetadatas = repositorySession.getRepository().searchArtifacts(key, text, repositoryId, exact == null ? false : exact);
            List<Artifact> list = this.buildArtifacts(artifactMetadatas, repositoryId);
            return list;
        }
    }

    private void closeQuietly(JarFile jarFile) {
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (IOException e) {
                this.log.warn("ignore error closing jarFile {}", (Object)jarFile.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ArtifactContentEntry> readFileEntries(File file, String filterPath, String repoId) throws IOException {
        HashMap<String, ArtifactContentEntry> artifactContentEntryMap = new HashMap<String, ArtifactContentEntry>();
        int filterDepth = StringUtils.countMatches((String)filterPath, (String)"/");
        try (JarFile jarFile = new JarFile(file);){
            Enumeration<JarEntry> jarEntryEnumeration = jarFile.entries();
            while (jarEntryEnumeration.hasMoreElements()) {
                JarEntry currentEntry = jarEntryEnumeration.nextElement();
                String cleanedEntryName = StringUtils.endsWith((String)currentEntry.getName(), (String)"/") ? StringUtils.substringBeforeLast((String)currentEntry.getName(), (String)"/") : currentEntry.getName();
                String entryRootPath = this.getRootPath(cleanedEntryName);
                int depth = StringUtils.countMatches((String)cleanedEntryName, (String)"/");
                if (StringUtils.isEmpty((String)filterPath) && !artifactContentEntryMap.containsKey(entryRootPath) && depth == filterDepth) {
                    artifactContentEntryMap.put(entryRootPath, new ArtifactContentEntry(entryRootPath, !currentEntry.isDirectory(), depth, repoId));
                    continue;
                }
                if (!StringUtils.startsWith((String)cleanedEntryName, (String)filterPath) || depth != filterDepth && (currentEntry.isDirectory() || depth != filterDepth)) continue;
                artifactContentEntryMap.put(cleanedEntryName, new ArtifactContentEntry(cleanedEntryName, !currentEntry.isDirectory(), depth, repoId));
            }
            if (StringUtils.isNotEmpty((String)filterPath)) {
                List<ArtifactContentEntry> list;
                HashMap<String, ArtifactContentEntry> filteredArtifactContentEntryMap = new HashMap<String, ArtifactContentEntry>();
                for (Map.Entry entry : artifactContentEntryMap.entrySet()) {
                    filteredArtifactContentEntryMap.put((String)entry.getKey(), (ArtifactContentEntry)entry.getValue());
                }
                List<ArtifactContentEntry> sorted = this.getSmallerDepthEntries(filteredArtifactContentEntryMap);
                if (sorted == null) {
                    list = Collections.emptyList();
                    return list;
                }
                Collections.sort(sorted, ArtifactContentEntryComparator.INSTANCE);
                list = sorted;
                return list;
            }
        }
        ArrayList<ArtifactContentEntry> sorted = new ArrayList<ArtifactContentEntry>(artifactContentEntryMap.values());
        Collections.sort(sorted, ArtifactContentEntryComparator.INSTANCE);
        return sorted;
    }

    private List<ArtifactContentEntry> getSmallerDepthEntries(Map<String, ArtifactContentEntry> entries) {
        int smallestDepth = Integer.MAX_VALUE;
        HashMap<Integer, ArrayList<ArtifactContentEntry>> perDepthList = new HashMap<Integer, ArrayList<ArtifactContentEntry>>();
        for (Map.Entry<String, ArtifactContentEntry> entry : entries.entrySet()) {
            ArrayList<ArtifactContentEntry> currentList;
            ArtifactContentEntry current = entry.getValue();
            if (current.getDepth() < smallestDepth) {
                smallestDepth = current.getDepth();
            }
            if ((currentList = (ArrayList<ArtifactContentEntry>)perDepthList.get(current.getDepth())) == null) {
                currentList = new ArrayList<ArtifactContentEntry>();
                currentList.add(current);
                perDepthList.put(current.getDepth(), currentList);
                continue;
            }
            currentList.add(current);
        }
        return (List)perDepthList.get(smallestDepth);
    }

    private String getRootPath(String path) {
        if (StringUtils.contains((String)path, (char)'/')) {
            return StringUtils.substringBefore((String)path, (String)"/");
        }
        return path;
    }

    private List<String> getSelectedRepos(String repositoryId) throws ArchivaRestServiceException {
        List<String> selectedRepos = this.getObservableRepos();
        if (CollectionUtils.isEmpty(selectedRepos)) {
            return Collections.emptyList();
        }
        if (StringUtils.isNotEmpty((String)repositoryId)) {
            if (!selectedRepos.contains(repositoryId)) {
                throw new ArchivaRestServiceException("browse.root.groups.repositoy.denied", Response.Status.FORBIDDEN.getStatusCode(), null);
            }
            selectedRepos = Collections.singletonList(repositoryId);
        }
        return selectedRepos;
    }

    private String collapseNamespaces(RepositorySession repositorySession, MetadataResolver metadataResolver, Collection<String> repoIds, String n) throws MetadataResolutionException {
        LinkedHashSet subNamespaces = new LinkedHashSet();
        for (String repoId : repoIds) {
            subNamespaces.addAll(metadataResolver.resolveNamespaces(repositorySession, repoId, n));
        }
        if (subNamespaces.size() != 1) {
            this.log.debug("{} is not collapsible as it has sub-namespaces: {}", (Object)n, subNamespaces);
            return n;
        }
        for (String repoId : repoIds) {
            Collection projects = metadataResolver.resolveProjects(repositorySession, repoId, n);
            if (projects == null || projects.isEmpty()) continue;
            this.log.debug("{} is not collapsible as it has projects", (Object)n);
            return n;
        }
        return this.collapseNamespaces(repositorySession, metadataResolver, repoIds, n + "." + (String)subNamespaces.iterator().next());
    }

    public Cache getVersionMetadataCache() {
        return this.versionMetadataCache;
    }

    public void setVersionMetadataCache(Cache versionMetadataCache) {
        this.versionMetadataCache = versionMetadataCache;
    }
}

