/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.LdapConfiguration;
import org.apache.archiva.admin.model.beans.RedbackRuntimeConfiguration;
import org.apache.archiva.admin.model.runtime.RedbackRuntimeConfigurationAdmin;
import org.apache.archiva.redback.authentication.Authenticator;
import org.apache.archiva.redback.common.ldap.connection.LdapConnection;
import org.apache.archiva.redback.common.ldap.connection.LdapConnectionConfiguration;
import org.apache.archiva.redback.common.ldap.connection.LdapConnectionFactory;
import org.apache.archiva.redback.common.ldap.user.LdapUserMapper;
import org.apache.archiva.redback.components.cache.Cache;
import org.apache.archiva.redback.policy.CookieSettings;
import org.apache.archiva.redback.policy.PasswordRule;
import org.apache.archiva.redback.rbac.RBACManager;
import org.apache.archiva.redback.role.RoleManager;
import org.apache.archiva.redback.users.UserManager;
import org.apache.archiva.rest.api.model.RBACManagerImplementationInformation;
import org.apache.archiva.rest.api.model.RedbackImplementationsInformations;
import org.apache.archiva.rest.api.model.UserManagerImplementationInformation;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;
import org.apache.archiva.rest.api.services.RedbackRuntimeConfigurationService;
import org.apache.archiva.rest.services.AbstractRestService;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="redbackRuntimeConfigurationService#rest")
public class DefaultRedbackRuntimeConfigurationService
extends AbstractRestService
implements RedbackRuntimeConfigurationService {
    @Inject
    private RedbackRuntimeConfigurationAdmin redbackRuntimeConfigurationAdmin;
    @Inject
    @Named(value="userManager#configurable")
    private UserManager userManager;
    @Inject
    @Named(value="rbacManager#default")
    private RBACManager rbacManager;
    @Inject
    private RoleManager roleManager;
    @Inject
    private ApplicationContext applicationContext;
    @Inject
    @Named(value="ldapConnectionFactory#configurable")
    private LdapConnectionFactory ldapConnectionFactory;
    @Inject
    @Named(value="cache#users")
    private Cache usersCache;
    @Inject
    private LdapUserMapper ldapUserMapper;

    public RedbackRuntimeConfiguration getRedbackRuntimeConfiguration() throws ArchivaRestServiceException {
        try {
            return this.redbackRuntimeConfigurationAdmin.getRedbackRuntimeConfiguration();
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public Boolean updateRedbackRuntimeConfiguration(RedbackRuntimeConfiguration redbackRuntimeConfiguration) throws ArchivaRestServiceException {
        try {
            boolean userManagerChanged = redbackRuntimeConfiguration.getUserManagerImpls().size() != this.redbackRuntimeConfigurationAdmin.getRedbackRuntimeConfiguration().getUserManagerImpls().size();
            userManagerChanged = userManagerChanged || redbackRuntimeConfiguration.getUserManagerImpls().toString().hashCode() != this.redbackRuntimeConfigurationAdmin.getRedbackRuntimeConfiguration().getUserManagerImpls().toString().hashCode();
            boolean rbacManagerChanged = redbackRuntimeConfiguration.getRbacManagerImpls().size() != this.redbackRuntimeConfigurationAdmin.getRedbackRuntimeConfiguration().getRbacManagerImpls().size();
            rbacManagerChanged = rbacManagerChanged || redbackRuntimeConfiguration.getRbacManagerImpls().toString().hashCode() != this.redbackRuntimeConfigurationAdmin.getRedbackRuntimeConfiguration().getRbacManagerImpls().toString().hashCode();
            this.redbackRuntimeConfigurationAdmin.updateRedbackRuntimeConfiguration(redbackRuntimeConfiguration);
            if (userManagerChanged) {
                this.log.info("user managerImpls changed to {} so reload it", (Object)redbackRuntimeConfiguration.getUserManagerImpls());
                this.userManager.initialize();
            }
            if (rbacManagerChanged) {
                this.log.info("rbac manager changed to {}\u00a0so reload it", (Object)redbackRuntimeConfiguration.getRbacManagerImpls());
                this.rbacManager.initialize();
                this.roleManager.initialize();
            }
            this.ldapConnectionFactory.initialize();
            Collection passwordRules = this.applicationContext.getBeansOfType(PasswordRule.class).values();
            for (PasswordRule passwordRule : passwordRules) {
                passwordRule.initialize();
            }
            Collection cookieSettingsList = this.applicationContext.getBeansOfType(CookieSettings.class).values();
            for (CookieSettings cookieSettings : cookieSettingsList) {
                cookieSettings.initialize();
            }
            Collection authenticators = this.applicationContext.getBeansOfType(Authenticator.class).values();
            for (Authenticator authenticator : authenticators) {
                authenticator.initialize();
            }
            this.usersCache.setTimeToIdleSeconds(redbackRuntimeConfiguration.getUsersCacheConfiguration().getTimeToIdleSeconds());
            this.usersCache.setTimeToLiveSeconds(redbackRuntimeConfiguration.getUsersCacheConfiguration().getTimeToLiveSeconds());
            this.usersCache.setMaxElementsInMemory(redbackRuntimeConfiguration.getUsersCacheConfiguration().getMaxElementsInMemory());
            this.usersCache.setMaxElementsOnDisk(redbackRuntimeConfiguration.getUsersCacheConfiguration().getMaxElementsOnDisk());
            this.ldapUserMapper.initialize();
            return Boolean.TRUE;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public List<UserManagerImplementationInformation> getUserManagerImplementationInformations() throws ArchivaRestServiceException {
        Map beans = this.applicationContext.getBeansOfType(UserManager.class);
        if (beans.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<UserManagerImplementationInformation> informations = new ArrayList<UserManagerImplementationInformation>(beans.size());
        for (Map.Entry entry : beans.entrySet()) {
            UserManager userManager = (UserManager)this.applicationContext.getBean((String)entry.getKey(), UserManager.class);
            if (!userManager.isFinalImplementation()) continue;
            UserManagerImplementationInformation information = new UserManagerImplementationInformation();
            information.setBeanId(StringUtils.substringAfter((String)((String)entry.getKey()), (String)"#"));
            information.setDescriptionKey(userManager.getDescriptionKey());
            information.setReadOnly(userManager.isReadOnly());
            informations.add(information);
        }
        return informations;
    }

    public List<RBACManagerImplementationInformation> getRbacManagerImplementationInformations() throws ArchivaRestServiceException {
        Map beans = this.applicationContext.getBeansOfType(RBACManager.class);
        if (beans.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RBACManagerImplementationInformation> informations = new ArrayList<RBACManagerImplementationInformation>(beans.size());
        for (Map.Entry entry : beans.entrySet()) {
            RBACManager rbacManager = (RBACManager)this.applicationContext.getBean((String)entry.getKey(), RBACManager.class);
            if (!rbacManager.isFinalImplementation()) continue;
            RBACManagerImplementationInformation information = new RBACManagerImplementationInformation();
            information.setBeanId(StringUtils.substringAfter((String)((String)entry.getKey()), (String)"#"));
            information.setDescriptionKey(rbacManager.getDescriptionKey());
            information.setReadOnly(rbacManager.isReadOnly());
            informations.add(information);
        }
        return informations;
    }

    public RedbackImplementationsInformations getRedbackImplementationsInformations() throws ArchivaRestServiceException {
        return new RedbackImplementationsInformations(this.getUserManagerImplementationInformations(), this.getRbacManagerImplementationInformations());
    }

    public Boolean checkLdapConnection() throws ArchivaRestServiceException {
        try (LdapConnection ldapConnection = null;){
            ldapConnection = this.ldapConnectionFactory.getConnection();
        }
        return Boolean.TRUE;
    }

    public Boolean checkLdapConnection(LdapConfiguration ldapConfiguration) throws ArchivaRestServiceException {
        try (LdapConnection ldapConnection = null;){
            LdapConnectionConfiguration ldapConnectionConfiguration = new LdapConnectionConfiguration(ldapConfiguration.getHostName(), ldapConfiguration.getPort(), ldapConfiguration.getBaseDn(), ldapConfiguration.getContextFactory(), ldapConfiguration.getBindDn(), ldapConfiguration.getPassword(), ldapConfiguration.getAuthenticationMethod(), this.toProperties(ldapConfiguration.getExtraProperties()));
            ldapConnectionConfiguration.setSsl(ldapConfiguration.isSsl());
            ldapConnection = this.ldapConnectionFactory.getConnection(ldapConnectionConfiguration);
            ldapConnection.close();
            ldapConnectionConfiguration = new LdapConnectionConfiguration(ldapConfiguration.getHostName(), ldapConfiguration.getPort(), ldapConfiguration.getBaseGroupsDn(), ldapConfiguration.getContextFactory(), ldapConfiguration.getBindDn(), ldapConfiguration.getPassword(), ldapConfiguration.getAuthenticationMethod(), this.toProperties(ldapConfiguration.getExtraProperties()));
            ldapConnectionConfiguration.setSsl(ldapConfiguration.isSsl());
            ldapConnection = this.ldapConnectionFactory.getConnection(ldapConnectionConfiguration);
        }
        return Boolean.TRUE;
    }

    private Properties toProperties(Map<String, String> map) {
        Properties properties = new Properties();
        if (map == null || map.isEmpty()) {
            return properties;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }
}

