/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.Response;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.admin.ArchivaAdministration;
import org.apache.archiva.admin.model.beans.FileType;
import org.apache.archiva.admin.model.beans.LegacyArtifactPath;
import org.apache.archiva.admin.model.beans.NetworkConfiguration;
import org.apache.archiva.admin.model.beans.OrganisationInformation;
import org.apache.archiva.admin.model.beans.UiConfiguration;
import org.apache.archiva.model.ArtifactReference;
import org.apache.archiva.repository.ManagedRepositoryContent;
import org.apache.archiva.repository.scanner.RepositoryContentConsumers;
import org.apache.archiva.rest.api.model.AdminRepositoryConsumer;
import org.apache.archiva.rest.api.services.ArchivaAdministrationService;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;
import org.apache.archiva.rest.services.AbstractRestService;
import org.apache.archiva.rest.services.utils.AddAdminRepoConsumerClosure;
import org.apache.archiva.rest.services.utils.AdminRepositoryConsumerComparator;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="archivaAdministrationService#default")
public class DefaultArchivaAdministrationService
extends AbstractRestService
implements ArchivaAdministrationService {
    @Inject
    private ArchivaAdministration archivaAdministration;
    @Inject
    @Named(value="managedRepositoryContent#legacy")
    private ManagedRepositoryContent repositoryContent;
    @Inject
    private RepositoryContentConsumers repoConsumerUtil;

    public List<LegacyArtifactPath> getLegacyArtifactPaths() throws ArchivaRestServiceException {
        try {
            return this.archivaAdministration.getLegacyArtifactPaths();
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public void addLegacyArtifactPath(LegacyArtifactPath legacyArtifactPath) throws ArchivaRestServiceException {
        ArtifactReference artifact = new ArtifactReference();
        artifact.setGroupId(legacyArtifactPath.getGroupId());
        artifact.setArtifactId(legacyArtifactPath.getArtifactId());
        artifact.setClassifier(legacyArtifactPath.getClassifier());
        artifact.setVersion(legacyArtifactPath.getVersion());
        artifact.setType(legacyArtifactPath.getType());
        String path = this.repositoryContent.toPath(artifact);
        if (!StringUtils.equals((String)path, (String)legacyArtifactPath.getPath())) {
            throw new ArchivaRestServiceException("artifact path reference '" + legacyArtifactPath.getPath() + "' does not match the initial path: '" + path + "'", Response.Status.BAD_REQUEST.getStatusCode(), null);
        }
        try {
            this.archivaAdministration.addLegacyArtifactPath(legacyArtifactPath, this.getAuditInformation());
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public Boolean deleteLegacyArtifactPath(String path) throws ArchivaRestServiceException {
        try {
            this.archivaAdministration.deleteLegacyArtifactPath(path, this.getAuditInformation());
            return Boolean.TRUE;
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public Boolean addFileTypePattern(String fileTypeId, String pattern) throws ArchivaRestServiceException {
        try {
            this.archivaAdministration.addFileTypePattern(fileTypeId, pattern, this.getAuditInformation());
            return Boolean.TRUE;
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public Boolean removeFileTypePattern(String fileTypeId, String pattern) throws ArchivaRestServiceException {
        try {
            this.archivaAdministration.removeFileTypePattern(fileTypeId, pattern, this.getAuditInformation());
            return Boolean.TRUE;
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public FileType getFileType(String fileTypeId) throws ArchivaRestServiceException {
        try {
            return this.archivaAdministration.getFileType(fileTypeId);
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public void addFileType(FileType fileType) throws ArchivaRestServiceException {
        try {
            this.archivaAdministration.addFileType(fileType, this.getAuditInformation());
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public Boolean removeFileType(String fileTypeId) throws ArchivaRestServiceException {
        try {
            this.archivaAdministration.removeFileType(fileTypeId, this.getAuditInformation());
            return Boolean.TRUE;
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public Boolean enabledKnownContentConsumer(String knownContentConsumer) throws ArchivaRestServiceException {
        try {
            this.archivaAdministration.addKnownContentConsumer(knownContentConsumer, this.getAuditInformation());
            return Boolean.TRUE;
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public void enabledKnownContentConsumers(List<String> knownContentConsumers) throws ArchivaRestServiceException {
        try {
            this.archivaAdministration.setKnownContentConsumers(knownContentConsumers, this.getAuditInformation());
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public Boolean disabledKnownContentConsumer(String knownContentConsumer) throws ArchivaRestServiceException {
        try {
            this.archivaAdministration.removeKnownContentConsumer(knownContentConsumer, this.getAuditInformation());
            return Boolean.TRUE;
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public Boolean enabledInvalidContentConsumer(String invalidContentConsumer) throws ArchivaRestServiceException {
        try {
            this.archivaAdministration.addInvalidContentConsumer(invalidContentConsumer, this.getAuditInformation());
            return Boolean.TRUE;
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public void enabledInvalidContentConsumers(List<String> invalidContentConsumers) throws ArchivaRestServiceException {
        try {
            this.archivaAdministration.setInvalidContentConsumers(invalidContentConsumers, this.getAuditInformation());
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public Boolean disabledInvalidContentConsumer(String invalidContentConsumer) throws ArchivaRestServiceException {
        try {
            this.archivaAdministration.removeInvalidContentConsumer(invalidContentConsumer, this.getAuditInformation());
            return Boolean.TRUE;
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public List<FileType> getFileTypes() throws ArchivaRestServiceException {
        try {
            List modelfileTypes = this.archivaAdministration.getFileTypes();
            if (modelfileTypes == null || modelfileTypes.isEmpty()) {
                return Collections.emptyList();
            }
            return modelfileTypes;
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public List<String> getKnownContentConsumers() throws ArchivaRestServiceException {
        try {
            return new ArrayList<String>(this.archivaAdministration.getKnownContentConsumers());
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public List<String> getInvalidContentConsumers() throws ArchivaRestServiceException {
        try {
            return new ArrayList<String>(this.archivaAdministration.getInvalidContentConsumers());
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public OrganisationInformation getOrganisationInformation() throws ArchivaRestServiceException {
        try {
            return this.archivaAdministration.getOrganisationInformation();
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public void setOrganisationInformation(OrganisationInformation organisationInformation) throws ArchivaRestServiceException {
        try {
            this.archivaAdministration.setOrganisationInformation(organisationInformation);
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public Boolean registrationDisabled() throws ArchivaRestServiceException {
        return this.getUiConfiguration().isDisableRegistration();
    }

    public UiConfiguration getUiConfiguration() throws ArchivaRestServiceException {
        try {
            return this.archivaAdministration.getUiConfiguration();
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public void setUiConfiguration(UiConfiguration uiConfiguration) throws ArchivaRestServiceException {
        try {
            uiConfiguration.setApplicationUrl(StringUtils.stripEnd((String)uiConfiguration.getApplicationUrl(), (String)"/"));
            this.archivaAdministration.updateUiConfiguration(uiConfiguration);
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public String getApplicationUrl() throws ArchivaRestServiceException {
        try {
            return this.archivaAdministration.getUiConfiguration().getApplicationUrl();
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public NetworkConfiguration getNetworkConfiguration() throws ArchivaRestServiceException {
        try {
            return this.archivaAdministration.getNetworkConfiguration();
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public void setNetworkConfiguration(NetworkConfiguration networkConfiguration) throws ArchivaRestServiceException {
        try {
            this.archivaAdministration.setNetworkConfiguration(networkConfiguration);
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public List<AdminRepositoryConsumer> getKnownContentAdminRepositoryConsumers() throws ArchivaRestServiceException {
        try {
            AddAdminRepoConsumerClosure addAdminRepoConsumer = new AddAdminRepoConsumerClosure(this.archivaAdministration.getKnownContentConsumers());
            CollectionUtils.forAllDo((Collection)this.repoConsumerUtil.getAvailableKnownConsumers(), (Closure)addAdminRepoConsumer);
            List<AdminRepositoryConsumer> knownContentConsumers = addAdminRepoConsumer.getList();
            Collections.sort(knownContentConsumers, AdminRepositoryConsumerComparator.getInstance());
            return knownContentConsumers;
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public List<AdminRepositoryConsumer> getInvalidContentAdminRepositoryConsumers() throws ArchivaRestServiceException {
        try {
            AddAdminRepoConsumerClosure addAdminRepoConsumer = new AddAdminRepoConsumerClosure(this.archivaAdministration.getInvalidContentConsumers());
            CollectionUtils.forAllDo((Collection)this.repoConsumerUtil.getAvailableInvalidConsumers(), (Closure)addAdminRepoConsumer);
            List<AdminRepositoryConsumer> invalidContentConsumers = addAdminRepoConsumer.getList();
            Collections.sort(invalidContentConsumers, AdminRepositoryConsumerComparator.getInstance());
            return invalidContentConsumers;
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }
}

