/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.services.utils;

import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.archiva.maven2.model.Artifact;
import org.apache.archiva.metadata.model.ArtifactMetadata;
import org.apache.archiva.metadata.model.maven2.MavenArtifactFacet;
import org.apache.archiva.model.ArtifactReference;
import org.apache.archiva.repository.ManagedRepositoryContent;
import org.apache.commons.io.FilenameUtils;

public class ArtifactBuilder {
    private ManagedRepositoryContent managedRepositoryContent;
    private ArtifactMetadata artifactMetadata;

    public ArtifactBuilder withManagedRepositoryContent(ManagedRepositoryContent managedRepositoryContent) {
        this.managedRepositoryContent = managedRepositoryContent;
        return this;
    }

    public ArtifactBuilder forArtifactMetadata(ArtifactMetadata artifactMetadata) {
        this.artifactMetadata = artifactMetadata;
        return this;
    }

    public Artifact build() {
        ArtifactReference ref = new ArtifactReference();
        ref.setArtifactId(this.artifactMetadata.getProject());
        ref.setGroupId(this.artifactMetadata.getNamespace());
        ref.setVersion(this.artifactMetadata.getVersion());
        String type = null;
        String classifier = null;
        MavenArtifactFacet facet = (MavenArtifactFacet)this.artifactMetadata.getFacet("org.apache.archiva.metadata.repository.storage.maven2.artifact");
        if (facet != null) {
            type = facet.getType();
            classifier = facet.getClassifier();
        }
        ref.setClassifier(classifier);
        ref.setType(type);
        File file = this.managedRepositoryContent.toFile(ref);
        String extension = FilenameUtils.getExtension((String)file.getName());
        Artifact artifact = new Artifact(ref.getGroupId(), ref.getArtifactId(), ref.getVersion());
        artifact.setRepositoryId(this.artifactMetadata.getRepositoryId());
        artifact.setClassifier(classifier);
        artifact.setPackaging(type);
        artifact.setType(type);
        artifact.setFileExtension(extension);
        artifact.setPath(this.managedRepositoryContent.toPath(ref));
        double s = this.artifactMetadata.getSize();
        String symbol = "b";
        if (s > 1024.0) {
            symbol = "K";
            if ((s /= 1024.0) > 1024.0) {
                symbol = "M";
                if ((s /= 1024.0) > 1024.0) {
                    symbol = "G";
                    s /= 1024.0;
                }
            }
        }
        artifact.setContext(this.managedRepositoryContent.getId());
        DecimalFormat df = new DecimalFormat("#,###.##", new DecimalFormatSymbols(Locale.US));
        artifact.setSize(df.format(s) + " " + symbol);
        artifact.setId(ref.getArtifactId() + "-" + ref.getVersion() + "." + ref.getType());
        return artifact;
    }
}

