/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.services;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.RepositoryCommonValidator;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.metadata.repository.MetadataRepository;
import org.apache.archiva.metadata.repository.MetadataRepositoryException;
import org.apache.archiva.metadata.repository.RepositorySession;
import org.apache.archiva.metadata.repository.stats.RepositoryStatistics;
import org.apache.archiva.metadata.repository.stats.RepositoryStatisticsManager;
import org.apache.archiva.rest.api.model.ArchivaRepositoryStatistics;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;
import org.apache.archiva.rest.api.services.ManagedRepositoriesService;
import org.apache.archiva.rest.services.AbstractRestService;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="managedRepositoriesService#rest")
public class DefaultManagedRepositoriesService
extends AbstractRestService
implements ManagedRepositoriesService {
    @Inject
    private RepositoryCommonValidator repositoryCommonValidator;
    @Inject
    private RepositoryStatisticsManager repositoryStatisticsManager;

    public List<ManagedRepository> getManagedRepositories() throws ArchivaRestServiceException {
        try {
            List repos = this.managedRepositoryAdmin.getManagedRepositories();
            return repos == null ? Collections.emptyList() : repos;
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public ManagedRepository getManagedRepository(String repositoryId) throws ArchivaRestServiceException {
        List<ManagedRepository> repos = this.getManagedRepositories();
        for (ManagedRepository repo : repos) {
            if (!StringUtils.equals((String)repo.getId(), (String)repositoryId)) continue;
            return repo;
        }
        return null;
    }

    public Boolean deleteManagedRepository(String repoId, boolean deleteContent) throws ArchivaRestServiceException {
        try {
            return this.managedRepositoryAdmin.deleteManagedRepository(repoId, this.getAuditInformation(), deleteContent);
        }
        catch (RepositoryAdminException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), e.getFieldName(), (Throwable)e);
        }
    }

    public ManagedRepository addManagedRepository(ManagedRepository managedRepository) throws ArchivaRestServiceException {
        try {
            boolean res = this.managedRepositoryAdmin.addManagedRepository(managedRepository, managedRepository.isStageRepoNeeded(), this.getAuditInformation());
            if (res) {
                return this.getManagedRepository(managedRepository.getId());
            }
            throw new ArchivaRestServiceException("fail to created managed Repository", null);
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), e.getFieldName(), (Throwable)e);
        }
    }

    public Boolean updateManagedRepository(ManagedRepository managedRepository) throws ArchivaRestServiceException {
        try {
            return this.managedRepositoryAdmin.updateManagedRepository(managedRepository, managedRepository.isStageRepoNeeded(), this.getAuditInformation(), managedRepository.isResetStats());
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), e.getFieldName(), (Throwable)e);
        }
    }

    public Boolean fileLocationExists(String fileLocation) throws ArchivaRestServiceException {
        String location = this.repositoryCommonValidator.removeExpressions(fileLocation);
        return new File(location).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchivaRepositoryStatistics getManagedRepositoryStatistics(String repositoryId, String lang) throws ArchivaRestServiceException {
        RepositorySession repositorySession = this.repositorySessionFactory.createSession();
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", new Locale(lang));
        try {
            MetadataRepository metadataRepository = repositorySession.getRepository();
            RepositoryStatistics stats = null;
            try {
                stats = this.repositoryStatisticsManager.getLastStatistics(metadataRepository, repositoryId);
            }
            catch (MetadataRepositoryException e) {
                this.log.warn("Error retrieving repository statistics: {}", (Object)e.getMessage(), (Object)e);
            }
            if (stats != null) {
                ArchivaRepositoryStatistics archivaRepositoryStatistics = (ArchivaRepositoryStatistics)this.getModelMapper().map((Object)stats, ArchivaRepositoryStatistics.class);
                archivaRepositoryStatistics.setDuration(archivaRepositoryStatistics.getScanEndTime().getTime() - archivaRepositoryStatistics.getScanStartTime().getTime());
                archivaRepositoryStatistics.setLastScanDate(sdf.format(archivaRepositoryStatistics.getScanEndTime()));
                ArchivaRepositoryStatistics archivaRepositoryStatistics2 = archivaRepositoryStatistics;
                return archivaRepositoryStatistics2;
            }
        }
        finally {
            if (repositorySession != null) {
                repositorySession.close();
            }
        }
        return null;
    }

    public String getPomSnippet(String repositoryId) throws ArchivaRestServiceException {
        return this.createSnippet(this.getManagedRepository(repositoryId));
    }

    private String createSnippet(ManagedRepository repo) throws ArchivaRestServiceException {
        try {
            StringBuilder snippet = new StringBuilder();
            snippet.append("<project>\n");
            snippet.append("  ...\n");
            snippet.append("  <distributionManagement>\n");
            String distRepoName = "repository";
            if (repo.isSnapshots()) {
                distRepoName = "snapshotRepository";
            }
            snippet.append("    <").append(distRepoName).append(">\n");
            snippet.append("      <id>").append(repo.getId()).append("</id>\n");
            snippet.append("      <url>");
            snippet.append(this.getBaseUrl() + "/repository");
            snippet.append("/").append(repo.getId()).append("/").append("</url>\n");
            if (!"default".equals(repo.getLayout())) {
                snippet.append("      <layout>").append(repo.getLayout()).append("</layout>");
            }
            snippet.append("    </").append(distRepoName).append(">\n");
            snippet.append("  </distributionManagement>\n");
            snippet.append("\n");
            snippet.append("  <repositories>\n");
            snippet.append("    <repository>\n");
            snippet.append("      <id>").append(repo.getId()).append("</id>\n");
            snippet.append("      <name>").append(repo.getName()).append("</name>\n");
            snippet.append("      <url>");
            snippet.append(this.getBaseUrl() + "/repository");
            snippet.append("/").append(repo.getId()).append("/");
            snippet.append("</url>\n");
            if (!"default".equals(repo.getLayout())) {
                snippet.append("      <layout>").append(repo.getLayout()).append("</layout>\n");
            }
            snippet.append("      <releases>\n");
            snippet.append("        <enabled>").append((Object)repo.isReleases()).append("</enabled>\n");
            snippet.append("      </releases>\n");
            snippet.append("      <snapshots>\n");
            snippet.append("        <enabled>").append((Object)repo.isSnapshots()).append("</enabled>\n");
            snippet.append("      </snapshots>\n");
            snippet.append("    </repository>\n");
            snippet.append("  </repositories>\n");
            snippet.append("  <pluginRepositories>\n");
            snippet.append("    <pluginRepository>\n");
            snippet.append("      <id>").append(repo.getId()).append("</id>\n");
            snippet.append("      <name>").append(repo.getName()).append("</name>\n");
            snippet.append("      <url>");
            snippet.append(this.getBaseUrl() + "/repository");
            snippet.append("/").append(repo.getId()).append("/");
            snippet.append("</url>\n");
            if (!"default".equals(repo.getLayout())) {
                snippet.append("      <layout>").append(repo.getLayout()).append("</layout>\n");
            }
            snippet.append("      <releases>\n");
            snippet.append("        <enabled>").append((Object)repo.isReleases()).append("</enabled>\n");
            snippet.append("      </releases>\n");
            snippet.append("      <snapshots>\n");
            snippet.append("        <enabled>").append((Object)repo.isSnapshots()).append("</enabled>\n");
            snippet.append("      </snapshots>\n");
            snippet.append("    </pluginRepository>\n");
            snippet.append("  </pluginRepositories>\n");
            snippet.append("  ...\n");
            snippet.append("</project>\n");
            return StringEscapeUtils.escapeXml((String)snippet.toString());
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Throwable)e);
        }
    }
}

