/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.services;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.apache.archiva.redback.components.scheduler.CronExpressionValidator;
import org.apache.archiva.redback.rest.api.services.RedbackServiceException;
import org.apache.archiva.redback.rest.api.services.UtilServices;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;
import org.apache.archiva.rest.api.services.CommonServices;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="commonServices#rest")
public class DefaultCommonServices
implements CommonServices {
    private static final String RESOURCE_NAME = "org/apache/archiva/i18n/default";
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    private UtilServices utilServices;
    private Map<String, String> cachei18n = new ConcurrentHashMap<String, String>();
    @Inject
    protected CronExpressionValidator cronExpressionValidator;

    @PostConstruct
    public void init() throws ArchivaRestServiceException {
        this.getAllI18nResources("en");
        this.getAllI18nResources("fr");
    }

    public String getI18nResources(String locale) throws ArchivaRestServiceException {
        Properties properties = new Properties();
        StringBuilder resourceName = new StringBuilder(RESOURCE_NAME);
        try {
            this.loadResource(properties, resourceName, locale);
        }
        catch (IOException e) {
            this.log.warn("skip error loading properties {}", (Object)resourceName.toString());
        }
        return this.fromProperties(properties);
    }

    private void loadResource(Properties properties, StringBuilder resourceName, String locale) throws IOException {
        this.loadResource(properties, new StringBuilder(resourceName).append(".properties").toString(), locale);
        if (StringUtils.isNotEmpty((String)locale)) {
            this.loadResource(properties, new StringBuilder(resourceName).append("_" + locale).append(".properties").toString(), locale);
        }
    }

    private String fromProperties(Properties properties) {
        StringBuilder output = new StringBuilder();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            output.append((String)entry.getKey()).append('=').append((String)entry.getValue());
            output.append('\n');
        }
        return output.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadResource(Properties finalProperties, String resourceName, String locale) throws IOException {
        InputStream is = null;
        Properties properties = new Properties();
        try {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
            if (is != null) {
                properties.load(is);
                finalProperties.putAll((Map<?, ?>)properties);
            } else if (!StringUtils.equalsIgnoreCase((String)locale, (String)"en")) {
                this.log.info("cannot load resource {}", (Object)resourceName);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    public String getAllI18nResources(String locale) throws ArchivaRestServiceException {
        String cachedi18n = this.cachei18n.get(StringUtils.isEmpty((String)locale) ? "en" : StringUtils.lowerCase((String)locale));
        if (cachedi18n != null) {
            return cachedi18n;
        }
        try {
            Properties all = this.utilServices.getI18nProperties(locale);
            StringBuilder resourceName = new StringBuilder(RESOURCE_NAME);
            this.loadResource(all, resourceName, locale);
            String i18n = this.fromProperties(all);
            this.cachei18n.put(StringUtils.isEmpty((String)locale) ? "en" : StringUtils.lowerCase((String)locale), i18n);
            return i18n;
        }
        catch (IOException e) {
            throw new ArchivaRestServiceException(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Throwable)e);
        }
        catch (RedbackServiceException e) {
            throw new ArchivaRestServiceException(e.getMessage(), e.getHttpErrorCode(), (Throwable)e);
        }
    }

    private void loadFromString(String propsStr, Properties properties) throws ArchivaRestServiceException {
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(propsStr.getBytes());
            properties.load(inputStream);
        }
        catch (IOException e) {
            try {
                throw new ArchivaRestServiceException(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    public Boolean validateCronExpression(String cronExpression) throws ArchivaRestServiceException {
        return this.cronExpressionValidator.validate(cronExpression);
    }
}

