/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.services;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.ArchivaRuntimeConfiguration;
import org.apache.archiva.admin.model.beans.CacheConfiguration;
import org.apache.archiva.admin.model.beans.FileLockConfiguration;
import org.apache.archiva.admin.model.runtime.ArchivaRuntimeConfigurationAdmin;
import org.apache.archiva.common.filelock.FileLockManager;
import org.apache.archiva.redback.components.cache.Cache;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;
import org.apache.archiva.rest.api.services.ArchivaRuntimeConfigurationService;
import org.apache.archiva.rest.services.AbstractRestService;
import org.springframework.stereotype.Service;

@Service(value="archivaRuntimeConfigurationService#rest")
public class DefaultArchivaRuntimeConfigurationService
extends AbstractRestService
implements ArchivaRuntimeConfigurationService {
    @Inject
    private ArchivaRuntimeConfigurationAdmin archivaRuntimeConfigurationAdmin;
    @Inject
    @Named(value="cache#url-failures-cache")
    private Cache usersCache;
    @Inject
    @Named(value="fileLockManager#default")
    private FileLockManager fileLockManager;

    public ArchivaRuntimeConfiguration getArchivaRuntimeConfiguration() throws ArchivaRestServiceException {
        try {
            return this.archivaRuntimeConfigurationAdmin.getArchivaRuntimeConfiguration();
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public Boolean updateArchivaRuntimeConfiguration(ArchivaRuntimeConfiguration archivaRuntimeConfiguration) throws ArchivaRestServiceException {
        try {
            FileLockConfiguration fileLockConfiguration;
            this.archivaRuntimeConfigurationAdmin.updateArchivaRuntimeConfiguration(archivaRuntimeConfiguration);
            CacheConfiguration cacheConfiguration = archivaRuntimeConfiguration.getUrlFailureCacheConfiguration();
            if (cacheConfiguration != null) {
                this.usersCache.setTimeToLiveSeconds(cacheConfiguration.getTimeToLiveSeconds());
                this.usersCache.setTimeToIdleSeconds(cacheConfiguration.getTimeToIdleSeconds());
                this.usersCache.setMaxElementsOnDisk(cacheConfiguration.getMaxElementsOnDisk());
                this.usersCache.setMaxElementsInMemory(cacheConfiguration.getMaxElementsInMemory());
            }
            if ((fileLockConfiguration = archivaRuntimeConfiguration.getFileLockConfiguration()) != null) {
                this.fileLockManager.setTimeout(fileLockConfiguration.getLockingTimeout());
                fileLockConfiguration.setSkipLocking(fileLockConfiguration.isSkipLocking());
            }
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
        return Boolean.TRUE;
    }
}

