/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import net.sf.beanlib.provider.replicator.BeanReplicator;
import org.apache.archiva.indexer.search.RepositorySearch;
import org.apache.archiva.indexer.search.RepositorySearchException;
import org.apache.archiva.indexer.search.SearchFields;
import org.apache.archiva.indexer.search.SearchResultHit;
import org.apache.archiva.indexer.search.SearchResultLimits;
import org.apache.archiva.indexer.search.SearchResults;
import org.apache.archiva.maven2.model.Artifact;
import org.apache.archiva.rest.api.model.Dependency;
import org.apache.archiva.rest.api.model.GroupIdList;
import org.apache.archiva.rest.api.model.SearchRequest;
import org.apache.archiva.rest.api.model.StringList;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;
import org.apache.archiva.rest.api.services.SearchService;
import org.apache.archiva.rest.services.AbstractRestService;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="searchService#rest")
public class DefaultSearchService
extends AbstractRestService
implements SearchService {
    @Inject
    private RepositorySearch repositorySearch;

    public List<Artifact> quickSearch(String queryString) throws ArchivaRestServiceException {
        if (StringUtils.isBlank((String)queryString)) {
            return Collections.emptyList();
        }
        SearchResultLimits limits = new SearchResultLimits(0);
        try {
            SearchResults searchResults = this.repositorySearch.search(this.getPrincipal(), this.getObservableRepos(), queryString, limits, Collections.emptyList());
            return this.getArtifacts(searchResults);
        }
        catch (RepositorySearchException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public List<Artifact> quickSearchWithRepositories(SearchRequest searchRequest) throws ArchivaRestServiceException {
        String queryString = searchRequest.getQueryTerms();
        if (StringUtils.isBlank((String)queryString)) {
            return Collections.emptyList();
        }
        List<String> repositories = searchRequest.getRepositories();
        if (repositories == null || repositories.isEmpty()) {
            repositories = this.getObservableRepos();
        }
        SearchResultLimits limits = new SearchResultLimits(0);
        try {
            SearchResults searchResults = this.repositorySearch.search(this.getPrincipal(), repositories, queryString, limits, Collections.emptyList());
            return this.getArtifacts(searchResults);
        }
        catch (RepositorySearchException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public List<Artifact> getArtifactVersions(String groupId, String artifactId, String packaging) throws ArchivaRestServiceException {
        if (StringUtils.isBlank((String)groupId) || StringUtils.isBlank((String)artifactId)) {
            return Collections.emptyList();
        }
        SearchFields searchField = new SearchFields();
        searchField.setGroupId(groupId);
        searchField.setArtifactId(artifactId);
        searchField.setPackaging(StringUtils.isBlank((String)packaging) ? "jar" : packaging);
        searchField.setRepositories(this.getObservableRepos());
        try {
            SearchResults searchResults = this.repositorySearch.search(this.getPrincipal(), searchField, null);
            return this.getArtifacts(searchResults);
        }
        catch (RepositorySearchException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public List<Artifact> searchArtifacts(SearchRequest searchRequest) throws ArchivaRestServiceException {
        if (searchRequest == null) {
            return Collections.emptyList();
        }
        SearchFields searchField = (SearchFields)new BeanReplicator().replicateBean((Object)searchRequest, SearchFields.class);
        SearchResultLimits limits = new SearchResultLimits(0);
        if (searchField.getRepositories() == null || searchField.getRepositories().isEmpty()) {
            searchField.setRepositories(this.getObservableRepos());
        }
        try {
            SearchResults searchResults = this.repositorySearch.search(this.getPrincipal(), searchField, limits);
            return this.getArtifacts(searchResults);
        }
        catch (RepositorySearchException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public GroupIdList getAllGroupIds(List<String> selectedRepos) throws ArchivaRestServiceException {
        List<String> observableRepos = this.getObservableRepos();
        List repos = ListUtils.intersection(observableRepos, selectedRepos);
        if (repos == null || repos.isEmpty()) {
            return new GroupIdList(Collections.emptyList());
        }
        try {
            return new GroupIdList(new ArrayList(this.repositorySearch.getAllGroupIds(this.getPrincipal(), repos)));
        }
        catch (RepositorySearchException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public List<Dependency> getDependencies(String groupId, String artifactId, String version) throws ArchivaRestServiceException {
        return null;
    }

    public List<Artifact> getArtifactByChecksum(String checksum) throws ArchivaRestServiceException {
        return null;
    }

    public StringList getObservablesRepoIds() throws ArchivaRestServiceException {
        return new StringList(this.getObservableRepos());
    }

    protected List<Artifact> getArtifacts(SearchResults searchResults) throws ArchivaRestServiceException {
        if (searchResults == null || searchResults.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(searchResults.getReturnedHitsCount());
        for (SearchResultHit hit : searchResults.getHits()) {
            if (hit.getVersions().size() <= 0) continue;
            for (String version : hit.getVersions()) {
                Artifact versionned = (Artifact)new BeanReplicator().replicateBean((Object)hit, Artifact.class);
                if (!StringUtils.isNotBlank((String)version)) continue;
                versionned.setVersion(version);
                versionned.setUrl(this.getArtifactUrl(versionned));
                artifacts.add(versionned);
            }
        }
        return artifacts;
    }
}

