/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.apache.archiva.metadata.repository.MetadataRepository;
import org.apache.archiva.metadata.repository.MetadataRepositoryException;
import org.apache.archiva.metadata.repository.RepositorySession;
import org.apache.archiva.metadata.repository.stats.RepositoryStatistics;
import org.apache.archiva.metadata.repository.stats.RepositoryStatisticsManager;
import org.apache.archiva.reports.RepositoryProblemFacet;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;
import org.apache.archiva.rest.api.services.ReportRepositoriesService;
import org.apache.archiva.rest.services.AbstractRestService;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="reportRepositoriesService#rest")
public class DefaultReportRepositoriesService
extends AbstractRestService
implements ReportRepositoriesService {
    private static final String ALL_REPOSITORIES = "all";
    @Inject
    private RepositoryStatisticsManager repositoryStatisticsManager;

    public List<RepositoryStatistics> getStatisticsReport(List<String> repositoriesId, int rowCount, Date startDate, Date endDate) throws ArchivaRestServiceException {
        switch (repositoriesId.size()) {
            case 0: {
                throw new ArchivaRestServiceException("report.statistics.report.missing-repositories", null);
            }
            case 1: {
                return this.getUniqueRepositoryReport(repositoriesId.get(0), rowCount, startDate, endDate);
            }
        }
        return this.getMultipleRepositoriesReport(repositoriesId, rowCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RepositoryStatistics> getMultipleRepositoriesReport(List<String> repositoriesId, int rowCount) {
        RepositorySession repositorySession = this.repositorySessionFactory.createSession();
        try {
            MetadataRepository metadataRepository = repositorySession.getRepository();
            ArrayList<RepositoryStatistics> stats = new ArrayList<RepositoryStatistics>();
            for (String repo : repositoriesId) {
                try {
                    stats.add(this.repositoryStatisticsManager.getLastStatistics(metadataRepository, repo));
                }
                catch (MetadataRepositoryException e) {
                    this.log.warn("Unable to retrieve stats, assuming is empty: " + e.getMessage(), (Throwable)e);
                }
            }
            List<RepositoryStatistics> list = stats.subList(0, stats.size() > rowCount ? rowCount : stats.size());
            return list;
        }
        finally {
            repositorySession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RepositoryStatistics> getUniqueRepositoryReport(String repositoryId, int rowCount, Date startDate, Date endDate) {
        RepositorySession repositorySession = this.repositorySessionFactory.createSession();
        try {
            MetadataRepository metadataRepository = repositorySession.getRepository();
            List stats = null;
            try {
                stats = this.repositoryStatisticsManager.getStatisticsInRange(metadataRepository, repositoryId, startDate, endDate);
            }
            catch (MetadataRepositoryException e) {
                this.log.warn("Unable to retrieve stats, assuming is empty: " + e.getMessage(), (Throwable)e);
            }
            if (stats == null || stats.isEmpty()) {
                List<RepositoryStatistics> list = Collections.emptyList();
                return list;
            }
            List<RepositoryStatistics> list = stats.subList(0, stats.size() > rowCount ? rowCount : stats.size());
            return list;
        }
        finally {
            repositorySession.close();
        }
    }

    public List<RepositoryProblemFacet> getHealthReport(String repository, String groupId, int rowCount) throws ArchivaRestServiceException {
        RepositorySession repositorySession = this.repositorySessionFactory.createSession();
        try {
            List<String> observableRepositories = this.getObservableRepos();
            if (!ALL_REPOSITORIES.equals(repository) && !observableRepositories.contains(repository)) {
                throw new ArchivaRestServiceException("${$.i18n.prop('report.repository.illegal-access', " + repository + ")}", "repositoryId", (Throwable)new IllegalAccessException());
            }
            if (!ALL_REPOSITORIES.equals(repository)) {
                observableRepositories = Collections.singletonList(repository);
            }
            ArrayList<RepositoryProblemFacet> problemArtifacts = new ArrayList<RepositoryProblemFacet>();
            MetadataRepository metadataRepository = repositorySession.getRepository();
            for (String repoId : observableRepositories) {
                for (String name : metadataRepository.getMetadataFacets(repoId, "org.apache.archiva.reports")) {
                    RepositoryProblemFacet metadataFacet = (RepositoryProblemFacet)metadataRepository.getMetadataFacet(repoId, "org.apache.archiva.reports", name);
                    if (!StringUtils.isEmpty((String)groupId) && !groupId.equals(metadataFacet.getNamespace())) continue;
                    problemArtifacts.add(metadataFacet);
                }
            }
            ArrayList<RepositoryProblemFacet> arrayList = problemArtifacts;
            return arrayList;
        }
        catch (MetadataRepositoryException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
        finally {
            repositorySession.close();
        }
    }
}

