/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import net.sf.beanlib.provider.replicator.BeanReplicator;
import org.apache.archiva.indexer.search.RepositorySearch;
import org.apache.archiva.indexer.search.RepositorySearchException;
import org.apache.archiva.indexer.search.SearchFields;
import org.apache.archiva.indexer.search.SearchResultHit;
import org.apache.archiva.indexer.search.SearchResultLimits;
import org.apache.archiva.indexer.search.SearchResults;
import org.apache.archiva.rest.api.model.Artifact;
import org.apache.archiva.rest.api.model.Dependency;
import org.apache.archiva.rest.api.model.GroupIdList;
import org.apache.archiva.rest.api.model.SearchRequest;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;
import org.apache.archiva.rest.api.services.SearchService;
import org.apache.archiva.security.AccessDeniedException;
import org.apache.archiva.security.ArchivaSecurityException;
import org.apache.archiva.security.PrincipalNotFoundException;
import org.apache.archiva.security.UserRepositories;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.redback.rest.services.RedbackAuthenticationThreadLocal;
import org.codehaus.redback.rest.services.RedbackRequestInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="searchService#rest")
public class DefaultSearchService
implements SearchService {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    private RepositorySearch repositorySearch;
    @Inject
    private UserRepositories userRepositories;
    @Context
    private HttpServletRequest httpServletRequest;

    public List<Artifact> quickSearch(String queryString) throws ArchivaRestServiceException {
        if (StringUtils.isBlank((String)queryString)) {
            return Collections.emptyList();
        }
        SearchResultLimits limits = new SearchResultLimits(0);
        List<String> observableRepoIds = this.getObservableRepos();
        try {
            SearchResults searchResults = this.repositorySearch.search(this.getPrincipal(), this.getObservableRepos(), queryString, limits, Collections.emptyList());
            return this.getArtifacts(searchResults);
        }
        catch (RepositorySearchException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage());
        }
    }

    public List<Artifact> getArtifactVersions(String groupId, String artifactId, String packaging) throws ArchivaRestServiceException {
        if (StringUtils.isBlank((String)groupId) || StringUtils.isBlank((String)artifactId)) {
            return Collections.emptyList();
        }
        SearchFields searchField = new SearchFields();
        searchField.setGroupId(groupId);
        searchField.setArtifactId(artifactId);
        searchField.setPackaging(StringUtils.isBlank((String)packaging) ? "jar" : packaging);
        searchField.setRepositories(this.getObservableRepos());
        try {
            SearchResults searchResults = this.repositorySearch.search(this.getPrincipal(), searchField, null);
            return this.getArtifacts(searchResults);
        }
        catch (RepositorySearchException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage());
        }
    }

    public List<Artifact> searchArtifacts(SearchRequest searchRequest) throws ArchivaRestServiceException {
        if (searchRequest == null) {
            return Collections.emptyList();
        }
        SearchFields searchField = (SearchFields)new BeanReplicator().replicateBean((Object)searchRequest, SearchFields.class);
        SearchResultLimits limits = new SearchResultLimits(0);
        if (searchField.getRepositories() == null || searchField.getRepositories().isEmpty()) {
            searchField.setRepositories(this.getObservableRepos());
        }
        try {
            SearchResults searchResults = this.repositorySearch.search(this.getPrincipal(), searchField, limits);
            return this.getArtifacts(searchResults);
        }
        catch (RepositorySearchException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage());
        }
    }

    public GroupIdList getAllGroupIds(List<String> selectedRepos) throws ArchivaRestServiceException {
        List<String> observableRepos = this.getObservableRepos();
        List repos = ListUtils.intersection(observableRepos, selectedRepos);
        if (repos == null || repos.isEmpty()) {
            return new GroupIdList(Collections.emptyList());
        }
        try {
            return new GroupIdList(new ArrayList(this.repositorySearch.getAllGroupIds(this.getPrincipal(), repos)));
        }
        catch (RepositorySearchException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage());
        }
    }

    public List<Dependency> getDependencies(String groupId, String artifactId, String version) throws ArchivaRestServiceException {
        return null;
    }

    public List<Artifact> getArtifactByChecksum(String checksum) throws ArchivaRestServiceException {
        return null;
    }

    protected List<String> getObservableRepos() {
        try {
            List ids = this.userRepositories.getObservableRepositoryIds(this.getPrincipal());
            return ids == null ? Collections.emptyList() : ids;
        }
        catch (PrincipalNotFoundException e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        catch (AccessDeniedException e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        catch (ArchivaSecurityException e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        return Collections.emptyList();
    }

    protected String getPrincipal() {
        RedbackRequestInformation redbackRequestInformation = RedbackAuthenticationThreadLocal.get();
        return redbackRequestInformation == null ? "guest" : (redbackRequestInformation.getUser() == null ? "guest" : redbackRequestInformation.getUser().getUsername());
    }

    protected List<Artifact> getArtifacts(SearchResults searchResults) {
        if (searchResults == null || searchResults.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(searchResults.getReturnedHitsCount());
        for (SearchResultHit hit : searchResults.getHits()) {
            if (hit.getVersions().size() <= 0) continue;
            for (String version : hit.getVersions()) {
                Artifact versionned = (Artifact)new BeanReplicator().replicateBean((Object)hit, Artifact.class);
                if (!StringUtils.isNotBlank((String)version)) continue;
                versionned.setVersion(version);
                versionned.setUrl(this.getArtifactUrl(versionned));
                artifacts.add(versionned);
            }
        }
        return artifacts;
    }

    private String getArtifactUrl(Artifact artifact) {
        if (this.httpServletRequest == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)artifact.getUrl())) {
            return null;
        }
        StringBuilder sb = new StringBuilder(this.getBaseUrl(this.httpServletRequest));
        sb.append("/repository");
        if (!StringUtils.startsWith((String)artifact.getUrl(), (String)"/")) {
            sb.append('/');
        }
        sb.append(artifact.getUrl());
        return sb.toString();
    }

    protected String getBaseUrl(HttpServletRequest req) {
        return req.getScheme() + "://" + req.getServerName() + (req.getServerPort() == 80 ? "" : ":" + req.getServerPort()) + req.getContextPath();
    }
}

