/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.services;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.ProxyConnector;
import org.apache.archiva.admin.model.proxyconnector.ProxyConnectorAdmin;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;
import org.apache.archiva.rest.api.services.ProxyConnectorService;
import org.apache.archiva.rest.services.AbstractRestService;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="proxyConnectorService#rest")
public class DefaultProxyConnectorService
extends AbstractRestService
implements ProxyConnectorService {
    @Inject
    private ProxyConnectorAdmin proxyConnectorAdmin;

    public List<ProxyConnector> getProxyConnectors() throws ArchivaRestServiceException {
        try {
            List proxyConnectors = this.proxyConnectorAdmin.getProxyConnectors();
            return proxyConnectors == null ? Collections.emptyList() : proxyConnectors;
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage());
        }
    }

    public ProxyConnector getProxyConnector(String sourceRepoId, String targetRepoId) throws ArchivaRestServiceException {
        try {
            return this.proxyConnectorAdmin.getProxyConnector(sourceRepoId, targetRepoId);
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage());
        }
    }

    public Boolean addProxyConnector(ProxyConnector proxyConnector) throws ArchivaRestServiceException {
        if (proxyConnector == null) {
            return Boolean.FALSE;
        }
        try {
            return this.proxyConnectorAdmin.addProxyConnector(proxyConnector, this.getAuditInformation());
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage());
        }
    }

    public Boolean deleteProxyConnector(ProxyConnector proxyConnector) throws ArchivaRestServiceException {
        if (proxyConnector == null) {
            return Boolean.FALSE;
        }
        try {
            return this.proxyConnectorAdmin.deleteProxyConnector(proxyConnector, this.getAuditInformation());
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage());
        }
    }

    public Boolean updateProxyConnector(ProxyConnector proxyConnector) throws ArchivaRestServiceException {
        if (proxyConnector == null) {
            return Boolean.FALSE;
        }
        try {
            return this.proxyConnectorAdmin.updateProxyConnector(proxyConnector, this.getAuditInformation());
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage());
        }
    }

    public ProxyConnectorAdmin getProxyConnectorAdmin() {
        return this.proxyConnectorAdmin;
    }

    public void setProxyConnectorAdmin(ProxyConnectorAdmin proxyConnectorAdmin) {
        this.proxyConnectorAdmin = proxyConnectorAdmin;
    }
}

