/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.services;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.admin.model.managed.ManagedRepositoryAdmin;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridge;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;
import org.apache.archiva.rest.api.services.ManagedRepositoriesService;
import org.apache.archiva.rest.services.AbstractRestService;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="managedRepositoriesService#rest")
public class DefaultManagedRepositoriesService
extends AbstractRestService
implements ManagedRepositoriesService {
    @Inject
    private ManagedRepositoryAdmin managedRepositoryAdmin;
    @Inject
    private PlexusSisuBridge plexusSisuBridge;

    public List<ManagedRepository> getManagedRepositories() throws ArchivaRestServiceException {
        try {
            List repos = this.managedRepositoryAdmin.getManagedRepositories();
            return repos == null ? Collections.emptyList() : repos;
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage());
        }
    }

    public ManagedRepository getManagedRepository(String repositoryId) throws ArchivaRestServiceException {
        List<ManagedRepository> repos = this.getManagedRepositories();
        for (ManagedRepository repo : repos) {
            if (!StringUtils.equals((String)repo.getId(), (String)repositoryId)) continue;
            return repo;
        }
        return null;
    }

    public Boolean deleteManagedRepository(String repoId, boolean deleteContent) throws ArchivaRestServiceException {
        try {
            return this.managedRepositoryAdmin.deleteManagedRepository(repoId, this.getAuditInformation(), deleteContent);
        }
        catch (RepositoryAdminException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage());
        }
    }

    public Boolean addManagedRepository(ManagedRepository managedRepository) throws ArchivaRestServiceException {
        try {
            return this.managedRepositoryAdmin.addManagedRepository(managedRepository, managedRepository.isStageRepoNeeded(), this.getAuditInformation());
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage());
        }
    }

    public Boolean updateManagedRepository(ManagedRepository managedRepository) throws ArchivaRestServiceException {
        try {
            return this.managedRepositoryAdmin.updateManagedRepository(managedRepository, managedRepository.isStageRepoNeeded(), this.getAuditInformation(), managedRepository.isResetStats());
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage());
        }
    }
}

