/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.services;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.admin.ArchivaAdministration;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.admin.model.managed.ManagedRepositoryAdmin;
import org.apache.archiva.checksum.ChecksumAlgorithm;
import org.apache.archiva.checksum.ChecksummedFile;
import org.apache.archiva.common.plexusbridge.MavenIndexerUtils;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridge;
import org.apache.archiva.common.utils.VersionComparator;
import org.apache.archiva.common.utils.VersionUtil;
import org.apache.archiva.model.ArchivaRepositoryMetadata;
import org.apache.archiva.model.ArtifactReference;
import org.apache.archiva.repository.ManagedRepositoryContent;
import org.apache.archiva.repository.RepositoryContentFactory;
import org.apache.archiva.repository.RepositoryException;
import org.apache.archiva.repository.metadata.RepositoryMetadataException;
import org.apache.archiva.repository.metadata.RepositoryMetadataReader;
import org.apache.archiva.repository.metadata.RepositoryMetadataWriter;
import org.apache.archiva.rest.api.model.ArtifactTransferRequest;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;
import org.apache.archiva.rest.api.services.RepositoriesService;
import org.apache.archiva.rest.services.AbstractRestService;
import org.apache.archiva.scheduler.ArchivaTaskScheduler;
import org.apache.archiva.scheduler.indexing.ArchivaIndexingTaskExecutor;
import org.apache.archiva.scheduler.indexing.ArtifactIndexingTask;
import org.apache.archiva.scheduler.indexing.DownloadRemoteIndexException;
import org.apache.archiva.scheduler.indexing.DownloadRemoteIndexScheduler;
import org.apache.archiva.scheduler.repository.RepositoryArchivaTaskScheduler;
import org.apache.archiva.scheduler.repository.RepositoryTask;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.index.NexusIndexer;
import org.apache.maven.index.context.IndexingContext;
import org.codehaus.plexus.redback.authentication.AuthenticationResult;
import org.codehaus.plexus.redback.authorization.AuthorizationException;
import org.codehaus.plexus.redback.system.DefaultSecuritySession;
import org.codehaus.plexus.redback.system.SecuritySession;
import org.codehaus.plexus.redback.system.SecuritySystem;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserNotFoundException;
import org.codehaus.plexus.taskqueue.Task;
import org.codehaus.plexus.taskqueue.TaskQueueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="repositoriesService#rest")
public class DefaultRepositoriesService
extends AbstractRestService
implements RepositoriesService {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    @Named(value="archivaTaskScheduler#repository")
    private RepositoryArchivaTaskScheduler repositoryTaskScheduler;
    @Inject
    @Named(value="taskExecutor#indexing")
    private ArchivaIndexingTaskExecutor archivaIndexingTaskExecutor;
    @Inject
    private ManagedRepositoryAdmin managedRepositoryAdmin;
    @Inject
    private PlexusSisuBridge plexusSisuBridge;
    @Inject
    private MavenIndexerUtils mavenIndexerUtils;
    @Inject
    private SecuritySystem securitySystem;
    @Inject
    private RepositoryContentFactory repositoryFactory;
    @Inject
    private ArchivaAdministration archivaAdministration;
    @Inject
    @Named(value="archivaTaskScheduler#repository")
    private ArchivaTaskScheduler scheduler;
    @Inject
    private DownloadRemoteIndexScheduler downloadRemoteIndexScheduler;
    private ChecksumAlgorithm[] algorithms = new ChecksumAlgorithm[]{ChecksumAlgorithm.SHA1, ChecksumAlgorithm.MD5};

    public Boolean scanRepository(String repositoryId, boolean fullScan) {
        if (this.repositoryTaskScheduler.isProcessingRepositoryTask(repositoryId)) {
            this.log.info("scanning of repository with id {} already scheduled", (Object)repositoryId);
            return Boolean.FALSE;
        }
        RepositoryTask task = new RepositoryTask();
        task.setRepositoryId(repositoryId);
        task.setScanAll(fullScan);
        try {
            this.repositoryTaskScheduler.queueTask(task);
        }
        catch (TaskQueueException e) {
            this.log.error("failed to schedule scanning of repo with id {}", (Object)repositoryId, (Object)e);
            return false;
        }
        return true;
    }

    public Boolean alreadyScanning(String repositoryId) {
        return this.repositoryTaskScheduler.isProcessingRepositoryTask(repositoryId);
    }

    public Boolean removeScanningTaskFromQueue(String repositoryId) {
        RepositoryTask task = new RepositoryTask();
        task.setRepositoryId(repositoryId);
        try {
            return this.repositoryTaskScheduler.unQueueTask(task);
        }
        catch (TaskQueueException e) {
            this.log.error("failed to unschedule scanning of repo with id {}", (Object)repositoryId, (Object)e);
            return false;
        }
    }

    public Boolean scanRepositoryNow(String repositoryId, boolean fullScan) throws ArchivaRestServiceException {
        try {
            ManagedRepository repository = this.managedRepositoryAdmin.getManagedRepository(repositoryId);
            IndexingContext context = ArtifactIndexingTask.createContext((ManagedRepository)repository, (NexusIndexer)((NexusIndexer)this.plexusSisuBridge.lookup(NexusIndexer.class)), new ArrayList(this.mavenIndexerUtils.getAllIndexCreators()));
            ArtifactIndexingTask task = new ArtifactIndexingTask(repository, null, ArtifactIndexingTask.Action.FINISH, context);
            task.setExecuteOnEntireRepo(true);
            task.setOnlyUpdate(false);
            this.archivaIndexingTaskExecutor.executeTask((Task)task);
            return Boolean.TRUE;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage());
        }
    }

    public Boolean scheduleDownloadRemoteIndex(String repositoryId, boolean now, boolean fullDownload) throws ArchivaRestServiceException {
        try {
            this.downloadRemoteIndexScheduler.scheduleDownloadRemote(repositoryId, now, fullDownload);
        }
        catch (DownloadRemoteIndexException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage());
        }
        return Boolean.TRUE;
    }

    public Boolean copyArtifact(ArtifactTransferRequest artifactTransferRequest) throws ArchivaRestServiceException {
        boolean authz;
        String userName = this.getAuditInformation().getUser().getUsername();
        if (StringUtils.isBlank((String)userName)) {
            throw new ArchivaRestServiceException("copyArtifact call: userName not found");
        }
        if (StringUtils.isBlank((String)artifactTransferRequest.getRepositoryId())) {
            throw new ArchivaRestServiceException("copyArtifact call: sourceRepositoryId cannot be null");
        }
        if (StringUtils.isBlank((String)artifactTransferRequest.getTargetRepositoryId())) {
            throw new ArchivaRestServiceException("copyArtifact call: targetRepositoryId cannot be null");
        }
        ManagedRepository source = null;
        try {
            source = this.managedRepositoryAdmin.getManagedRepository(artifactTransferRequest.getRepositoryId());
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage());
        }
        if (source == null) {
            throw new ArchivaRestServiceException("cannot find repository with id " + artifactTransferRequest.getRepositoryId());
        }
        ManagedRepository target = null;
        try {
            target = this.managedRepositoryAdmin.getManagedRepository(artifactTransferRequest.getTargetRepositoryId());
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage());
        }
        if (target == null) {
            throw new ArchivaRestServiceException("cannot find repository with id " + artifactTransferRequest.getTargetRepositoryId());
        }
        if (StringUtils.isBlank((String)artifactTransferRequest.getGroupId())) {
            throw new ArchivaRestServiceException("groupId is mandatory");
        }
        if (StringUtils.isBlank((String)artifactTransferRequest.getArtifactId())) {
            throw new ArchivaRestServiceException("artifactId is mandatory");
        }
        if (StringUtils.isBlank((String)artifactTransferRequest.getVersion())) {
            throw new ArchivaRestServiceException("version is mandatory");
        }
        if (VersionUtil.isSnapshot((String)artifactTransferRequest.getVersion())) {
            throw new ArchivaRestServiceException("copy of SNAPSHOT not supported");
        }
        User user = null;
        try {
            user = this.securitySystem.getUserManager().findUser(userName);
        }
        catch (UserNotFoundException e) {
            throw new ArchivaRestServiceException("user " + userName + " not found");
        }
        AuthenticationResult authn = new AuthenticationResult(true, (Object)userName, null);
        DefaultSecuritySession securitySession = new DefaultSecuritySession(authn, user);
        try {
            authz = this.securitySystem.isAuthorized((SecuritySession)securitySession, (Object)"archiva-read-repository", (Object)artifactTransferRequest.getRepositoryId());
            if (!authz) {
                throw new ArchivaRestServiceException("not authorized to access repo:" + artifactTransferRequest.getRepositoryId());
            }
        }
        catch (AuthorizationException e) {
            this.log.error("error reading permission: " + e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage());
        }
        try {
            authz = this.securitySystem.isAuthorized((SecuritySession)securitySession, (Object)"archiva-upload-repository", (Object)artifactTransferRequest.getTargetRepositoryId());
            if (!authz) {
                throw new ArchivaRestServiceException("not authorized to write to repo:" + artifactTransferRequest.getTargetRepositoryId());
            }
        }
        catch (AuthorizationException e) {
            this.log.error("error reading permission: " + e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage());
        }
        ArtifactReference artifactReference = new ArtifactReference();
        artifactReference.setArtifactId(artifactTransferRequest.getArtifactId());
        artifactReference.setGroupId(artifactTransferRequest.getGroupId());
        artifactReference.setVersion(artifactTransferRequest.getVersion());
        artifactReference.setClassifier(artifactTransferRequest.getClassifier());
        String packaging = StringUtils.trim((String)artifactTransferRequest.getPackaging());
        artifactReference.setType(StringUtils.isEmpty((String)packaging) ? "jar" : packaging);
        try {
            ManagedRepositoryContent sourceRepository = this.repositoryFactory.getManagedRepositoryContent(artifactTransferRequest.getRepositoryId());
            String artifactSourcePath = sourceRepository.toPath(artifactReference);
            if (StringUtils.isEmpty((String)artifactSourcePath)) {
                this.log.error("cannot find artifact " + artifactTransferRequest.toString());
                throw new ArchivaRestServiceException("cannot find artifact " + artifactTransferRequest.toString());
            }
            File artifactFile = new File(source.getLocation(), artifactSourcePath);
            if (!artifactFile.exists()) {
                this.log.error("cannot find artifact " + artifactTransferRequest.toString());
                throw new ArchivaRestServiceException("cannot find artifact " + artifactTransferRequest.toString());
            }
            ManagedRepositoryContent targetRepository = this.repositoryFactory.getManagedRepositoryContent(artifactTransferRequest.getTargetRepositoryId());
            String artifactPath = targetRepository.toPath(artifactReference);
            int lastIndex = artifactPath.lastIndexOf(47);
            String path = artifactPath.substring(0, lastIndex);
            File targetPath = new File(target.getLocation(), path);
            Date lastUpdatedTimestamp = Calendar.getInstance().getTime();
            int newBuildNumber = 1;
            String timestamp = null;
            File versionMetadataFile = new File(targetPath, "maven-metadata.xml");
            ArchivaRepositoryMetadata versionMetadata = this.getMetadata(versionMetadataFile);
            if (!targetPath.exists()) {
                targetPath.mkdirs();
            }
            String filename = artifactPath.substring(lastIndex + 1);
            boolean fixChecksums = !this.archivaAdministration.getKnownContentConsumers().contains("create-missing-checksums");
            File targetFile = new File(targetPath, filename);
            if (targetFile.exists() && target.isBlockRedeployments()) {
                throw new ArchivaRestServiceException("artifact already exists in target repo: " + artifactTransferRequest.getTargetRepositoryId() + " and redeployment blocked");
            }
            this.copyFile(artifactFile, targetPath, filename, fixChecksums);
            this.queueRepositoryTask(target.getId(), targetFile);
            String pomFilename = filename;
            if (StringUtils.isNotBlank((String)artifactTransferRequest.getClassifier())) {
                pomFilename = StringUtils.remove((String)pomFilename, (String)("-" + artifactTransferRequest.getClassifier()));
            }
            pomFilename = FilenameUtils.removeExtension((String)pomFilename) + ".pom";
            File pomFile = new File(new File(source.getLocation(), artifactSourcePath.substring(0, artifactPath.lastIndexOf(47))), pomFilename);
            if (pomFile != null && pomFile.length() > 0L) {
                this.copyFile(pomFile, targetPath, pomFilename, fixChecksums);
                this.queueRepositoryTask(target.getId(), new File(targetPath, pomFilename));
            }
            if (!this.archivaAdministration.getKnownContentConsumers().contains("metadata-updater")) {
                this.updateProjectMetadata(targetPath.getAbsolutePath(), lastUpdatedTimestamp, timestamp, newBuildNumber, fixChecksums, artifactTransferRequest);
            }
            String msg = "Artifact '" + artifactTransferRequest.getGroupId() + ":" + artifactTransferRequest.getArtifactId() + ":" + artifactTransferRequest.getVersion() + "' was successfully deployed to repository '" + artifactTransferRequest.getTargetRepositoryId() + "'";
        }
        catch (RepositoryException e) {
            this.log.error("RepositoryException: " + e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage());
        }
        catch (RepositoryAdminException e) {
            this.log.error("RepositoryAdminException: " + e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage());
        }
        catch (IOException e) {
            this.log.error("IOException: " + e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage());
        }
        return true;
    }

    private void queueRepositoryTask(String repositoryId, File localFile) {
        RepositoryTask task = new RepositoryTask();
        task.setRepositoryId(repositoryId);
        task.setResourceFile(localFile);
        task.setUpdateRelatedArtifacts(true);
        try {
            this.scheduler.queueTask((Task)task);
        }
        catch (TaskQueueException e) {
            this.log.error("Unable to queue repository task to execute consumers on resource file ['" + localFile.getName() + "'].");
        }
    }

    private ArchivaRepositoryMetadata getMetadata(File metadataFile) throws RepositoryMetadataException {
        ArchivaRepositoryMetadata metadata = new ArchivaRepositoryMetadata();
        if (metadataFile.exists()) {
            metadata = RepositoryMetadataReader.read((File)metadataFile);
        }
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File sourceFile, File targetPath, String targetFilename, boolean fixChecksums) throws IOException {
        FileOutputStream out = new FileOutputStream(new File(targetPath, targetFilename));
        FileInputStream input = new FileInputStream(sourceFile);
        try {
            IOUtils.copy((InputStream)input, (OutputStream)out);
        }
        finally {
            out.close();
            input.close();
        }
        if (fixChecksums) {
            this.fixChecksums(new File(targetPath, targetFilename));
        }
    }

    private void fixChecksums(File file) {
        ChecksummedFile checksum = new ChecksummedFile(file);
        checksum.fixChecksums(this.algorithms);
    }

    private void updateProjectMetadata(String targetPath, Date lastUpdatedTimestamp, String timestamp, int buildNumber, boolean fixChecksums, ArtifactTransferRequest artifactTransferRequest) throws RepositoryMetadataException {
        List<String> availableVersions = new ArrayList<String>();
        String latestVersion = artifactTransferRequest.getVersion();
        File projectDir = new File(targetPath).getParentFile();
        File projectMetadataFile = new File(projectDir, "maven-metadata.xml");
        ArchivaRepositoryMetadata projectMetadata = this.getMetadata(projectMetadataFile);
        if (projectMetadataFile.exists()) {
            availableVersions = projectMetadata.getAvailableVersions();
            Collections.sort(availableVersions, VersionComparator.getInstance());
            if (!availableVersions.contains(artifactTransferRequest.getVersion())) {
                availableVersions.add(artifactTransferRequest.getVersion());
            }
            latestVersion = (String)availableVersions.get(availableVersions.size() - 1);
        } else {
            availableVersions.add(artifactTransferRequest.getVersion());
            projectMetadata.setGroupId(artifactTransferRequest.getGroupId());
            projectMetadata.setArtifactId(artifactTransferRequest.getArtifactId());
        }
        if (projectMetadata.getGroupId() == null) {
            projectMetadata.setGroupId(artifactTransferRequest.getGroupId());
        }
        if (projectMetadata.getArtifactId() == null) {
            projectMetadata.setArtifactId(artifactTransferRequest.getArtifactId());
        }
        projectMetadata.setLatestVersion(latestVersion);
        projectMetadata.setLastUpdatedTimestamp(lastUpdatedTimestamp);
        projectMetadata.setAvailableVersions(availableVersions);
        if (!VersionUtil.isSnapshot((String)artifactTransferRequest.getVersion())) {
            projectMetadata.setReleasedVersion(latestVersion);
        }
        RepositoryMetadataWriter.write((ArchivaRepositoryMetadata)projectMetadata, (File)projectMetadataFile);
        if (fixChecksums) {
            this.fixChecksums(projectMetadataFile);
        }
    }
}

