package org.apache.archiva.rest.services.interceptors;
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.interceptor.JAXRSInInterceptor;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.Phase;
import org.apache.cxf.phase.PhaseInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.ws.rs.core.Response;

/**
 * @author Olivier Lamy
 * @since 1.4-M1
 */
@Service( "httpContextThreadLocalCleaner#rest" )
public class HttpContextThreadLocalCleaner
    extends AbstractPhaseInterceptor<Message>
    implements PhaseInterceptor<Message>
{
    private Logger log = LoggerFactory.getLogger( getClass() );

    public HttpContextThreadLocalCleaner( String phase )
    {
        super( phase );
        addAfter( JAXRSInInterceptor.class.getName() );
    }


    public HttpContextThreadLocalCleaner()
    {
        super( Phase.PRE_STREAM );
        addAfter( JAXRSInInterceptor.class.getName() );
    }


    public Response handleResponse( Message message, OperationResourceInfo operationResourceInfo, Response response )
    {
        log.debug( "handleResponse" );
        cleanup();
        return null;
    }

    private void cleanup()
    {
        HttpContextThreadLocal.set( null );
    }

    public void handleMessage( Message message )
        throws Fault
    {
        log.debug( "handleMessage" );
        cleanup();
    }
}
