/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.admin.repository.remote;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.archiva.admin.model.AuditInformation;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.AbstractRepository;
import org.apache.archiva.admin.model.beans.RemoteRepository;
import org.apache.archiva.admin.model.remote.RemoteRepositoryAdmin;
import org.apache.archiva.admin.repository.AbstractRepositoryAdmin;
import org.apache.archiva.common.plexusbridge.MavenIndexerUtils;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridge;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridgeException;
import org.apache.archiva.configuration.Configuration;
import org.apache.archiva.configuration.ProxyConnectorConfiguration;
import org.apache.archiva.configuration.RemoteRepositoryConfiguration;
import org.apache.archiva.configuration.RepositoryCheckPath;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.index.NexusIndexer;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.context.UnsupportedExistingLuceneIndexException;
import org.springframework.stereotype.Service;

@Service(value="remoteRepositoryAdmin#default")
public class DefaultRemoteRepositoryAdmin
extends AbstractRepositoryAdmin
implements RemoteRepositoryAdmin {
    @Inject
    private PlexusSisuBridge plexusSisuBridge;
    @Inject
    private MavenIndexerUtils mavenIndexerUtils;
    private List<? extends IndexCreator> indexCreators;
    private NexusIndexer indexer;

    @PostConstruct
    private void initialize() throws RepositoryAdminException {
        try {
            this.indexCreators = this.mavenIndexerUtils.getAllIndexCreators();
            this.indexer = (NexusIndexer)this.plexusSisuBridge.lookup(NexusIndexer.class);
        }
        catch (PlexusSisuBridgeException e) {
            throw new RepositoryAdminException(e.getMessage(), (Throwable)e);
        }
        for (RemoteRepository remoteRepository : this.getRemoteRepositories()) {
            this.createIndexContext(remoteRepository);
        }
    }

    @PreDestroy
    private void shutdown() throws RepositoryAdminException {
        try {
            List<RemoteRepository> remoteRepositories = this.getRemoteRepositories();
            for (RemoteRepository remoteRepository : remoteRepositories) {
                IndexingContext context = (IndexingContext)this.indexer.getIndexingContexts().get(remoteRepository.getId());
                if (context == null) continue;
                this.indexer.removeIndexingContext(context, false);
            }
        }
        catch (IOException e) {
            throw new RepositoryAdminException(e.getMessage(), (Throwable)e);
        }
    }

    public List<RemoteRepository> getRemoteRepositories() throws RepositoryAdminException {
        ArrayList<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>(this.getArchivaConfiguration().getConfiguration().getRemoteRepositories().size());
        for (RemoteRepositoryConfiguration repositoryConfiguration : this.getArchivaConfiguration().getConfiguration().getRemoteRepositories()) {
            RemoteRepository remoteRepository = new RemoteRepository(repositoryConfiguration.getId(), repositoryConfiguration.getName(), repositoryConfiguration.getUrl(), repositoryConfiguration.getLayout(), repositoryConfiguration.getUsername(), repositoryConfiguration.getPassword(), repositoryConfiguration.getTimeout());
            remoteRepository.setDownloadRemoteIndex(repositoryConfiguration.isDownloadRemoteIndex());
            remoteRepository.setRemoteIndexUrl(repositoryConfiguration.getRemoteIndexUrl());
            remoteRepository.setCronExpression(repositoryConfiguration.getRefreshCronExpression());
            remoteRepository.setIndexDirectory(repositoryConfiguration.getIndexDir());
            remoteRepository.setRemoteDownloadNetworkProxyId(repositoryConfiguration.getRemoteDownloadNetworkProxyId());
            remoteRepository.setRemoteDownloadTimeout(repositoryConfiguration.getRemoteDownloadTimeout());
            remoteRepository.setDownloadRemoteIndexOnStartup(repositoryConfiguration.isDownloadRemoteIndexOnStartup());
            remoteRepository.setDescription(repositoryConfiguration.getDescription());
            remoteRepository.setExtraHeaders(repositoryConfiguration.getExtraHeaders());
            remoteRepository.setExtraParameters(repositoryConfiguration.getExtraParameters());
            remoteRepository.setCheckPath(repositoryConfiguration.getCheckPath());
            remoteRepositories.add(remoteRepository);
        }
        return remoteRepositories;
    }

    public RemoteRepository getRemoteRepository(String repositoryId) throws RepositoryAdminException {
        for (RemoteRepository remoteRepository : this.getRemoteRepositories()) {
            if (!StringUtils.equals((String)repositoryId, (String)remoteRepository.getId())) continue;
            return remoteRepository;
        }
        return null;
    }

    public Boolean addRemoteRepository(RemoteRepository remoteRepository, AuditInformation auditInformation) throws RepositoryAdminException {
        this.triggerAuditEvent(remoteRepository.getId(), null, "Added Remote Repository", auditInformation);
        this.getRepositoryCommonValidator().basicValidation((AbstractRepository)remoteRepository, false);
        if (StringUtils.isEmpty((String)remoteRepository.getUrl())) {
            throw new RepositoryAdminException("url cannot be null");
        }
        remoteRepository.setUrl(StringUtils.stripEnd((String)StringUtils.trim((String)remoteRepository.getUrl()), (String)"/"));
        if (StringUtils.isEmpty((String)remoteRepository.getCheckPath())) {
            String checkUrl = remoteRepository.getUrl().toLowerCase();
            for (RepositoryCheckPath path : this.getArchivaConfiguration().getConfiguration().getArchivaDefaultConfiguration().getDefaultCheckPaths()) {
                this.log.debug("Checking path for urls: {} <-> {}", (Object)checkUrl, (Object)path.getUrl());
                if (!checkUrl.startsWith(path.getUrl())) continue;
                remoteRepository.setCheckPath(path.getPath());
                break;
            }
        }
        RemoteRepositoryConfiguration remoteRepositoryConfiguration = this.getRemoteRepositoryConfiguration(remoteRepository);
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        configuration.addRemoteRepository(remoteRepositoryConfiguration);
        this.saveConfiguration(configuration);
        return Boolean.TRUE;
    }

    public Boolean deleteRemoteRepository(String repositoryId, AuditInformation auditInformation) throws RepositoryAdminException {
        this.triggerAuditEvent(repositoryId, null, "Deleted Remote Repository", auditInformation);
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        RemoteRepositoryConfiguration remoteRepositoryConfiguration = (RemoteRepositoryConfiguration)configuration.getRemoteRepositoriesAsMap().get(repositoryId);
        if (remoteRepositoryConfiguration == null) {
            throw new RepositoryAdminException("remoteRepository with id " + repositoryId + " not exist cannot remove it");
        }
        configuration.removeRemoteRepository(remoteRepositoryConfiguration);
        ArrayList proxyConnectors = new ArrayList(configuration.getProxyConnectors());
        for (ProxyConnectorConfiguration proxyConnector : proxyConnectors) {
            if (!StringUtils.equals((String)proxyConnector.getTargetRepoId(), (String)repositoryId)) continue;
            configuration.removeProxyConnector(proxyConnector);
        }
        this.saveConfiguration(configuration);
        return Boolean.TRUE;
    }

    public Boolean updateRemoteRepository(RemoteRepository remoteRepository, AuditInformation auditInformation) throws RepositoryAdminException {
        String repositoryId = remoteRepository.getId();
        this.triggerAuditEvent(repositoryId, null, "Updated Remote Repository", auditInformation);
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        RemoteRepositoryConfiguration remoteRepositoryConfiguration = (RemoteRepositoryConfiguration)configuration.getRemoteRepositoriesAsMap().get(repositoryId);
        if (remoteRepositoryConfiguration == null) {
            throw new RepositoryAdminException("remoteRepository with id " + repositoryId + " not exist cannot remove it");
        }
        configuration.removeRemoteRepository(remoteRepositoryConfiguration);
        remoteRepositoryConfiguration = this.getRemoteRepositoryConfiguration(remoteRepository);
        configuration.addRemoteRepository(remoteRepositoryConfiguration);
        this.saveConfiguration(configuration);
        return Boolean.TRUE;
    }

    public Map<String, RemoteRepository> getRemoteRepositoriesAsMap() throws RepositoryAdminException {
        HashMap<String, RemoteRepository> map = new HashMap<String, RemoteRepository>();
        for (RemoteRepository repo : this.getRemoteRepositories()) {
            map.put(repo.getId(), repo);
        }
        return map;
    }

    public IndexingContext createIndexContext(RemoteRepository remoteRepository) throws RepositoryAdminException {
        try {
            String appServerBase = this.getRegistry().getString("appserver.base");
            String contextKey = "remote-" + remoteRepository.getId();
            IndexingContext indexingContext = (IndexingContext)this.indexer.getIndexingContexts().get(contextKey);
            if (indexingContext != null) {
                return indexingContext;
            }
            File repoDir = new File(appServerBase, "data/remotes/" + remoteRepository.getId());
            if (!repoDir.exists()) {
                repoDir.mkdirs();
            }
            File indexDirectory = null;
            String indexDirectoryPath = remoteRepository.getIndexDirectory();
            if (StringUtils.isNotBlank((String)indexDirectoryPath)) {
                indexDirectory = new File(indexDirectoryPath).isAbsolute() ? new File(indexDirectoryPath) : new File(repoDir, indexDirectoryPath);
            }
            if (indexDirectory == null) {
                indexDirectory = new File(repoDir, ".index");
            }
            if (!indexDirectory.exists()) {
                indexDirectory.mkdirs();
            }
            return this.indexer.addIndexingContext(contextKey, remoteRepository.getId(), repoDir, indexDirectory, remoteRepository.getUrl(), this.calculateIndexRemoteUrl(remoteRepository), this.mavenIndexerUtils.getAllIndexCreators());
        }
        catch (MalformedURLException e) {
            throw new RepositoryAdminException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryAdminException(e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedExistingLuceneIndexException e) {
            throw new RepositoryAdminException(e.getMessage(), (Throwable)e);
        }
    }

    protected String calculateIndexRemoteUrl(RemoteRepository remoteRepository) {
        if (StringUtils.startsWith((String)remoteRepository.getRemoteIndexUrl(), (String)"http")) {
            String baseUrl = remoteRepository.getRemoteIndexUrl();
            return baseUrl.endsWith("/") ? StringUtils.substringBeforeLast((String)baseUrl, (String)"/") : baseUrl;
        }
        String baseUrl = StringUtils.endsWith((String)remoteRepository.getUrl(), (String)"/") ? StringUtils.substringBeforeLast((String)remoteRepository.getUrl(), (String)"/") : remoteRepository.getUrl();
        baseUrl = StringUtils.isEmpty((String)remoteRepository.getRemoteIndexUrl()) ? baseUrl + "/.index" : baseUrl + "/" + remoteRepository.getRemoteIndexUrl();
        return baseUrl;
    }

    private RemoteRepositoryConfiguration getRemoteRepositoryConfiguration(RemoteRepository remoteRepository) {
        RemoteRepositoryConfiguration remoteRepositoryConfiguration = new RemoteRepositoryConfiguration();
        remoteRepositoryConfiguration.setId(remoteRepository.getId());
        remoteRepositoryConfiguration.setPassword(remoteRepository.getPassword());
        remoteRepositoryConfiguration.setTimeout(remoteRepository.getTimeout());
        remoteRepositoryConfiguration.setUrl(remoteRepository.getUrl());
        remoteRepositoryConfiguration.setUsername(remoteRepository.getUserName());
        remoteRepositoryConfiguration.setLayout(remoteRepository.getLayout());
        remoteRepositoryConfiguration.setName(remoteRepository.getName());
        remoteRepositoryConfiguration.setDownloadRemoteIndex(remoteRepository.isDownloadRemoteIndex());
        remoteRepositoryConfiguration.setRemoteIndexUrl(remoteRepository.getRemoteIndexUrl());
        remoteRepositoryConfiguration.setRefreshCronExpression(remoteRepository.getCronExpression());
        remoteRepositoryConfiguration.setIndexDir(remoteRepository.getIndexDirectory());
        remoteRepositoryConfiguration.setRemoteDownloadNetworkProxyId(remoteRepository.getRemoteDownloadNetworkProxyId());
        remoteRepositoryConfiguration.setRemoteDownloadTimeout(remoteRepository.getRemoteDownloadTimeout());
        remoteRepositoryConfiguration.setDownloadRemoteIndexOnStartup(remoteRepository.isDownloadRemoteIndexOnStartup());
        remoteRepositoryConfiguration.setDescription(remoteRepository.getDescription());
        remoteRepositoryConfiguration.setExtraHeaders(remoteRepository.getExtraHeaders());
        remoteRepositoryConfiguration.setExtraParameters(remoteRepository.getExtraParameters());
        remoteRepositoryConfiguration.setCheckPath(remoteRepository.getCheckPath());
        return remoteRepositoryConfiguration;
    }
}

