/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.admin.repository.managed;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.admin.model.AuditInformation;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.AbstractRepository;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.admin.model.managed.ManagedRepositoryAdmin;
import org.apache.archiva.admin.repository.AbstractRepositoryAdmin;
import org.apache.archiva.common.plexusbridge.MavenIndexerUtils;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridge;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridgeException;
import org.apache.archiva.configuration.Configuration;
import org.apache.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.archiva.configuration.ProxyConnectorConfiguration;
import org.apache.archiva.configuration.RepositoryGroupConfiguration;
import org.apache.archiva.metadata.repository.MetadataRepository;
import org.apache.archiva.metadata.repository.RepositorySession;
import org.apache.archiva.metadata.repository.RepositorySessionFactory;
import org.apache.archiva.metadata.repository.stats.RepositoryStatisticsManager;
import org.apache.archiva.redback.components.cache.Cache;
import org.apache.archiva.redback.components.taskqueue.TaskQueueException;
import org.apache.archiva.redback.role.RoleManager;
import org.apache.archiva.redback.role.RoleManagerException;
import org.apache.archiva.scheduler.repository.model.RepositoryArchivaTaskScheduler;
import org.apache.archiva.scheduler.repository.model.RepositoryTask;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.index.NexusIndexer;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.context.UnsupportedExistingLuceneIndexException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="managedRepositoryAdmin#default")
public class DefaultManagedRepositoryAdmin
extends AbstractRepositoryAdmin
implements ManagedRepositoryAdmin {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String STAGE_REPO_ID_END = "-stage";
    @Inject
    @Named(value="archivaTaskScheduler#repository")
    private RepositoryArchivaTaskScheduler repositoryTaskScheduler;
    @Inject
    private RepositorySessionFactory repositorySessionFactory;
    @Inject
    private RepositoryStatisticsManager repositoryStatisticsManager;
    @Inject
    private PlexusSisuBridge plexusSisuBridge;
    @Inject
    private MavenIndexerUtils mavenIndexerUtils;
    @Inject
    protected RoleManager roleManager;
    @Inject
    @Named(value="cache#namespaces")
    private Cache<String, Collection<String>> namespacesCache;
    List<? extends IndexCreator> indexCreators;
    NexusIndexer indexer;

    @PostConstruct
    public void initialize() throws RepositoryAdminException, RoleManagerException {
        try {
            this.indexCreators = this.mavenIndexerUtils.getAllIndexCreators();
            this.indexer = (NexusIndexer)this.plexusSisuBridge.lookup(NexusIndexer.class);
        }
        catch (PlexusSisuBridgeException e) {
            throw new RepositoryAdminException(e.getMessage(), (Throwable)e);
        }
        for (ManagedRepository managedRepository : this.getManagedRepositories()) {
            this.createIndexContext(managedRepository);
            this.addRepositoryRoles(managedRepository.getId());
        }
    }

    @PreDestroy
    public void shutdown() throws RepositoryAdminException {
        try {
            for (ManagedRepository managedRepository : this.getManagedRepositories()) {
                IndexingContext context = (IndexingContext)this.indexer.getIndexingContexts().get(managedRepository.getId());
                if (context == null) continue;
                this.indexer.removeIndexingContext(context, false);
            }
        }
        catch (IOException e) {
            throw new RepositoryAdminException(e.getMessage(), (Throwable)e);
        }
    }

    public List<ManagedRepository> getManagedRepositories() throws RepositoryAdminException {
        List managedRepoConfigs = this.getArchivaConfiguration().getConfiguration().getManagedRepositories();
        if (managedRepoConfigs == null) {
            return Collections.emptyList();
        }
        ArrayList<ManagedRepository> managedRepos = new ArrayList<ManagedRepository>(managedRepoConfigs.size());
        for (ManagedRepositoryConfiguration repoConfig : managedRepoConfigs) {
            ManagedRepository repo = new ManagedRepository(repoConfig.getId(), repoConfig.getName(), repoConfig.getLocation(), repoConfig.getLayout(), repoConfig.isSnapshots(), repoConfig.isReleases(), repoConfig.isBlockRedeployments(), repoConfig.getRefreshCronExpression(), repoConfig.getIndexDir(), repoConfig.isScanned(), repoConfig.getDaysOlder(), repoConfig.getRetentionCount(), repoConfig.isDeleteReleasedSnapshots(), repoConfig.isStageRepoNeeded());
            repo.setDescription(repoConfig.getDescription());
            repo.setSkipPackedIndexCreation(repoConfig.isSkipPackedIndexCreation());
            managedRepos.add(repo);
        }
        return managedRepos;
    }

    public Map<String, ManagedRepository> getManagedRepositoriesAsMap() throws RepositoryAdminException {
        List<ManagedRepository> managedRepositories = this.getManagedRepositories();
        HashMap<String, ManagedRepository> repositoriesMap = new HashMap<String, ManagedRepository>(managedRepositories.size());
        for (ManagedRepository managedRepository : managedRepositories) {
            repositoriesMap.put(managedRepository.getId(), managedRepository);
        }
        return repositoriesMap;
    }

    public ManagedRepository getManagedRepository(String repositoryId) throws RepositoryAdminException {
        List<ManagedRepository> repos = this.getManagedRepositories();
        for (ManagedRepository repo : repos) {
            if (!StringUtils.equals((String)repo.getId(), (String)repositoryId)) continue;
            return repo;
        }
        return null;
    }

    public Boolean addManagedRepository(ManagedRepository managedRepository, boolean needStageRepo, AuditInformation auditInformation) throws RepositoryAdminException {
        this.getRepositoryCommonValidator().basicValidation((AbstractRepository)managedRepository, false);
        this.getRepositoryCommonValidator().validateManagedRepository(managedRepository);
        this.triggerAuditEvent(managedRepository.getId(), null, "Added Managed Repository", auditInformation);
        Boolean res = this.addManagedRepository(managedRepository.getId(), managedRepository.getLayout(), managedRepository.getName(), managedRepository.getLocation(), managedRepository.isBlockRedeployments(), managedRepository.isReleases(), managedRepository.isSnapshots(), needStageRepo, managedRepository.getCronExpression(), managedRepository.getIndexDirectory(), managedRepository.getDaysOlder(), managedRepository.getRetentionCount(), managedRepository.isDeleteReleasedSnapshots(), managedRepository.getDescription(), managedRepository.isSkipPackedIndexCreation(), managedRepository.isScanned(), auditInformation, this.getArchivaConfiguration().getConfiguration()) != null;
        this.createIndexContext(managedRepository);
        return res;
    }

    private ManagedRepositoryConfiguration addManagedRepository(String repoId, String layout, String name, String location, boolean blockRedeployments, boolean releasesIncluded, boolean snapshotsIncluded, boolean stageRepoNeeded, String cronExpression, String indexDir, int daysOlder, int retentionCount, boolean deteleReleasedSnapshots, String description, boolean skipPackedIndexCreation, boolean scanned, AuditInformation auditInformation, Configuration config) throws RepositoryAdminException {
        ManagedRepositoryConfiguration stagingRepository;
        ManagedRepositoryConfiguration repository = new ManagedRepositoryConfiguration();
        repository.setId(repoId);
        repository.setBlockRedeployments(blockRedeployments);
        repository.setReleases(releasesIncluded);
        repository.setSnapshots(snapshotsIncluded);
        repository.setScanned(scanned);
        repository.setName(name);
        repository.setLocation(this.getRepositoryCommonValidator().removeExpressions(location));
        repository.setLayout(layout);
        repository.setRefreshCronExpression(cronExpression);
        repository.setIndexDir(indexDir);
        repository.setDaysOlder(daysOlder);
        repository.setRetentionCount(retentionCount);
        repository.setDeleteReleasedSnapshots(deteleReleasedSnapshots);
        repository.setIndexDir(indexDir);
        repository.setDescription(description);
        repository.setSkipPackedIndexCreation(skipPackedIndexCreation);
        repository.setStageRepoNeeded(stageRepoNeeded);
        try {
            this.addRepository(repository, config);
            this.addRepositoryRoles(repository.getId());
            if (stageRepoNeeded) {
                stagingRepository = this.getStageRepoConfig(repository);
                this.addRepository(stagingRepository, config);
                this.addRepositoryRoles(stagingRepository.getId());
                this.triggerAuditEvent(stagingRepository.getId(), null, "Added Managed Repository", auditInformation);
            }
        }
        catch (RoleManagerException e) {
            throw new RepositoryAdminException("failed to add repository roles " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryAdminException("failed to add repository " + e.getMessage(), (Throwable)e);
        }
        this.saveConfiguration(config);
        try {
            if (scanned) {
                this.scanRepository(repoId, true);
            }
            if (stageRepoNeeded && scanned) {
                stagingRepository = this.getStageRepoConfig(repository);
                this.scanRepository(stagingRepository.getId(), true);
            }
        }
        catch (Exception e) {
            this.log.warn("Unable to scan repository [" + repoId + "]: " + e.getMessage(), (Throwable)e);
        }
        return repository;
    }

    public Boolean deleteManagedRepository(String repositoryId, AuditInformation auditInformation, boolean deleteContent) throws RepositoryAdminException {
        Configuration config = this.getArchivaConfiguration().getConfiguration();
        ManagedRepositoryConfiguration repository = config.findManagedRepositoryById(repositoryId);
        if (repository == null) {
            throw new RepositoryAdminException("A repository with that id does not exist");
        }
        this.triggerAuditEvent(repositoryId, null, "Deleted Managed Repository", auditInformation);
        this.deleteManagedRepository(repository, deleteContent, config, false);
        ManagedRepositoryConfiguration stagingRepository = this.getArchivaConfiguration().getConfiguration().findManagedRepositoryById(repositoryId + STAGE_REPO_ID_END);
        if (stagingRepository != null) {
            this.deleteManagedRepository(stagingRepository, deleteContent, config, true);
        }
        try {
            this.saveConfiguration(config);
        }
        catch (Exception e) {
            throw new RepositoryAdminException("Error saving configuration for delete action" + e.getMessage(), (Throwable)e);
        }
        return Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean deleteManagedRepository(ManagedRepositoryConfiguration repository, boolean deleteContent, Configuration config, boolean stagedOne) throws RepositoryAdminException {
        File dir;
        try {
            NexusIndexer nexusIndexer = (NexusIndexer)this.plexusSisuBridge.lookup(NexusIndexer.class);
            IndexingContext context = (IndexingContext)nexusIndexer.getIndexingContexts().get(repository.getId());
            if (context != null) {
                nexusIndexer.removeIndexingContext(context, deleteContent && context.getIndexDirectoryFile().exists());
            }
        }
        catch (PlexusSisuBridgeException e) {
            throw new RepositoryAdminException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryAdminException(e.getMessage(), (Throwable)e);
        }
        if (!stagedOne) {
            try (RepositorySession repositorySession = this.getRepositorySessionFactory().createSession();){
                MetadataRepository metadataRepository = repositorySession.getRepository();
                metadataRepository.removeRepository(repository.getId());
                this.namespacesCache.remove((Object)repository.getId());
                this.log.debug("call repositoryStatisticsManager.deleteStatistics");
                this.getRepositoryStatisticsManager().deleteStatistics(metadataRepository, repository.getId());
                repositorySession.save();
            }
        }
        config.removeManagedRepository(repository);
        if (deleteContent && !FileUtils.deleteQuietly((File)(dir = new File(repository.getLocation())))) {
            throw new RepositoryAdminException("Cannot delete repository " + dir);
        }
        ArrayList proxyConnectors = new ArrayList(config.getProxyConnectors());
        for (ProxyConnectorConfiguration proxyConnector : proxyConnectors) {
            if (!StringUtils.equals((String)proxyConnector.getSourceRepoId(), (String)repository.getId())) continue;
            config.removeProxyConnector(proxyConnector);
        }
        Map repoToGroupMap = config.getRepositoryToGroupMap();
        if (repoToGroupMap != null && repoToGroupMap.containsKey(repository.getId())) {
            List repoGroups = (List)repoToGroupMap.get(repository.getId());
            for (String repoGroup : repoGroups) {
                RepositoryGroupConfiguration repositoryGroupConfiguration = config.findRepositoryGroupById(repoGroup);
                ArrayList repos = new ArrayList(repositoryGroupConfiguration.getRepositories());
                config.removeRepositoryGroup(repositoryGroupConfiguration);
                repos.remove(repository.getId());
                repositoryGroupConfiguration.setRepositories(repos);
                config.addRepositoryGroup(repositoryGroupConfiguration);
            }
        }
        try {
            this.removeRepositoryRoles(repository);
        }
        catch (RoleManagerException e) {
            throw new RepositoryAdminException("fail to remove repository roles for repository " + repository.getId() + " : " + e.getMessage(), (Throwable)e);
        }
        this.saveConfiguration(config);
        return Boolean.TRUE;
    }

    public Boolean updateManagedRepository(ManagedRepository managedRepository, boolean needStageRepo, AuditInformation auditInformation, boolean resetStats) throws RepositoryAdminException {
        ManagedRepositoryConfiguration stagingRepository;
        this.log.debug("updateManagedConfiguration repo {} needStage {} resetStats {} ", new Object[]{managedRepository, needStageRepo, resetStats});
        this.getRepositoryCommonValidator().basicValidation((AbstractRepository)managedRepository, true);
        this.getRepositoryCommonValidator().validateManagedRepository(managedRepository);
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        ManagedRepositoryConfiguration toremove = configuration.findManagedRepositoryById(managedRepository.getId());
        boolean updateIndexContext = false;
        if (toremove != null) {
            configuration.removeManagedRepository(toremove);
            boolean bl = updateIndexContext = !StringUtils.equals((String)toremove.getIndexDir(), (String)managedRepository.getIndexDirectory());
        }
        if ((stagingRepository = this.getStageRepoConfig(toremove)) != null) {
            configuration.removeManagedRepository(stagingRepository);
        }
        ManagedRepositoryConfiguration managedRepositoryConfiguration = this.addManagedRepository(managedRepository.getId(), managedRepository.getLayout(), managedRepository.getName(), managedRepository.getLocation(), managedRepository.isBlockRedeployments(), managedRepository.isReleases(), managedRepository.isSnapshots(), needStageRepo, managedRepository.getCronExpression(), managedRepository.getIndexDirectory(), managedRepository.getDaysOlder(), managedRepository.getRetentionCount(), managedRepository.isDeleteReleasedSnapshots(), managedRepository.getDescription(), managedRepository.isSkipPackedIndexCreation(), managedRepository.isScanned(), auditInformation, this.getArchivaConfiguration().getConfiguration());
        try (RepositorySession repositorySession = this.getRepositorySessionFactory().createSession();){
            this.triggerAuditEvent(managedRepositoryConfiguration.getId(), null, "Updated Managed Repository", auditInformation);
            this.saveConfiguration(this.getArchivaConfiguration().getConfiguration());
            if (resetStats) {
                this.log.debug("call repositoryStatisticsManager.deleteStatistics");
                this.getRepositoryStatisticsManager().deleteStatistics(repositorySession.getRepository(), managedRepositoryConfiguration.getId());
                repositorySession.save();
            }
        }
        if (updateIndexContext) {
            try {
                IndexingContext indexingContext = (IndexingContext)this.indexer.getIndexingContexts().get(managedRepository.getId());
                if (indexingContext != null) {
                    this.indexer.removeIndexingContext(indexingContext, true);
                }
                File indexDirectory = indexingContext.getIndexDirectoryFile();
                FileUtils.deleteDirectory((File)indexDirectory);
                this.createIndexContext(managedRepository);
            }
            catch (IOException e) {
                throw new RepositoryAdminException(e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    protected void addRepository(ManagedRepositoryConfiguration repository, Configuration configuration) throws RepositoryAdminException, IOException {
        File file = new File(repository.getLocation());
        if (!file.isAbsolute()) {
            file = new File(this.getRegistry().getString("appserver.base") + File.separatorChar + "repositories", repository.getLocation());
        }
        repository.setLocation(file.getCanonicalPath());
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.exists() || !file.isDirectory()) {
            throw new RepositoryAdminException("Unable to add repository - no write access, can not create the root directory: " + file);
        }
        configuration.addManagedRepository(repository);
    }

    public IndexingContext createIndexContext(ManagedRepository repository) throws RepositoryAdminException {
        IndexingContext context = (IndexingContext)this.indexer.getIndexingContexts().get(repository.getId());
        if (context != null) {
            this.log.debug("skip creating repository indexingContent with id {} as already exists", (Object)repository.getId());
            return context;
        }
        File repositoryDirectory = new File(repository.getLocation());
        if (!repositoryDirectory.isAbsolute()) {
            repositoryDirectory = new File(this.getRegistry().getString("appserver.base") + File.separatorChar + "repositories", repository.getLocation());
        }
        if (!repositoryDirectory.exists()) {
            repositoryDirectory.mkdirs();
        }
        try {
            String indexDir = repository.getIndexDirectory();
            File indexDirectory = null;
            if (StringUtils.isNotBlank((String)indexDir)) {
                indexDirectory = new File(repository.getIndexDirectory());
                if (!indexDirectory.isAbsolute()) {
                    indexDirectory = new File(repositoryDirectory, repository.getIndexDirectory());
                }
                repository.setIndexDirectory(indexDirectory.getAbsolutePath());
            } else {
                indexDirectory = new File(repositoryDirectory, ".indexer");
                if (!repositoryDirectory.isAbsolute()) {
                    indexDirectory = new File(repositoryDirectory, ".indexer");
                }
                repository.setIndexDirectory(indexDirectory.getAbsolutePath());
            }
            if (!indexDirectory.exists()) {
                indexDirectory.mkdirs();
            }
            if ((context = (IndexingContext)this.indexer.getIndexingContexts().get(repository.getId())) == null) {
                context = this.indexer.addIndexingContext(repository.getId(), repository.getId(), repositoryDirectory, indexDirectory, repositoryDirectory.toURI().toURL().toExternalForm(), indexDirectory.toURI().toURL().toString(), this.indexCreators);
                context.setSearchable(repository.isScanned());
            }
            return context;
        }
        catch (MalformedURLException e) {
            throw new RepositoryAdminException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryAdminException(e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedExistingLuceneIndexException e) {
            throw new RepositoryAdminException(e.getMessage(), (Throwable)e);
        }
    }

    private ManagedRepositoryConfiguration getStageRepoConfig(ManagedRepositoryConfiguration repository) {
        ManagedRepositoryConfiguration stagingRepository = new ManagedRepositoryConfiguration();
        stagingRepository.setId(repository.getId() + STAGE_REPO_ID_END);
        stagingRepository.setLayout(repository.getLayout());
        stagingRepository.setName(repository.getName() + STAGE_REPO_ID_END);
        stagingRepository.setBlockRedeployments(repository.isBlockRedeployments());
        stagingRepository.setDaysOlder(repository.getDaysOlder());
        stagingRepository.setDeleteReleasedSnapshots(repository.isDeleteReleasedSnapshots());
        String path = repository.getLocation();
        int lastIndex = path.replace('\\', '/').lastIndexOf(47);
        stagingRepository.setLocation(path.substring(0, lastIndex) + "/" + stagingRepository.getId());
        if (StringUtils.isNotBlank((String)repository.getIndexDir())) {
            File indexDir = new File(repository.getIndexDir());
            if (indexDir.isAbsolute()) {
                stagingRepository.setIndexDir(stagingRepository.getLocation() + "/.index");
            } else {
                stagingRepository.setIndexDir(repository.getIndexDir());
            }
        }
        stagingRepository.setRefreshCronExpression(repository.getRefreshCronExpression());
        stagingRepository.setReleases(repository.isReleases());
        stagingRepository.setRetentionCount(repository.getRetentionCount());
        stagingRepository.setScanned(repository.isScanned());
        stagingRepository.setSnapshots(repository.isSnapshots());
        stagingRepository.setSkipPackedIndexCreation(repository.isSkipPackedIndexCreation());
        return stagingRepository;
    }

    public Boolean scanRepository(String repositoryId, boolean fullScan) {
        if (this.getRepositoryTaskScheduler().isProcessingRepositoryTask(repositoryId)) {
            this.log.info("scanning of repository with id {} already scheduled", (Object)repositoryId);
        }
        RepositoryTask task = new RepositoryTask();
        task.setRepositoryId(repositoryId);
        task.setScanAll(fullScan);
        try {
            this.getRepositoryTaskScheduler().queueTask(task);
        }
        catch (TaskQueueException e) {
            this.log.error("failed to schedule scanning of repo with id {}", (Object)repositoryId, (Object)e);
            return false;
        }
        return true;
    }

    private void addRepositoryRoles(String repoId) throws RoleManagerException {
        if (!this.getRoleManager().templatedRoleExists("archiva-repository-observer", repoId)) {
            this.getRoleManager().createTemplatedRole("archiva-repository-observer", repoId);
        }
        if (!this.getRoleManager().templatedRoleExists("archiva-repository-manager", repoId)) {
            this.getRoleManager().createTemplatedRole("archiva-repository-manager", repoId);
        }
    }

    protected void removeRepositoryRoles(ManagedRepositoryConfiguration existingRepository) throws RoleManagerException {
        String repoId = existingRepository.getId();
        if (this.getRoleManager().templatedRoleExists("archiva-repository-manager", repoId)) {
            this.getRoleManager().removeTemplatedRole("archiva-repository-manager", repoId);
        }
        if (this.getRoleManager().templatedRoleExists("archiva-repository-observer", repoId)) {
            this.getRoleManager().removeTemplatedRole("archiva-repository-observer", repoId);
        }
        this.log.debug("removed user roles associated with repository {}", (Object)repoId);
    }

    public RoleManager getRoleManager() {
        return this.roleManager;
    }

    public void setRoleManager(RoleManager roleManager) {
        this.roleManager = roleManager;
    }

    public RepositoryStatisticsManager getRepositoryStatisticsManager() {
        return this.repositoryStatisticsManager;
    }

    public void setRepositoryStatisticsManager(RepositoryStatisticsManager repositoryStatisticsManager) {
        this.repositoryStatisticsManager = repositoryStatisticsManager;
    }

    public RepositorySessionFactory getRepositorySessionFactory() {
        return this.repositorySessionFactory;
    }

    public void setRepositorySessionFactory(RepositorySessionFactory repositorySessionFactory) {
        this.repositorySessionFactory = repositorySessionFactory;
    }

    public RepositoryArchivaTaskScheduler getRepositoryTaskScheduler() {
        return this.repositoryTaskScheduler;
    }

    public void setRepositoryTaskScheduler(RepositoryArchivaTaskScheduler repositoryTaskScheduler) {
        this.repositoryTaskScheduler = repositoryTaskScheduler;
    }

    public PlexusSisuBridge getPlexusSisuBridge() {
        return this.plexusSisuBridge;
    }

    public void setPlexusSisuBridge(PlexusSisuBridge plexusSisuBridge) {
        this.plexusSisuBridge = plexusSisuBridge;
    }

    public MavenIndexerUtils getMavenIndexerUtils() {
        return this.mavenIndexerUtils;
    }

    public void setMavenIndexerUtils(MavenIndexerUtils mavenIndexerUtils) {
        this.mavenIndexerUtils = mavenIndexerUtils;
    }

    public NexusIndexer getIndexer() {
        return this.indexer;
    }

    public void setIndexer(NexusIndexer indexer) {
        this.indexer = indexer;
    }

    public List<? extends IndexCreator> getIndexCreators() {
        return this.indexCreators;
    }

    public void setIndexCreators(List<? extends IndexCreator> indexCreators) {
        this.indexCreators = indexCreators;
    }
}

