/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.admin.repository.proxyconnectorrule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.archiva.admin.model.AuditInformation;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.ProxyConnector;
import org.apache.archiva.admin.model.beans.ProxyConnectorRule;
import org.apache.archiva.admin.model.beans.ProxyConnectorRuleType;
import org.apache.archiva.admin.model.proxyconnectorrule.ProxyConnectorRuleAdmin;
import org.apache.archiva.admin.repository.AbstractRepositoryAdmin;
import org.apache.archiva.configuration.Configuration;
import org.apache.archiva.configuration.ProxyConnectorConfiguration;
import org.apache.archiva.configuration.ProxyConnectorRuleConfiguration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="proxyConnectorRuleAdmin#default")
public class DefaultProxyConnectorRuleAdmin
extends AbstractRepositoryAdmin
implements ProxyConnectorRuleAdmin {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public List<ProxyConnectorRule> getProxyConnectorRules() throws RepositoryAdminException {
        List proxyConnectorRuleConfigurations = this.getArchivaConfiguration().getConfiguration().getProxyConnectorRuleConfigurations();
        if (proxyConnectorRuleConfigurations.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ProxyConnectorRule> proxyConnectorRules = new ArrayList<ProxyConnectorRule>(proxyConnectorRuleConfigurations.size());
        for (ProxyConnectorRuleConfiguration proxyConnectorRuleConfiguration : proxyConnectorRuleConfigurations) {
            ProxyConnectorRule proxyConnectorRule = new ProxyConnectorRule();
            proxyConnectorRule.setPattern(proxyConnectorRuleConfiguration.getPattern());
            proxyConnectorRule.setProxyConnectorRuleType(this.getProxyConnectorRuleType(proxyConnectorRuleConfiguration.getRuleType()));
            for (ProxyConnectorConfiguration proxyConnectorConfiguration : proxyConnectorRuleConfiguration.getProxyConnectors()) {
                ProxyConnector proxyConnector = new ProxyConnector();
                proxyConnector.setSourceRepoId(proxyConnectorConfiguration.getSourceRepoId());
                proxyConnector.setTargetRepoId(proxyConnectorConfiguration.getTargetRepoId());
                proxyConnectorRule.getProxyConnectors().add(proxyConnector);
            }
            proxyConnectorRules.add(proxyConnectorRule);
        }
        return proxyConnectorRules;
    }

    private ProxyConnectorRuleType getProxyConnectorRuleType(String type) {
        if (StringUtils.equals((String)ProxyConnectorRuleType.WHITE_LIST.getRuleType(), (String)type)) {
            return ProxyConnectorRuleType.WHITE_LIST;
        }
        if (StringUtils.equals((String)ProxyConnectorRuleType.BLACK_LIST.getRuleType(), (String)type)) {
            return ProxyConnectorRuleType.BLACK_LIST;
        }
        return null;
    }

    public void addProxyConnectorRule(ProxyConnectorRule proxyConnectorRule, AuditInformation auditInformation) throws RepositoryAdminException {
        ProxyConnectorRuleConfiguration proxyConnectorRuleConfiguration = new ProxyConnectorRuleConfiguration();
        proxyConnectorRuleConfiguration.setPattern(proxyConnectorRule.getPattern());
        proxyConnectorRuleConfiguration.setRuleType(proxyConnectorRule.getProxyConnectorRuleType().getRuleType());
        for (ProxyConnector proxyConnector : proxyConnectorRule.getProxyConnectors()) {
            ProxyConnectorConfiguration proxyConnectorConfiguration = new ProxyConnectorConfiguration();
            proxyConnectorConfiguration.setSourceRepoId(proxyConnector.getSourceRepoId());
            proxyConnectorConfiguration.setTargetRepoId(proxyConnector.getTargetRepoId());
            proxyConnectorRuleConfiguration.getProxyConnectors().add(proxyConnectorConfiguration);
        }
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        configuration.getProxyConnectorRuleConfigurations().add(proxyConnectorRuleConfiguration);
        this.saveConfiguration(configuration);
    }

    public void deleteProxyConnectorRule(ProxyConnectorRule proxyConnectorRule, AuditInformation auditInformation) throws RepositoryAdminException {
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        boolean toSave = false;
        ArrayList<ProxyConnectorRuleConfiguration> proxyConnectorRuleConfigurations = new ArrayList<ProxyConnectorRuleConfiguration>();
        for (ProxyConnectorRuleConfiguration proxyConnectorRuleConfiguration : configuration.getProxyConnectorRuleConfigurations()) {
            if (StringUtils.equals((String)proxyConnectorRuleConfiguration.getPattern(), (String)proxyConnectorRule.getPattern()) && StringUtils.equals((String)proxyConnectorRuleConfiguration.getRuleType(), (String)proxyConnectorRule.getProxyConnectorRuleType().getRuleType())) {
                toSave = true;
                continue;
            }
            proxyConnectorRuleConfigurations.add(proxyConnectorRuleConfiguration);
        }
        if (toSave) {
            configuration.setProxyConnectorRuleConfigurations(proxyConnectorRuleConfigurations);
            this.saveConfiguration(configuration);
        }
    }

    public void updateProxyConnectorRule(ProxyConnectorRule proxyConnectorRule, AuditInformation auditInformation) throws RepositoryAdminException {
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        for (ProxyConnectorRuleConfiguration proxyConnectorRuleConfiguration : configuration.getProxyConnectorRuleConfigurations()) {
            if (!StringUtils.equals((String)proxyConnectorRuleConfiguration.getPattern(), (String)proxyConnectorRule.getPattern()) || !StringUtils.equals((String)proxyConnectorRuleConfiguration.getRuleType(), (String)proxyConnectorRule.getProxyConnectorRuleType().getRuleType())) continue;
            ArrayList<ProxyConnectorConfiguration> proxyConnectors = new ArrayList<ProxyConnectorConfiguration>(proxyConnectorRule.getProxyConnectors().size());
            for (ProxyConnector proxyConnector : proxyConnectorRule.getProxyConnectors()) {
                ProxyConnectorConfiguration proxyConnectorConfiguration = new ProxyConnectorConfiguration();
                proxyConnectorConfiguration.setSourceRepoId(proxyConnector.getSourceRepoId());
                proxyConnectorConfiguration.setTargetRepoId(proxyConnector.getTargetRepoId());
                proxyConnectors.add(proxyConnectorConfiguration);
            }
            proxyConnectorRuleConfiguration.setProxyConnectors(proxyConnectors);
            this.saveConfiguration(configuration);
        }
    }
}

