/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.admin.repository.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.LdapConfiguration;
import org.apache.archiva.admin.model.beans.RedbackRuntimeConfiguration;
import org.apache.archiva.admin.model.runtime.RedbackRuntimeConfigurationAdmin;
import org.apache.archiva.admin.repository.AbstractRepositoryAdmin;
import org.apache.archiva.configuration.ArchivaConfiguration;
import org.apache.archiva.configuration.CacheConfiguration;
import org.apache.archiva.configuration.Configuration;
import org.apache.archiva.configuration.IndeterminateConfigurationException;
import org.apache.archiva.configuration.LdapGroupMapping;
import org.apache.archiva.redback.components.cache.Cache;
import org.apache.archiva.redback.components.registry.RegistryException;
import org.apache.archiva.redback.configuration.UserConfiguration;
import org.apache.archiva.redback.configuration.UserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="redbackRuntimeConfigurationAdmin#default")
public class DefaultRedbackRuntimeConfigurationAdmin
extends AbstractRepositoryAdmin
implements RedbackRuntimeConfigurationAdmin,
UserConfiguration {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private ArchivaConfiguration archivaConfiguration;
    private UserConfiguration userConfiguration;
    private Cache usersCache;

    @Inject
    public DefaultRedbackRuntimeConfigurationAdmin(ArchivaConfiguration archivaConfiguration, @Named(value="userConfiguration#redback") UserConfiguration userConfiguration, @Named(value="cache#users") Cache usersCache) {
        this.archivaConfiguration = archivaConfiguration;
        this.userConfiguration = userConfiguration;
        this.usersCache = usersCache;
    }

    @PostConstruct
    public void initialize() throws UserConfigurationException {
        try {
            RedbackRuntimeConfiguration redbackRuntimeConfiguration = this.getRedbackRuntimeConfiguration();
            if (!redbackRuntimeConfiguration.isMigratedFromRedbackConfiguration()) {
                LdapConfiguration ldapConfiguration;
                String rbacManagerImpls;
                redbackRuntimeConfiguration = new RedbackRuntimeConfiguration();
                String userManagerImpl = this.userConfiguration.getConcatenatedList("user.manager.impl", "jdo");
                if (StringUtils.isNotEmpty((String)userManagerImpl)) {
                    String[] impls;
                    for (String impl : impls = StringUtils.split((String)userManagerImpl, (char)',')) {
                        redbackRuntimeConfiguration.getUserManagerImpls().add(impl);
                    }
                }
                if (StringUtils.isNotEmpty((String)(rbacManagerImpls = this.userConfiguration.getConcatenatedList("rbac.manager.impl", "jdo")))) {
                    String[] impls;
                    for (String impl : impls = StringUtils.split((String)rbacManagerImpls, (char)',')) {
                        redbackRuntimeConfiguration.getRbacManagerImpls().add(impl);
                    }
                }
                if ((ldapConfiguration = redbackRuntimeConfiguration.getLdapConfiguration()) == null) {
                    ldapConfiguration = new LdapConfiguration();
                    redbackRuntimeConfiguration.setLdapConfiguration(ldapConfiguration);
                }
                ldapConfiguration.setHostName(this.userConfiguration.getString("ldap.config.hostname", null));
                ldapConfiguration.setPort(this.userConfiguration.getInt("ldap.config.port", -1));
                ldapConfiguration.setSsl(this.userConfiguration.getBoolean("ldap.config.ssl", false));
                ldapConfiguration.setBaseDn(this.userConfiguration.getConcatenatedList("ldap.config.base.dn", null));
                ldapConfiguration.setBaseGroupsDn(this.userConfiguration.getConcatenatedList("ldap.config.groups.base.dn", ldapConfiguration.getBaseDn()));
                ldapConfiguration.setContextFactory(this.userConfiguration.getString("ldap.config.context.factory", this.isSunContextFactoryAvailable() ? "com.sun.jndi.ldap.LdapCtxFactory" : ""));
                ldapConfiguration.setBindDn(this.userConfiguration.getConcatenatedList("ldap.config.bind.dn", null));
                ldapConfiguration.setPassword(this.userConfiguration.getString("ldap.config.password", null));
                ldapConfiguration.setAuthenticationMethod(this.userConfiguration.getString("ldap.config.authentication.method", null));
                ldapConfiguration.setWritable(this.userConfiguration.getBoolean("ldap.config.writable", false));
                ldapConfiguration.setUseRoleNameAsGroup(this.userConfiguration.getBoolean("ldap.config.groups.use.rolename", false));
                boolean ldapBindAuthenticatorEnabled = this.userConfiguration.getBoolean("ldap.bind.authenticator.enabled", false);
                ldapConfiguration.setBindAuthenticatorEnabled(ldapBindAuthenticatorEnabled);
                Collection keys = this.userConfiguration.getKeys();
                ArrayList<org.apache.archiva.admin.model.beans.LdapGroupMapping> ldapGroupMappings = new ArrayList<org.apache.archiva.admin.model.beans.LdapGroupMapping>();
                for (String key : keys) {
                    if (!key.startsWith("ldap.config.groups.role.")) continue;
                    String group = StringUtils.substringAfter((String)key, (String)"ldap.config.groups.role.");
                    String val = this.userConfiguration.getConcatenatedList(key, "");
                    if (StringUtils.isEmpty((String)val)) continue;
                    String[] roles = StringUtils.split((String)val, (char)',');
                    ldapGroupMappings.add(new org.apache.archiva.admin.model.beans.LdapGroupMapping(group, roles));
                }
                redbackRuntimeConfiguration.setLdapGroupMappings(ldapGroupMappings);
                redbackRuntimeConfiguration.setMigratedFromRedbackConfiguration(true);
                this.updateRedbackRuntimeConfiguration(redbackRuntimeConfiguration);
            }
            if (redbackRuntimeConfiguration.getUserManagerImpls().isEmpty()) {
                this.log.info("redbackRuntimeConfiguration with empty userManagerImpls so force at least jdo implementation !");
                redbackRuntimeConfiguration.getUserManagerImpls().add("jdo");
                this.updateRedbackRuntimeConfiguration(redbackRuntimeConfiguration);
            }
            if (redbackRuntimeConfiguration.getRbacManagerImpls().isEmpty()) {
                this.log.info("redbackRuntimeConfiguration with empty rbacManagerImpls so force at least cached implementation !");
                redbackRuntimeConfiguration.getRbacManagerImpls().add("cached");
                this.updateRedbackRuntimeConfiguration(redbackRuntimeConfiguration);
            }
            boolean save = false;
            if (redbackRuntimeConfiguration.getUsersCacheConfiguration() == null) {
                redbackRuntimeConfiguration.setUsersCacheConfiguration(new org.apache.archiva.admin.model.beans.CacheConfiguration());
            }
            if (redbackRuntimeConfiguration.getUsersCacheConfiguration().getTimeToIdleSeconds() < 0) {
                redbackRuntimeConfiguration.getUsersCacheConfiguration().setTimeToIdleSeconds(this.usersCache.getTimeToIdleSeconds());
                save = true;
            }
            this.usersCache.setTimeToIdleSeconds(redbackRuntimeConfiguration.getUsersCacheConfiguration().getTimeToIdleSeconds());
            if (redbackRuntimeConfiguration.getUsersCacheConfiguration().getTimeToLiveSeconds() < 0) {
                redbackRuntimeConfiguration.getUsersCacheConfiguration().setTimeToLiveSeconds(this.usersCache.getTimeToLiveSeconds());
                save = true;
            }
            this.usersCache.setTimeToLiveSeconds(redbackRuntimeConfiguration.getUsersCacheConfiguration().getTimeToLiveSeconds());
            if (redbackRuntimeConfiguration.getUsersCacheConfiguration().getMaxElementsInMemory() < 0) {
                redbackRuntimeConfiguration.getUsersCacheConfiguration().setMaxElementsInMemory(this.usersCache.getMaxElementsInMemory());
                save = true;
            }
            this.usersCache.setMaxElementsInMemory(redbackRuntimeConfiguration.getUsersCacheConfiguration().getMaxElementsInMemory());
            if (redbackRuntimeConfiguration.getUsersCacheConfiguration().getMaxElementsOnDisk() < 0) {
                redbackRuntimeConfiguration.getUsersCacheConfiguration().setMaxElementsOnDisk(this.usersCache.getMaxElementsOnDisk());
                save = true;
            }
            this.usersCache.setMaxElementsOnDisk(redbackRuntimeConfiguration.getUsersCacheConfiguration().getMaxElementsOnDisk());
            if (save) {
                this.updateRedbackRuntimeConfiguration(redbackRuntimeConfiguration);
            }
        }
        catch (RepositoryAdminException e) {
            throw new UserConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean isSunContextFactoryAvailable() {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass("com.sun.jndi.ldap.LdapCtxFactory") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public RedbackRuntimeConfiguration getRedbackRuntimeConfiguration() {
        return this.build(this.archivaConfiguration.getConfiguration().getRedbackRuntimeConfiguration());
    }

    public void updateRedbackRuntimeConfiguration(RedbackRuntimeConfiguration redbackRuntimeConfiguration) throws RepositoryAdminException {
        org.apache.archiva.configuration.RedbackRuntimeConfiguration runtimeConfiguration = this.build(redbackRuntimeConfiguration);
        Configuration configuration = this.archivaConfiguration.getConfiguration();
        configuration.setRedbackRuntimeConfiguration(runtimeConfiguration);
        try {
            this.archivaConfiguration.save(configuration);
        }
        catch (RegistryException e) {
            throw new RepositoryAdminException(e.getMessage(), (Throwable)e);
        }
        catch (IndeterminateConfigurationException e) {
            throw new RepositoryAdminException(e.getMessage(), (Throwable)e);
        }
    }

    private RedbackRuntimeConfiguration build(org.apache.archiva.configuration.RedbackRuntimeConfiguration runtimeConfiguration) {
        List mappings;
        RedbackRuntimeConfiguration redbackRuntimeConfiguration = (RedbackRuntimeConfiguration)this.getModelMapper().map((Object)runtimeConfiguration, RedbackRuntimeConfiguration.class);
        if (runtimeConfiguration.getLdapConfiguration() != null) {
            redbackRuntimeConfiguration.setLdapConfiguration((LdapConfiguration)this.getModelMapper().map((Object)runtimeConfiguration.getLdapConfiguration(), LdapConfiguration.class));
        }
        if (runtimeConfiguration.getUsersCacheConfiguration() != null) {
            redbackRuntimeConfiguration.setUsersCacheConfiguration((org.apache.archiva.admin.model.beans.CacheConfiguration)this.getModelMapper().map((Object)runtimeConfiguration.getUsersCacheConfiguration(), org.apache.archiva.admin.model.beans.CacheConfiguration.class));
        }
        if (redbackRuntimeConfiguration.getLdapConfiguration() == null) {
            redbackRuntimeConfiguration.setLdapConfiguration(new LdapConfiguration());
        }
        if (redbackRuntimeConfiguration.getUsersCacheConfiguration() == null) {
            redbackRuntimeConfiguration.setUsersCacheConfiguration(new org.apache.archiva.admin.model.beans.CacheConfiguration());
        }
        if ((mappings = runtimeConfiguration.getLdapGroupMappings()) != null && mappings.size() > 0) {
            ArrayList<org.apache.archiva.admin.model.beans.LdapGroupMapping> ldapGroupMappings = new ArrayList<org.apache.archiva.admin.model.beans.LdapGroupMapping>(mappings.size());
            for (LdapGroupMapping mapping : mappings) {
                ldapGroupMappings.add(new org.apache.archiva.admin.model.beans.LdapGroupMapping(mapping.getGroup(), (Collection)mapping.getRoleNames()));
            }
            redbackRuntimeConfiguration.setLdapGroupMappings(ldapGroupMappings);
        }
        this.cleanupProperties(redbackRuntimeConfiguration);
        return redbackRuntimeConfiguration;
    }

    private void cleanupProperties(RedbackRuntimeConfiguration redbackRuntimeConfiguration) {
        Map properties = redbackRuntimeConfiguration.getConfigurationProperties();
        properties.remove("ldap.config.hostname");
        properties.remove("ldap.config.port");
        properties.remove("ldap.bind.authenticator.enabled");
        properties.remove("ldap.config.ssl");
        properties.remove("ldap.config.base.dn");
        properties.remove("ldap.config.groups.base.dn");
        properties.remove("ldap.config.context.factory");
        properties.remove("ldap.config.bind.dn");
        properties.remove("ldap.config.password");
        properties.remove("ldap.config.authentication.method");
        properties.remove("ldap.config.writable");
        properties.remove("ldap.config.groups.use.rolename");
    }

    private org.apache.archiva.configuration.RedbackRuntimeConfiguration build(RedbackRuntimeConfiguration redbackRuntimeConfiguration) {
        org.apache.archiva.configuration.RedbackRuntimeConfiguration res = (org.apache.archiva.configuration.RedbackRuntimeConfiguration)this.getModelMapper().map((Object)redbackRuntimeConfiguration, org.apache.archiva.configuration.RedbackRuntimeConfiguration.class);
        if (redbackRuntimeConfiguration.getLdapConfiguration() == null) {
            redbackRuntimeConfiguration.setLdapConfiguration(new LdapConfiguration());
        }
        res.setLdapConfiguration((org.apache.archiva.configuration.LdapConfiguration)this.getModelMapper().map((Object)redbackRuntimeConfiguration.getLdapConfiguration(), org.apache.archiva.configuration.LdapConfiguration.class));
        if (redbackRuntimeConfiguration.getUsersCacheConfiguration() == null) {
            redbackRuntimeConfiguration.setUsersCacheConfiguration(new org.apache.archiva.admin.model.beans.CacheConfiguration());
        }
        res.setUsersCacheConfiguration((CacheConfiguration)this.getModelMapper().map((Object)redbackRuntimeConfiguration.getUsersCacheConfiguration(), CacheConfiguration.class));
        List ldapGroupMappings = redbackRuntimeConfiguration.getLdapGroupMappings();
        if (ldapGroupMappings != null && ldapGroupMappings.size() > 0) {
            ArrayList<LdapGroupMapping> mappings = new ArrayList<LdapGroupMapping>(ldapGroupMappings.size());
            for (org.apache.archiva.admin.model.beans.LdapGroupMapping ldapGroupMapping : ldapGroupMappings) {
                LdapGroupMapping mapping = new LdapGroupMapping();
                mapping.setGroup(ldapGroupMapping.getGroup());
                mapping.setRoleNames(new ArrayList(ldapGroupMapping.getRoleNames()));
                mappings.add(mapping);
            }
            res.setLdapGroupMappings(mappings);
        }
        return res;
    }

    public String getString(String key) {
        RedbackRuntimeConfiguration redbackRuntimeConfiguration;
        int index;
        if ("user.manager.impl".equals(key)) {
            return (String)this.getRedbackRuntimeConfiguration().getUserManagerImpls().get(0);
        }
        if (StringUtils.startsWith((String)key, (String)"ldap.config.groups.role.") && (index = (redbackRuntimeConfiguration = this.getRedbackRuntimeConfiguration()).getLdapGroupMappings().indexOf(new org.apache.archiva.admin.model.beans.LdapGroupMapping(StringUtils.substringAfter((String)key, (String)"ldap.config.groups.role.")))) > -1) {
            return StringUtils.join((Collection)((org.apache.archiva.admin.model.beans.LdapGroupMapping)redbackRuntimeConfiguration.getLdapGroupMappings().get(index)).getRoleNames(), (char)',');
        }
        RedbackRuntimeConfiguration conf = this.getRedbackRuntimeConfiguration();
        if (conf.getConfigurationProperties().containsKey(key)) {
            return (String)conf.getConfigurationProperties().get(key);
        }
        String value = this.userConfiguration.getString(key);
        if (value == null) {
            return null;
        }
        conf.getConfigurationProperties().put(key, value);
        try {
            this.updateRedbackRuntimeConfiguration(conf);
        }
        catch (RepositoryAdminException e) {
            this.log.error("fail to save RedbackRuntimeConfiguration: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        return value;
    }

    public String getString(String key, String defaultValue) {
        if ("ldap.config.hostname".equals(key)) {
            return this.getRedbackRuntimeConfiguration().getLdapConfiguration().getHostName();
        }
        if ("ldap.config.context.factory".equals(key)) {
            return this.getRedbackRuntimeConfiguration().getLdapConfiguration().getContextFactory();
        }
        if ("ldap.config.password".equals(key)) {
            return this.getRedbackRuntimeConfiguration().getLdapConfiguration().getPassword();
        }
        if ("ldap.config.authentication.method".equals(key)) {
            return this.getRedbackRuntimeConfiguration().getLdapConfiguration().getAuthenticationMethod();
        }
        RedbackRuntimeConfiguration conf = this.getRedbackRuntimeConfiguration();
        if (conf.getConfigurationProperties().containsKey(key)) {
            return (String)conf.getConfigurationProperties().get(key);
        }
        String value = this.userConfiguration.getString(key, defaultValue);
        if (value == null) {
            return null;
        }
        conf.getConfigurationProperties().put(key, value);
        try {
            this.updateRedbackRuntimeConfiguration(conf);
        }
        catch (RepositoryAdminException e) {
            this.log.error("fail to save RedbackRuntimeConfiguration: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        return value;
    }

    public int getInt(String key) {
        RedbackRuntimeConfiguration conf = this.getRedbackRuntimeConfiguration();
        if (conf.getConfigurationProperties().containsKey(key)) {
            return Integer.valueOf((String)conf.getConfigurationProperties().get(key));
        }
        int value = this.userConfiguration.getInt(key);
        conf.getConfigurationProperties().put(key, Integer.toString(value));
        try {
            this.updateRedbackRuntimeConfiguration(conf);
        }
        catch (RepositoryAdminException e) {
            this.log.error("fail to save RedbackRuntimeConfiguration: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        return value;
    }

    public int getInt(String key, int defaultValue) {
        if ("ldap.config.port".equals(key)) {
            return this.getRedbackRuntimeConfiguration().getLdapConfiguration().getPort();
        }
        RedbackRuntimeConfiguration conf = this.getRedbackRuntimeConfiguration();
        if (conf.getConfigurationProperties().containsKey(key)) {
            return Integer.valueOf((String)conf.getConfigurationProperties().get(key));
        }
        int value = this.userConfiguration.getInt(key, defaultValue);
        conf.getConfigurationProperties().put(key, Integer.toString(value));
        try {
            this.updateRedbackRuntimeConfiguration(conf);
        }
        catch (RepositoryAdminException e) {
            this.log.error("fail to save RedbackRuntimeConfiguration: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        return value;
    }

    public boolean getBoolean(String key) {
        RedbackRuntimeConfiguration conf = this.getRedbackRuntimeConfiguration();
        if ("ldap.config.writable".equals(key)) {
            return conf.getLdapConfiguration().isWritable();
        }
        if ("ldap.config.groups.use.rolename".equals(key)) {
            return conf.getLdapConfiguration().isUseRoleNameAsGroup();
        }
        if ("ldap.bind.authenticator.enabled".equals(key)) {
            return conf.getLdapConfiguration().isBindAuthenticatorEnabled();
        }
        if (conf.getConfigurationProperties().containsKey(key)) {
            return Boolean.valueOf((String)conf.getConfigurationProperties().get(key));
        }
        boolean value = this.userConfiguration.getBoolean(key);
        conf.getConfigurationProperties().put(key, Boolean.toString(value));
        try {
            this.updateRedbackRuntimeConfiguration(conf);
        }
        catch (RepositoryAdminException e) {
            this.log.error("fail to save RedbackRuntimeConfiguration: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        return value;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        if ("ldap.config.ssl".equals(key)) {
            return this.getRedbackRuntimeConfiguration().getLdapConfiguration().isSsl();
        }
        if ("ldap.config.writable".equals(key)) {
            return this.getRedbackRuntimeConfiguration().getLdapConfiguration().isWritable();
        }
        if ("ldap.config.groups.use.rolename".equals(key)) {
            return this.getRedbackRuntimeConfiguration().getLdapConfiguration().isUseRoleNameAsGroup();
        }
        if ("ldap.bind.authenticator.enabled".equals(key)) {
            return this.getRedbackRuntimeConfiguration().getLdapConfiguration().isBindAuthenticatorEnabled();
        }
        RedbackRuntimeConfiguration conf = this.getRedbackRuntimeConfiguration();
        if (conf.getConfigurationProperties().containsKey(key)) {
            return Boolean.valueOf((String)conf.getConfigurationProperties().get(key));
        }
        boolean value = this.userConfiguration.getBoolean(key, defaultValue);
        conf.getConfigurationProperties().put(key, Boolean.toString(value));
        try {
            this.updateRedbackRuntimeConfiguration(conf);
        }
        catch (RepositoryAdminException e) {
            this.log.error("fail to save RedbackRuntimeConfiguration: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        return value;
    }

    public List<String> getList(String key) {
        List value = this.userConfiguration.getList(key);
        RedbackRuntimeConfiguration conf = this.getRedbackRuntimeConfiguration();
        conf.getConfigurationProperties().put(key, "");
        try {
            this.updateRedbackRuntimeConfiguration(conf);
        }
        catch (RepositoryAdminException e) {
            this.log.error("fail to save RedbackRuntimeConfiguration: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        return value;
    }

    public String getConcatenatedList(String key, String defaultValue) {
        if ("ldap.config.base.dn".equals(key)) {
            return this.getRedbackRuntimeConfiguration().getLdapConfiguration().getBaseDn();
        }
        if ("ldap.config.bind.dn".equals(key)) {
            return this.getRedbackRuntimeConfiguration().getLdapConfiguration().getBindDn();
        }
        if ("ldap.config.groups.base.dn".equals(key)) {
            return this.getRedbackRuntimeConfiguration().getLdapConfiguration().getBaseGroupsDn();
        }
        return this.userConfiguration.getConcatenatedList(key, defaultValue);
    }

    public Collection<String> getKeys() {
        Collection keys = this.userConfiguration.getKeys();
        HashSet<String> keysSet = new HashSet<String>(keys);
        keysSet.addAll(this.getRedbackRuntimeConfiguration().getConfigurationProperties().keySet());
        return keysSet;
    }
}

