/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.admin.repository.proxyconnector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.archiva.admin.model.AuditInformation;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.ProxyConnector;
import org.apache.archiva.admin.model.managed.ManagedRepositoryAdmin;
import org.apache.archiva.admin.model.proxyconnector.ProxyConnectorAdmin;
import org.apache.archiva.admin.model.proxyconnector.ProxyConnectorOrderComparator;
import org.apache.archiva.admin.model.remote.RemoteRepositoryAdmin;
import org.apache.archiva.admin.repository.AbstractRepositoryAdmin;
import org.apache.archiva.configuration.Configuration;
import org.apache.archiva.configuration.ProxyConnectorConfiguration;
import org.apache.archiva.configuration.functors.ProxyConnectorSelectionPredicate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="proxyConnectorAdmin#default")
public class DefaultProxyConnectorAdmin
extends AbstractRepositoryAdmin
implements ProxyConnectorAdmin {
    @Inject
    private ManagedRepositoryAdmin managedRepositoryAdmin;
    @Inject
    private RemoteRepositoryAdmin remoteRepositoryAdmin;

    public List<ProxyConnector> getProxyConnectors() throws RepositoryAdminException {
        List proxyConnectorConfigurations = this.getArchivaConfiguration().getConfiguration().getProxyConnectors();
        ArrayList<ProxyConnector> proxyConnectors = new ArrayList<ProxyConnector>(proxyConnectorConfigurations.size());
        for (ProxyConnectorConfiguration configuration : proxyConnectorConfigurations) {
            proxyConnectors.add(this.getProxyConnector(configuration));
        }
        Collections.sort(proxyConnectors, ProxyConnectorOrderComparator.getInstance());
        return proxyConnectors;
    }

    public ProxyConnector getProxyConnector(String sourceRepoId, String targetRepoId) throws RepositoryAdminException {
        for (ProxyConnector proxyConnector : this.getProxyConnectors()) {
            if (!StringUtils.equals((String)sourceRepoId, (String)proxyConnector.getSourceRepoId()) || !StringUtils.equals((String)targetRepoId, (String)proxyConnector.getTargetRepoId())) continue;
            return proxyConnector;
        }
        return null;
    }

    public Boolean addProxyConnector(ProxyConnector proxyConnector, AuditInformation auditInformation) throws RepositoryAdminException {
        if (this.getProxyConnector(proxyConnector.getSourceRepoId(), proxyConnector.getTargetRepoId()) != null) {
            throw new RepositoryAdminException("Unable to add proxy connector, as one already exists with source repository id [" + proxyConnector.getSourceRepoId() + "] and target repository id [" + proxyConnector.getTargetRepoId() + "].");
        }
        this.validateProxyConnector(proxyConnector);
        proxyConnector.setBlackListPatterns(this.unescapePatterns(proxyConnector.getBlackListPatterns()));
        proxyConnector.setWhiteListPatterns(this.unescapePatterns(proxyConnector.getWhiteListPatterns()));
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        ProxyConnectorConfiguration proxyConnectorConfiguration = this.getProxyConnectorConfiguration(proxyConnector);
        configuration.addProxyConnector(proxyConnectorConfiguration);
        this.saveConfiguration(configuration);
        this.triggerAuditEvent(proxyConnector.getSourceRepoId() + "-" + proxyConnector.getTargetRepoId(), null, "Added Proxy Connector", auditInformation);
        return Boolean.TRUE;
    }

    public Boolean deleteProxyConnector(ProxyConnector proxyConnector, AuditInformation auditInformation) throws RepositoryAdminException {
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        ProxyConnectorConfiguration proxyConnectorConfiguration = this.findProxyConnector(proxyConnector.getSourceRepoId(), proxyConnector.getTargetRepoId(), configuration);
        if (proxyConnectorConfiguration == null) {
            throw new RepositoryAdminException("unable to find ProxyConnector with source " + proxyConnector.getSourceRepoId() + " and target " + proxyConnector.getTargetRepoId());
        }
        configuration.removeProxyConnector(proxyConnectorConfiguration);
        this.saveConfiguration(configuration);
        this.triggerAuditEvent(proxyConnector.getSourceRepoId() + "-" + proxyConnector.getTargetRepoId(), null, "Deleted Proxy Connector", auditInformation);
        return Boolean.TRUE;
    }

    public Boolean updateProxyConnector(ProxyConnector proxyConnector, AuditInformation auditInformation) throws RepositoryAdminException {
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        ProxyConnectorConfiguration proxyConnectorConfiguration = this.findProxyConnector(proxyConnector.getSourceRepoId(), proxyConnector.getTargetRepoId(), configuration);
        configuration.removeProxyConnector(proxyConnectorConfiguration);
        configuration.addProxyConnector(this.getProxyConnectorConfiguration(proxyConnector));
        this.saveConfiguration(configuration);
        this.triggerAuditEvent(proxyConnector.getSourceRepoId() + "-" + proxyConnector.getTargetRepoId(), null, "Updated Proxy Connector", auditInformation);
        return Boolean.TRUE;
    }

    protected List<String> unescapePatterns(List<String> patterns) {
        if (patterns != null) {
            ArrayList<String> rawPatterns = new ArrayList<String>(patterns.size());
            for (String pattern : patterns) {
                rawPatterns.add(StringUtils.replace((String)pattern, (String)"\\\\", (String)"\\"));
            }
            return rawPatterns;
        }
        return Collections.emptyList();
    }

    public Map<String, List<ProxyConnector>> getProxyConnectorAsMap() throws RepositoryAdminException {
        HashMap<String, List<ProxyConnector>> proxyConnectorMap = new HashMap<String, List<ProxyConnector>>();
        for (ProxyConnector proxyConfig : this.getProxyConnectors()) {
            String key = proxyConfig.getSourceRepoId();
            ArrayList<ProxyConnector> connectors = (ArrayList<ProxyConnector>)proxyConnectorMap.get(key);
            if (connectors == null) {
                connectors = new ArrayList<ProxyConnector>(1);
                proxyConnectorMap.put(key, connectors);
            }
            connectors.add(proxyConfig);
            Collections.sort(connectors, ProxyConnectorOrderComparator.getInstance());
        }
        return proxyConnectorMap;
    }

    private ProxyConnectorConfiguration findProxyConnector(String sourceId, String targetId, Configuration configuration) {
        if (StringUtils.isBlank((String)sourceId)) {
            return null;
        }
        if (StringUtils.isBlank((String)targetId)) {
            return null;
        }
        ProxyConnectorSelectionPredicate selectedProxy = new ProxyConnectorSelectionPredicate(sourceId, targetId);
        return (ProxyConnectorConfiguration)CollectionUtils.find((Collection)configuration.getProxyConnectors(), (Predicate)selectedProxy);
    }

    protected ProxyConnectorConfiguration getProxyConnectorConfiguration(ProxyConnector proxyConnector) {
        return proxyConnector == null ? null : (ProxyConnectorConfiguration)this.getModelMapper().map((Object)proxyConnector, ProxyConnectorConfiguration.class);
    }

    protected ProxyConnector getProxyConnector(ProxyConnectorConfiguration proxyConnectorConfiguration) {
        return proxyConnectorConfiguration == null ? null : (ProxyConnector)this.getModelMapper().map((Object)proxyConnectorConfiguration, ProxyConnector.class);
    }

    protected void validateProxyConnector(ProxyConnector proxyConnector) throws RepositoryAdminException {
        if (this.managedRepositoryAdmin.getManagedRepository(proxyConnector.getSourceRepoId()) == null) {
            throw new RepositoryAdminException("non valid ProxyConnector sourceRepo with id " + proxyConnector.getSourceRepoId() + " is not a ManagedRepository");
        }
        if (this.remoteRepositoryAdmin.getRemoteRepository(proxyConnector.getTargetRepoId()) == null) {
            throw new RepositoryAdminException("non valid ProxyConnector sourceRepo with id " + proxyConnector.getTargetRepoId() + " is not a RemoteRepository");
        }
    }
}

