/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.admin.repository;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.RepositoryCommonValidator;
import org.apache.archiva.admin.model.beans.AbstractRepository;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.configuration.ArchivaConfiguration;
import org.apache.archiva.configuration.Configuration;
import org.apache.archiva.redback.components.registry.Registry;
import org.apache.archiva.redback.components.scheduler.CronExpressionValidator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.GenericValidator;
import org.springframework.stereotype.Service;

@Service
public class DefaultRepositoryCommonValidator
implements RepositoryCommonValidator {
    @Inject
    private ArchivaConfiguration archivaConfiguration;
    @Inject
    @Named(value="commons-configuration")
    private Registry registry;

    public void basicValidation(AbstractRepository abstractRepository, boolean update) throws RepositoryAdminException {
        Configuration config = this.archivaConfiguration.getConfiguration();
        String repoId = abstractRepository.getId();
        if (!update) {
            if (config.getManagedRepositoriesAsMap().containsKey(repoId)) {
                throw new RepositoryAdminException("Unable to add new repository with id [" + repoId + "], that id already exists as a managed repository.");
            }
            if (config.getRepositoryGroupsAsMap().containsKey(repoId)) {
                throw new RepositoryAdminException("Unable to add new repository with id [" + repoId + "], that id already exists as a repository group.");
            }
            if (config.getRemoteRepositoriesAsMap().containsKey(repoId)) {
                throw new RepositoryAdminException("Unable to add new repository with id [" + repoId + "], that id already exists as a remote repository.");
            }
        }
        if (StringUtils.isBlank((String)repoId)) {
            throw new RepositoryAdminException("Repository ID cannot be empty.");
        }
        if (!GenericValidator.matchRegexp((String)repoId, (String)"^[a-zA-Z0-9._-]+$")) {
            throw new RepositoryAdminException("Invalid repository ID. Identifier must only contain alphanumeric characters, underscores(_), dots(.), and dashes(-).");
        }
        String name = abstractRepository.getName();
        if (StringUtils.isBlank((String)name)) {
            throw new RepositoryAdminException("repository name cannot be empty");
        }
        if (!GenericValidator.matchRegexp((String)name, (String)"^([a-zA-Z0-9.)/_(-]|\\s)+$")) {
            throw new RepositoryAdminException("Invalid repository name. Repository Name must only contain alphanumeric characters, white-spaces(' '), forward-slashes(/), open-parenthesis('('), close-parenthesis(')'),  underscores(_), dots(.), and dashes(-).");
        }
    }

    public void validateManagedRepository(ManagedRepository managedRepository) throws RepositoryAdminException {
        String cronExpression = managedRepository.getCronExpression();
        if (StringUtils.isNotBlank((String)cronExpression)) {
            CronExpressionValidator validator = new CronExpressionValidator();
            if (!validator.validate(cronExpression)) {
                throw new RepositoryAdminException("Invalid cron expression.", "cronExpression");
            }
        } else {
            throw new RepositoryAdminException("Cron expression cannot be empty.");
        }
        String repoLocation = this.removeExpressions(managedRepository.getLocation());
        if (!GenericValidator.matchRegexp((String)repoLocation, (String)"^[-a-zA-Z0-9._/~:?!&amp;=\\\\]+$")) {
            throw new RepositoryAdminException("Invalid repository location. Directory must only contain alphanumeric characters, equals(=), question-marks(?), exclamation-points(!), ampersands(&amp;), forward-slashes(/), back-slashes(\\), underscores(_), dots(.), colons(:), tildes(~), and dashes(-).", "location");
        }
    }

    public String removeExpressions(String directory) {
        String value = StringUtils.replace((String)directory, (String)"${appserver.base}", (String)this.getRegistry().getString("appserver.base", "${appserver.base}"));
        value = StringUtils.replace((String)value, (String)"${appserver.home}", (String)this.getRegistry().getString("appserver.home", "${appserver.home}"));
        return value;
    }

    public ArchivaConfiguration getArchivaConfiguration() {
        return this.archivaConfiguration;
    }

    public void setArchivaConfiguration(ArchivaConfiguration archivaConfiguration) {
        this.archivaConfiguration = archivaConfiguration;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }
}

