/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.admin.repository.remote;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.archiva.admin.model.AuditInformation;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.AbstractRepository;
import org.apache.archiva.admin.model.beans.RemoteRepository;
import org.apache.archiva.admin.model.remote.RemoteRepositoryAdmin;
import org.apache.archiva.admin.repository.AbstractRepositoryAdmin;
import org.apache.archiva.configuration.Configuration;
import org.apache.archiva.configuration.ProxyConnectorConfiguration;
import org.apache.archiva.configuration.RemoteRepositoryConfiguration;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="remoteRepositoryAdmin#default")
public class DefaultRemoteRepositoryAdmin
extends AbstractRepositoryAdmin
implements RemoteRepositoryAdmin {
    public List<RemoteRepository> getRemoteRepositories() throws RepositoryAdminException {
        ArrayList<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
        for (RemoteRepositoryConfiguration repositoryConfiguration : this.getArchivaConfiguration().getConfiguration().getRemoteRepositories()) {
            RemoteRepository remoteRepository = new RemoteRepository(repositoryConfiguration.getId(), repositoryConfiguration.getName(), repositoryConfiguration.getUrl(), repositoryConfiguration.getLayout(), repositoryConfiguration.getUsername(), repositoryConfiguration.getPassword(), repositoryConfiguration.getTimeout());
            remoteRepository.setDownloadRemoteIndex(repositoryConfiguration.isDownloadRemoteIndex());
            remoteRepository.setRemoteIndexUrl(repositoryConfiguration.getRemoteIndexUrl());
            remoteRepository.setCronExpression(repositoryConfiguration.getRefreshCronExpression());
            remoteRepository.setIndexDirectory(repositoryConfiguration.getIndexDir());
            remoteRepository.setRemoteDownloadNetworkProxyId(repositoryConfiguration.getRemoteDownloadNetworkProxyId());
            remoteRepository.setRemoteDownloadTimeout(repositoryConfiguration.getRemoteDownloadTimeout());
            remoteRepositories.add(remoteRepository);
        }
        return remoteRepositories;
    }

    public RemoteRepository getRemoteRepository(String repositoryId) throws RepositoryAdminException {
        for (RemoteRepository remoteRepository : this.getRemoteRepositories()) {
            if (!StringUtils.equals((String)repositoryId, (String)remoteRepository.getId())) continue;
            return remoteRepository;
        }
        return null;
    }

    public Boolean addRemoteRepository(RemoteRepository remoteRepository, AuditInformation auditInformation) throws RepositoryAdminException {
        this.triggerAuditEvent(remoteRepository.getId(), null, "Added Remote Repository", auditInformation);
        this.getRepositoryCommonValidator().basicValidation((AbstractRepository)remoteRepository, false);
        if (StringUtils.isEmpty((String)remoteRepository.getUrl())) {
            throw new RepositoryAdminException("url cannot be null");
        }
        remoteRepository.setUrl(StringUtils.trim((String)remoteRepository.getUrl()));
        RemoteRepositoryConfiguration remoteRepositoryConfiguration = this.getRemoteRepositoryConfiguration(remoteRepository);
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        configuration.addRemoteRepository(remoteRepositoryConfiguration);
        this.saveConfiguration(configuration);
        return Boolean.TRUE;
    }

    public Boolean deleteRemoteRepository(String repositoryId, AuditInformation auditInformation) throws RepositoryAdminException {
        this.triggerAuditEvent(repositoryId, null, "Deleted Remote Repository", auditInformation);
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        RemoteRepositoryConfiguration remoteRepositoryConfiguration = (RemoteRepositoryConfiguration)configuration.getRemoteRepositoriesAsMap().get(repositoryId);
        if (remoteRepositoryConfiguration == null) {
            throw new RepositoryAdminException("remoteRepository with id " + repositoryId + " not exist cannot remove it");
        }
        configuration.removeRemoteRepository(remoteRepositoryConfiguration);
        ArrayList proxyConnectors = new ArrayList(configuration.getProxyConnectors());
        for (ProxyConnectorConfiguration proxyConnector : proxyConnectors) {
            if (!StringUtils.equals((String)proxyConnector.getTargetRepoId(), (String)repositoryId)) continue;
            configuration.removeProxyConnector(proxyConnector);
        }
        this.saveConfiguration(configuration);
        return Boolean.TRUE;
    }

    public Boolean updateRemoteRepository(RemoteRepository remoteRepository, AuditInformation auditInformation) throws RepositoryAdminException {
        String repositoryId = remoteRepository.getId();
        this.triggerAuditEvent(repositoryId, null, "Updated Remote Repository", auditInformation);
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        RemoteRepositoryConfiguration remoteRepositoryConfiguration = (RemoteRepositoryConfiguration)configuration.getRemoteRepositoriesAsMap().get(repositoryId);
        if (remoteRepositoryConfiguration == null) {
            throw new RepositoryAdminException("remoteRepository with id " + repositoryId + " not exist cannot remove it");
        }
        configuration.removeRemoteRepository(remoteRepositoryConfiguration);
        remoteRepositoryConfiguration = this.getRemoteRepositoryConfiguration(remoteRepository);
        configuration.addRemoteRepository(remoteRepositoryConfiguration);
        this.saveConfiguration(configuration);
        return Boolean.TRUE;
    }

    public Map<String, RemoteRepository> getRemoteRepositoriesAsMap() throws RepositoryAdminException {
        HashMap<String, RemoteRepository> map = new HashMap<String, RemoteRepository>();
        for (RemoteRepository repo : this.getRemoteRepositories()) {
            map.put(repo.getId(), repo);
        }
        return map;
    }

    private RemoteRepositoryConfiguration getRemoteRepositoryConfiguration(RemoteRepository remoteRepository) {
        RemoteRepositoryConfiguration remoteRepositoryConfiguration = new RemoteRepositoryConfiguration();
        remoteRepositoryConfiguration.setId(remoteRepository.getId());
        remoteRepositoryConfiguration.setPassword(remoteRepository.getPassword());
        remoteRepositoryConfiguration.setTimeout(remoteRepository.getTimeout());
        remoteRepositoryConfiguration.setUrl(remoteRepository.getUrl());
        remoteRepositoryConfiguration.setUsername(remoteRepository.getUserName());
        remoteRepositoryConfiguration.setLayout(remoteRepository.getLayout());
        remoteRepositoryConfiguration.setName(remoteRepository.getName());
        remoteRepositoryConfiguration.setDownloadRemoteIndex(remoteRepository.isDownloadRemoteIndex());
        remoteRepositoryConfiguration.setRemoteIndexUrl(remoteRepository.getRemoteIndexUrl());
        remoteRepositoryConfiguration.setRefreshCronExpression(remoteRepository.getCronExpression());
        remoteRepositoryConfiguration.setIndexDir(remoteRepository.getIndexDirectory());
        remoteRepositoryConfiguration.setRemoteDownloadNetworkProxyId(remoteRepository.getRemoteDownloadNetworkProxyId());
        remoteRepositoryConfiguration.setRemoteDownloadTimeout(remoteRepository.getRemoteDownloadTimeout());
        return remoteRepositoryConfiguration;
    }
}

