/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.admin.repository.managed;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.admin.model.AuditInformation;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.AbstractRepository;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.admin.model.managed.ManagedRepositoryAdmin;
import org.apache.archiva.admin.repository.AbstractRepositoryAdmin;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridge;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridgeException;
import org.apache.archiva.configuration.Configuration;
import org.apache.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.archiva.configuration.ProxyConnectorConfiguration;
import org.apache.archiva.configuration.RepositoryGroupConfiguration;
import org.apache.archiva.metadata.repository.MetadataRepository;
import org.apache.archiva.metadata.repository.MetadataRepositoryException;
import org.apache.archiva.metadata.repository.RepositorySession;
import org.apache.archiva.metadata.repository.RepositorySessionFactory;
import org.apache.archiva.metadata.repository.stats.RepositoryStatisticsManager;
import org.apache.archiva.scheduler.repository.RepositoryArchivaTaskScheduler;
import org.apache.archiva.scheduler.repository.RepositoryTask;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.GenericValidator;
import org.apache.maven.index.NexusIndexer;
import org.apache.maven.index.context.IndexingContext;
import org.codehaus.plexus.redback.role.RoleManager;
import org.codehaus.plexus.redback.role.RoleManagerException;
import org.codehaus.plexus.taskqueue.TaskQueueException;
import org.codehaus.redback.components.scheduler.CronExpressionValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="managedRepositoryAdmin#default")
public class DefaultManagedRepositoryAdmin
extends AbstractRepositoryAdmin
implements ManagedRepositoryAdmin {
    public static final String REPOSITORY_LOCATION_VALID_EXPRESSION = "^[-a-zA-Z0-9._/~:?!&amp;=\\\\]+$";
    private Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String STAGE_REPO_ID_END = "-stage";
    @Inject
    @Named(value="archivaTaskScheduler#repository")
    private RepositoryArchivaTaskScheduler repositoryTaskScheduler;
    @Inject
    private RepositorySessionFactory repositorySessionFactory;
    @Inject
    private RepositoryStatisticsManager repositoryStatisticsManager;
    @Inject
    private PlexusSisuBridge plexusSisuBridge;
    @Inject
    protected RoleManager roleManager;

    public List<ManagedRepository> getManagedRepositories() throws RepositoryAdminException {
        List managedRepoConfigs = this.getArchivaConfiguration().getConfiguration().getManagedRepositories();
        ArrayList<ManagedRepository> managedRepos = new ArrayList<ManagedRepository>(managedRepoConfigs.size());
        for (ManagedRepositoryConfiguration repoConfig : managedRepoConfigs) {
            ManagedRepository repo = new ManagedRepository(repoConfig.getId(), repoConfig.getName(), repoConfig.getLocation(), repoConfig.getLayout(), repoConfig.isSnapshots(), repoConfig.isReleases(), repoConfig.isBlockRedeployments(), repoConfig.getRefreshCronExpression(), repoConfig.getIndexDir(), repoConfig.isScanned(), repoConfig.getDaysOlder(), repoConfig.getRetentionCount(), repoConfig.isDeleteReleasedSnapshots(), false);
            managedRepos.add(repo);
        }
        return managedRepos;
    }

    public Map<String, ManagedRepository> getManagedRepositoriesAsMap() throws RepositoryAdminException {
        List<ManagedRepository> managedRepositories = this.getManagedRepositories();
        HashMap<String, ManagedRepository> repositoriesMap = new HashMap<String, ManagedRepository>(managedRepositories.size());
        for (ManagedRepository managedRepository : managedRepositories) {
            repositoriesMap.put(managedRepository.getId(), managedRepository);
        }
        return repositoriesMap;
    }

    public ManagedRepository getManagedRepository(String repositoryId) throws RepositoryAdminException {
        List<ManagedRepository> repos = this.getManagedRepositories();
        for (ManagedRepository repo : repos) {
            if (!StringUtils.equals((String)repo.getId(), (String)repositoryId)) continue;
            return repo;
        }
        return null;
    }

    public Boolean addManagedRepository(ManagedRepository managedRepository, boolean needStageRepo, AuditInformation auditInformation) throws RepositoryAdminException {
        this.getRepositoryCommonValidator().basicValidation((AbstractRepository)managedRepository, false);
        this.triggerAuditEvent(managedRepository.getId(), null, "Added Managed Repository", auditInformation);
        return this.addManagedRepository(managedRepository.getId(), managedRepository.getLayout(), managedRepository.getName(), managedRepository.getLocation(), managedRepository.isBlockRedeployments(), managedRepository.isReleases(), managedRepository.isSnapshots(), needStageRepo, managedRepository.getCronExpression(), managedRepository.getIndexDirectory(), managedRepository.getDaysOlder(), managedRepository.getRetentionCount(), managedRepository.isDeleteReleasedSnapshots(), auditInformation, this.getArchivaConfiguration().getConfiguration()) != null;
    }

    private ManagedRepositoryConfiguration addManagedRepository(String repoId, String layout, String name, String location, boolean blockRedeployments, boolean releasesIncluded, boolean snapshotsIncluded, boolean stageRepoNeeded, String cronExpression, String indexDir, int daysOlder, int retentionCount, boolean deteleReleasedSnapshots, AuditInformation auditInformation, Configuration config) throws RepositoryAdminException {
        if (StringUtils.isNotBlank((String)cronExpression)) {
            CronExpressionValidator validator = new CronExpressionValidator();
            if (!validator.validate(cronExpression)) {
                throw new RepositoryAdminException("Invalid cron expression.");
            }
        } else {
            throw new RepositoryAdminException("Cron expression cannot be empty.");
        }
        String repoLocation = this.getRepositoryCommonValidator().removeExpressions(location);
        if (!GenericValidator.matchRegexp((String)repoLocation, (String)REPOSITORY_LOCATION_VALID_EXPRESSION)) {
            throw new RepositoryAdminException("Invalid repository location. Directory must only contain alphanumeric characters, equals(=), question-marks(?), exclamation-points(!), ampersands(&amp;), forward-slashes(/), back-slashes(\\), underscores(_), dots(.), colons(:), tildes(~), and dashes(-).");
        }
        ManagedRepositoryConfiguration repository = new ManagedRepositoryConfiguration();
        repository.setId(repoId);
        repository.setBlockRedeployments(blockRedeployments);
        repository.setReleases(releasesIncluded);
        repository.setSnapshots(snapshotsIncluded);
        repository.setName(name);
        repository.setLocation(repoLocation);
        repository.setLayout(layout);
        repository.setRefreshCronExpression(cronExpression);
        repository.setIndexDir(indexDir);
        repository.setDaysOlder(daysOlder);
        repository.setRetentionCount(retentionCount);
        repository.setDeleteReleasedSnapshots(deteleReleasedSnapshots);
        repository.setIndexDir(indexDir);
        try {
            this.addRepository(repository, config);
            this.addRepositoryRoles(repository);
            if (stageRepoNeeded) {
                ManagedRepositoryConfiguration stagingRepository = this.getStageRepoConfig(repository);
                this.addRepository(stagingRepository, config);
                this.addRepositoryRoles(stagingRepository);
                this.triggerAuditEvent(stagingRepository.getId(), null, "Added Managed Repository", auditInformation);
            }
        }
        catch (RoleManagerException e) {
            throw new RepositoryAdminException("failed to add repository roles " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryAdminException("failed to add repository " + e.getMessage(), (Throwable)e);
        }
        this.saveConfiguration(config);
        try {
            this.scanRepository(repoId, true);
        }
        catch (Exception e) {
            this.log.warn("Unable to scan repository [" + repoId + "]: " + e.getMessage(), (Throwable)e);
        }
        return repository;
    }

    public Boolean deleteManagedRepository(String repositoryId, AuditInformation auditInformation, boolean deleteContent) throws RepositoryAdminException {
        Configuration config = this.getArchivaConfiguration().getConfiguration();
        ManagedRepositoryConfiguration repository = config.findManagedRepositoryById(repositoryId);
        if (repository == null) {
            throw new RepositoryAdminException("A repository with that id does not exist");
        }
        this.triggerAuditEvent(repositoryId, null, "Deleted Managed Repository", auditInformation);
        this.deleteManagedRepository(repository, deleteContent, config, false);
        ManagedRepositoryConfiguration stagingRepository = this.getArchivaConfiguration().getConfiguration().findManagedRepositoryById(repositoryId + STAGE_REPO_ID_END);
        if (stagingRepository != null) {
            this.deleteManagedRepository(stagingRepository, deleteContent, config, true);
        }
        try {
            this.saveConfiguration(config);
        }
        catch (Exception e) {
            throw new RepositoryAdminException("Error saving configuration for delete action" + e.getMessage());
        }
        return Boolean.TRUE;
    }

    private Boolean deleteManagedRepository(ManagedRepositoryConfiguration repository, boolean deleteContent, Configuration config, boolean stagedOne) throws RepositoryAdminException {
        File dir;
        try {
            NexusIndexer nexusIndexer = (NexusIndexer)this.plexusSisuBridge.lookup(NexusIndexer.class);
            IndexingContext context = (IndexingContext)nexusIndexer.getIndexingContexts().get(repository.getId());
            if (context != null) {
                nexusIndexer.removeIndexingContext(context, deleteContent);
            }
        }
        catch (PlexusSisuBridgeException e) {
            throw new RepositoryAdminException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryAdminException(e.getMessage(), (Throwable)e);
        }
        if (!stagedOne) {
            RepositorySession repositorySession = this.getRepositorySessionFactory().createSession();
            try {
                MetadataRepository metadataRepository = repositorySession.getRepository();
                metadataRepository.removeRepository(repository.getId());
                this.log.debug("call repositoryStatisticsManager.deleteStatistics");
                this.getRepositoryStatisticsManager().deleteStatistics(metadataRepository, repository.getId());
                repositorySession.save();
            }
            catch (MetadataRepositoryException e) {
                throw new RepositoryAdminException(e.getMessage(), (Throwable)e);
            }
            finally {
                repositorySession.close();
            }
        }
        config.removeManagedRepository(repository);
        if (deleteContent && !FileUtils.deleteQuietly((File)(dir = new File(repository.getLocation())))) {
            throw new RepositoryAdminException("Cannot delete repository " + dir);
        }
        ArrayList proxyConnectors = new ArrayList(config.getProxyConnectors());
        for (ProxyConnectorConfiguration proxyConnector : proxyConnectors) {
            if (!StringUtils.equals((String)proxyConnector.getSourceRepoId(), (String)repository.getId())) continue;
            config.removeProxyConnector(proxyConnector);
        }
        Map repoToGroupMap = config.getRepositoryToGroupMap();
        if (repoToGroupMap != null && repoToGroupMap.containsKey(repository.getId())) {
            List repoGroups = (List)repoToGroupMap.get(repository.getId());
            for (String repoGroup : repoGroups) {
                RepositoryGroupConfiguration repositoryGroupConfiguration = config.findRepositoryGroupById(repoGroup);
                ArrayList repos = new ArrayList(repositoryGroupConfiguration.getRepositories());
                config.removeRepositoryGroup(repositoryGroupConfiguration);
                repos.remove(repository.getId());
                repositoryGroupConfiguration.setRepositories(repos);
                config.addRepositoryGroup(repositoryGroupConfiguration);
            }
        }
        try {
            this.removeRepositoryRoles(repository);
        }
        catch (RoleManagerException e) {
            throw new RepositoryAdminException("fail to remove repository roles for repository " + repository.getId() + " : " + e.getMessage(), (Throwable)e);
        }
        this.saveConfiguration(config);
        return Boolean.TRUE;
    }

    public Boolean updateManagedRepository(ManagedRepository managedRepository, boolean needStageRepo, AuditInformation auditInformation, boolean resetStats) throws RepositoryAdminException {
        ManagedRepositoryConfiguration stagingRepository;
        this.log.debug("updateManagedConfiguration repo {} needStage {} resetStats {} ", Arrays.asList(managedRepository, needStageRepo, resetStats).toArray());
        this.getRepositoryCommonValidator().basicValidation((AbstractRepository)managedRepository, true);
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        ManagedRepositoryConfiguration toremove = configuration.findManagedRepositoryById(managedRepository.getId());
        if (toremove != null) {
            configuration.removeManagedRepository(toremove);
        }
        if ((stagingRepository = this.getStageRepoConfig(toremove)) != null) {
            configuration.removeManagedRepository(stagingRepository);
        }
        ManagedRepositoryConfiguration managedRepositoryConfiguration = this.addManagedRepository(managedRepository.getId(), managedRepository.getLayout(), managedRepository.getName(), managedRepository.getLocation(), managedRepository.isBlockRedeployments(), managedRepository.isReleases(), managedRepository.isSnapshots(), needStageRepo, managedRepository.getCronExpression(), managedRepository.getIndexDirectory(), managedRepository.getDaysOlder(), managedRepository.getRetentionCount(), managedRepository.isDeleteReleasedSnapshots(), auditInformation, this.getArchivaConfiguration().getConfiguration());
        RepositorySession repositorySession = this.getRepositorySessionFactory().createSession();
        try {
            this.triggerAuditEvent(managedRepositoryConfiguration.getId(), null, "Updated Managed Repository", auditInformation);
            this.saveConfiguration(this.getArchivaConfiguration().getConfiguration());
            if (resetStats) {
                this.log.debug("call repositoryStatisticsManager.deleteStatistics");
                this.getRepositoryStatisticsManager().deleteStatistics(repositorySession.getRepository(), managedRepositoryConfiguration.getId());
                repositorySession.save();
            }
        }
        catch (MetadataRepositoryException e) {
            throw new RepositoryAdminException(e.getMessage(), (Throwable)e);
        }
        finally {
            repositorySession.close();
        }
        return true;
    }

    protected void addRepository(ManagedRepositoryConfiguration repository, Configuration configuration) throws RepositoryAdminException, IOException {
        File file = new File(repository.getLocation());
        repository.setLocation(file.getCanonicalPath());
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.exists() || !file.isDirectory()) {
            throw new RepositoryAdminException("Unable to add repository - no write access, can not create the root directory: " + file);
        }
        configuration.addManagedRepository(repository);
    }

    private ManagedRepositoryConfiguration getStageRepoConfig(ManagedRepositoryConfiguration repository) {
        ManagedRepositoryConfiguration stagingRepository = new ManagedRepositoryConfiguration();
        stagingRepository.setId(repository.getId() + STAGE_REPO_ID_END);
        stagingRepository.setLayout(repository.getLayout());
        stagingRepository.setName(repository.getName() + STAGE_REPO_ID_END);
        stagingRepository.setBlockRedeployments(repository.isBlockRedeployments());
        stagingRepository.setDaysOlder(repository.getDaysOlder());
        stagingRepository.setDeleteReleasedSnapshots(repository.isDeleteReleasedSnapshots());
        stagingRepository.setIndexDir(repository.getIndexDir());
        String path = repository.getLocation();
        int lastIndex = path.lastIndexOf(47);
        stagingRepository.setLocation(path.substring(0, lastIndex) + "/" + stagingRepository.getId());
        stagingRepository.setRefreshCronExpression(repository.getRefreshCronExpression());
        stagingRepository.setReleases(repository.isReleases());
        stagingRepository.setRetentionCount(repository.getRetentionCount());
        stagingRepository.setScanned(repository.isScanned());
        stagingRepository.setSnapshots(repository.isSnapshots());
        return stagingRepository;
    }

    public Boolean scanRepository(String repositoryId, boolean fullScan) {
        if (this.getRepositoryTaskScheduler().isProcessingRepositoryTask(repositoryId)) {
            this.log.info("scanning of repository with id {} already scheduled", (Object)repositoryId);
        }
        RepositoryTask task = new RepositoryTask();
        task.setRepositoryId(repositoryId);
        task.setScanAll(fullScan);
        try {
            this.getRepositoryTaskScheduler().queueTask(task);
        }
        catch (TaskQueueException e) {
            this.log.error("failed to schedule scanning of repo with id {}", (Object)repositoryId, (Object)e);
            return false;
        }
        return true;
    }

    protected void addRepositoryRoles(ManagedRepositoryConfiguration newRepository) throws RoleManagerException {
        String repoId = newRepository.getId();
        if (!this.getRoleManager().templatedRoleExists("archiva-repository-observer", repoId)) {
            this.getRoleManager().createTemplatedRole("archiva-repository-observer", repoId);
        }
        if (!this.getRoleManager().templatedRoleExists("archiva-repository-manager", repoId)) {
            this.getRoleManager().createTemplatedRole("archiva-repository-manager", repoId);
        }
    }

    protected void removeRepositoryRoles(ManagedRepositoryConfiguration existingRepository) throws RoleManagerException {
        String repoId = existingRepository.getId();
        if (this.getRoleManager().templatedRoleExists("archiva-repository-manager", repoId)) {
            this.getRoleManager().removeTemplatedRole("archiva-repository-manager", repoId);
        }
        if (this.getRoleManager().templatedRoleExists("archiva-repository-observer", repoId)) {
            this.getRoleManager().removeTemplatedRole("archiva-repository-observer", repoId);
        }
        this.log.debug("removed user roles associated with repository {}", (Object)repoId);
    }

    public RoleManager getRoleManager() {
        return this.roleManager;
    }

    public void setRoleManager(RoleManager roleManager) {
        this.roleManager = roleManager;
    }

    public RepositoryStatisticsManager getRepositoryStatisticsManager() {
        return this.repositoryStatisticsManager;
    }

    public void setRepositoryStatisticsManager(RepositoryStatisticsManager repositoryStatisticsManager) {
        this.repositoryStatisticsManager = repositoryStatisticsManager;
    }

    public RepositorySessionFactory getRepositorySessionFactory() {
        return this.repositorySessionFactory;
    }

    public void setRepositorySessionFactory(RepositorySessionFactory repositorySessionFactory) {
        this.repositorySessionFactory = repositorySessionFactory;
    }

    public RepositoryArchivaTaskScheduler getRepositoryTaskScheduler() {
        return this.repositoryTaskScheduler;
    }

    public void setRepositoryTaskScheduler(RepositoryArchivaTaskScheduler repositoryTaskScheduler) {
        this.repositoryTaskScheduler = repositoryTaskScheduler;
    }
}

