/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.admin.repository.group;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.archiva.admin.model.AuditInformation;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.admin.model.beans.RepositoryGroup;
import org.apache.archiva.admin.model.group.RepositoryGroupAdmin;
import org.apache.archiva.admin.model.managed.ManagedRepositoryAdmin;
import org.apache.archiva.admin.repository.AbstractRepositoryAdmin;
import org.apache.archiva.configuration.Configuration;
import org.apache.archiva.configuration.RepositoryGroupConfiguration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="repositoryGroupAdmin#default")
public class DefaultRepositoryGroupAdmin
extends AbstractRepositoryAdmin
implements RepositoryGroupAdmin {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Pattern REPO_GROUP_ID_PATTERN = Pattern.compile("[A-Za-z0-9\\._\\-]+");
    @Inject
    private ManagedRepositoryAdmin managedRepositoryAdmin;

    public List<RepositoryGroup> getRepositoriesGroups() throws RepositoryAdminException {
        ArrayList<RepositoryGroup> repositoriesGroups = new ArrayList<RepositoryGroup>();
        for (RepositoryGroupConfiguration repositoryGroupConfiguration : this.getArchivaConfiguration().getConfiguration().getRepositoryGroups()) {
            repositoriesGroups.add(new RepositoryGroup(repositoryGroupConfiguration.getId(), new ArrayList(repositoryGroupConfiguration.getRepositories())));
        }
        return repositoriesGroups;
    }

    public RepositoryGroup getRepositoryGroup(String repositoryGroupId) throws RepositoryAdminException {
        List<RepositoryGroup> repositoriesGroups = this.getRepositoriesGroups();
        for (RepositoryGroup repositoryGroup : repositoriesGroups) {
            if (!StringUtils.equals((String)repositoryGroupId, (String)repositoryGroup.getId())) continue;
            return repositoryGroup;
        }
        return null;
    }

    public Boolean addRepositoryGroup(RepositoryGroup repositoryGroup, AuditInformation auditInformation) throws RepositoryAdminException {
        this.validateRepositoryGroup(repositoryGroup, false);
        this.validateManagedRepositoriesExists(repositoryGroup.getRepositories());
        RepositoryGroupConfiguration repositoryGroupConfiguration = new RepositoryGroupConfiguration();
        repositoryGroupConfiguration.setId(repositoryGroup.getId());
        repositoryGroupConfiguration.setRepositories(repositoryGroup.getRepositories());
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        configuration.addRepositoryGroup(repositoryGroupConfiguration);
        this.saveConfiguration(configuration);
        this.triggerAuditEvent(repositoryGroup.getId(), null, "Added Repository Group", auditInformation);
        return Boolean.TRUE;
    }

    public Boolean deleteRepositoryGroup(String repositoryGroupId, AuditInformation auditInformation) throws RepositoryAdminException {
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        RepositoryGroupConfiguration repositoryGroupConfiguration = (RepositoryGroupConfiguration)configuration.getRepositoryGroupsAsMap().get(repositoryGroupId);
        if (repositoryGroupConfiguration == null) {
            throw new RepositoryAdminException("repositoryGroup with id " + repositoryGroupId + " doesn't not exists so cannot remove");
        }
        configuration.removeRepositoryGroup(repositoryGroupConfiguration);
        this.triggerAuditEvent(repositoryGroupId, null, "Deleted Repository Group", auditInformation);
        return Boolean.TRUE;
    }

    public Boolean updateRepositoryGroup(RepositoryGroup repositoryGroup, AuditInformation auditInformation) throws RepositoryAdminException {
        return this.updateRepositoryGroup(repositoryGroup, auditInformation, true);
    }

    private Boolean updateRepositoryGroup(RepositoryGroup repositoryGroup, AuditInformation auditInformation, boolean triggerAuditEvent) throws RepositoryAdminException {
        this.validateRepositoryGroup(repositoryGroup, true);
        this.validateManagedRepositoriesExists(repositoryGroup.getRepositories());
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        RepositoryGroupConfiguration repositoryGroupConfiguration = (RepositoryGroupConfiguration)configuration.getRepositoryGroupsAsMap().get(repositoryGroup.getId());
        configuration.removeRepositoryGroup(repositoryGroupConfiguration);
        repositoryGroupConfiguration.setRepositories(repositoryGroup.getRepositories());
        configuration.addRepositoryGroup(repositoryGroupConfiguration);
        this.saveConfiguration(configuration);
        if (triggerAuditEvent) {
            this.triggerAuditEvent(repositoryGroup.getId(), null, "Modify Repository Group", auditInformation);
        }
        return Boolean.TRUE;
    }

    public Boolean addRepositoryToGroup(String repositoryGroupId, String repositoryId, AuditInformation auditInformation) throws RepositoryAdminException {
        RepositoryGroup repositoryGroup = this.getRepositoryGroup(repositoryGroupId);
        if (repositoryGroup == null) {
            throw new RepositoryAdminException("repositoryGroup with id " + repositoryGroupId + " doesn't not exists so cannot add repository to it");
        }
        if (repositoryGroup.getRepositories().contains(repositoryId)) {
            throw new RepositoryAdminException("repositoryGroup with id " + repositoryGroupId + " already contain repository with id" + repositoryId);
        }
        this.validateManagedRepositoriesExists(Arrays.asList(repositoryId));
        repositoryGroup.addRepository(repositoryId);
        this.updateRepositoryGroup(repositoryGroup, auditInformation, false);
        this.triggerAuditEvent(repositoryGroup.getId(), null, "Added Repository to Group", auditInformation);
        return Boolean.TRUE;
    }

    public Boolean deleteRepositoryFromGroup(String repositoryGroupId, String repositoryId, AuditInformation auditInformation) throws RepositoryAdminException {
        RepositoryGroup repositoryGroup = this.getRepositoryGroup(repositoryGroupId);
        if (repositoryGroup == null) {
            throw new RepositoryAdminException("repositoryGroup with id " + repositoryGroupId + " doesn't not exists so cannot remove repository from it");
        }
        if (!repositoryGroup.getRepositories().contains(repositoryId)) {
            throw new RepositoryAdminException("repositoryGroup with id " + repositoryGroupId + " doesn't not contains repository with id" + repositoryId);
        }
        repositoryGroup.removeRepository(repositoryId);
        this.updateRepositoryGroup(repositoryGroup, auditInformation, false);
        this.triggerAuditEvent(repositoryGroup.getId(), null, "Deleted Repository from Group", auditInformation);
        return Boolean.TRUE;
    }

    public Map<String, RepositoryGroup> getRepositoryGroupsAsMap() throws RepositoryAdminException {
        List<RepositoryGroup> repositoriesGroups = this.getRepositoriesGroups();
        HashMap<String, RepositoryGroup> map = new HashMap<String, RepositoryGroup>(repositoriesGroups.size());
        for (RepositoryGroup repositoryGroup : repositoriesGroups) {
            map.put(repositoryGroup.getId(), repositoryGroup);
        }
        return map;
    }

    public Map<String, List<String>> getGroupToRepositoryMap() throws RepositoryAdminException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (ManagedRepository repo : this.getManagedRepositoryAdmin().getManagedRepositories()) {
            for (RepositoryGroup group : this.getRepositoriesGroups()) {
                if (group.getRepositories().contains(repo.getId())) continue;
                String groupId = group.getId();
                ArrayList<String> repos = (ArrayList<String>)map.get(groupId);
                if (repos == null) {
                    repos = new ArrayList<String>();
                    map.put(groupId, repos);
                }
                repos.add(repo.getId());
            }
        }
        return map;
    }

    public Map<String, List<String>> getRepositoryToGroupMap() throws RepositoryAdminException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (RepositoryGroup group : this.getRepositoriesGroups()) {
            for (String repositoryId : group.getRepositories()) {
                ArrayList<String> groups = (ArrayList<String>)map.get(repositoryId);
                if (groups == null) {
                    groups = new ArrayList<String>();
                    map.put(repositoryId, groups);
                }
                groups.add(group.getId());
            }
        }
        return map;
    }

    public Boolean validateRepositoryGroup(RepositoryGroup repositoryGroup, boolean updateMode) throws RepositoryAdminException {
        String repoGroupId = repositoryGroup.getId();
        if (StringUtils.isBlank((String)repoGroupId)) {
            throw new RepositoryAdminException("repositoryGroup id cannot be empty");
        }
        if (repoGroupId.length() > 100) {
            throw new RepositoryAdminException("Identifier [" + repoGroupId + "] is over the maximum limit of 100 characters");
        }
        Matcher matcher = REPO_GROUP_ID_PATTERN.matcher(repoGroupId);
        if (!matcher.matches()) {
            throw new RepositoryAdminException("Invalid character(s) found in identifier. Only the following characters are allowed: alphanumeric, '.', '-' and '_'");
        }
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        if (configuration.getRepositoryGroupsAsMap().containsKey(repoGroupId)) {
            if (!updateMode) {
                throw new RepositoryAdminException("Unable to add new repository group with id [" + repoGroupId + "], that id already exists as a repository group.");
            }
        } else {
            if (configuration.getManagedRepositoriesAsMap().containsKey(repoGroupId)) {
                throw new RepositoryAdminException("Unable to add new repository group with id [" + repoGroupId + "], that id already exists as a managed repository.");
            }
            if (configuration.getRemoteRepositoriesAsMap().containsKey(repoGroupId)) {
                throw new RepositoryAdminException("Unable to add new repository group with id [" + repoGroupId + "], that id already exists as a remote repository.");
            }
        }
        return Boolean.TRUE;
    }

    private void validateManagedRepositoriesExists(List<String> managedRepositoriesIds) throws RepositoryAdminException {
        for (String id : managedRepositoriesIds) {
            if (this.getManagedRepositoryAdmin().getManagedRepository(id) != null) continue;
            throw new RepositoryAdminException("managedRepository with id " + id + " not exists so cannot be used in a repositoryGroup");
        }
    }

    public ManagedRepositoryAdmin getManagedRepositoryAdmin() {
        return this.managedRepositoryAdmin;
    }

    public void setManagedRepositoryAdmin(ManagedRepositoryAdmin managedRepositoryAdmin) {
        this.managedRepositoryAdmin = managedRepositoryAdmin;
    }
}

